<?php
/* Copyright (c) 1998-2009 ILIAS open source, Extended GPL, see docs/LICENSE */

/**
*
* @author Nadia Ahmad <nahmad@databay.de>
* @version $Id:$
*/

include_once './Services/Mail/classes/class.ilMailNotification.php';
include_once 'Services/Mail/classes/class.ilMimeMail.php';

class ilPaymentNotification extends ilMailNotification
{
	public function __construct()
	{
		parent::__construct();
	}

	public function send()
	{
		global $lng;

		$customer_array = $this->_getObjectsToRemind();

		foreach ($customer_array as $user_id=>$objects_array)
		{

			$this->initLanguage($user_id);
			$user_lang = $this->getLanguage() ? $this->getLanguage() : $lng;

			$this->initMail();

			$this->setRecipients($user_id);
			$this->setSubject($this->getLanguageText('payment_reminder_notification_subject'));

			$this->setBody(ilMail::getSalutation($user_id, $this->getLanguage()));
			$this->appendBody("\n\n");
			$this->appendBody($user_lang->txt('bought_objects_expire_soon'));
			$this->appendBody("\n\n");

			foreach($objects_array as $key=>$pobject)
			{
				$this->appendBody("----------------------------------------------------------------------------------------------");
				$this->appendBody("\n\n");
				$this->appendBody($user_lang->txt('title').": ".$objects_array[$key]['object_title']."\n");
				$this->appendBody($user_lang->txt('access_enddate') .": ".$objects_array[$key]['access_enddate']);
				$this->appendBody("\n");
				
				$this->appendBody("\n\n");				
			}

			$this->appendBody("----------------------------------------------------------------------------------------------");

			//@todo fix this: $mailbox_link
			$this->appendBody($mailbox_link);
			$this->appendBody("\n\n");


			$this->appendBody(ilMail::_getAutoGeneratedMessageString($this->getLanguage()));
			$this->appendBody(ilMail::_getInstallationSignature());

			$mmail = new ilMimeMail();
			$mmail->autoCheck(false);
			$mmail->From('noreply');
			$mmail->To(ilObjUser::_lookupEmail($user_id));

			$mmail->Subject($this->getSubject());
			$mmail->Body($this->getBody());
			$mmail->Send();
		}
	}

	private function _getObjectsToRemind()
	{
		global $ilDB, $ilSetting;

		$num_days = $ilSetting->get('payment_notification_days');
		$reminder_date = date("Y-m-d H:i:s", time() + ($num_days * 24 * 60 * 60));

		$res = $ilDB->queryF('
			SELECT	ps.pobject_id, ps.customer_id, ps.object_title, ps.access_enddate, po.ref_id, po.subtype
			FROM	payment_statistic ps
			INNER JOIN payment_objects po ON po.pobject_id = ps.pobject_id
			LEFT JOIN  payment_prices pp ON pp.pobject_id = ps.pobject_id
			WHERE	ps.duration > %s
			AND ps.access_enddate = %s
			AND po.status > %s
			AND pp.extension = %s
			ORDER BY ps.customer_id ASC',
		array('integer', 'date', 'integer', 'integer'),
		array(0, $reminder_date, 0 , 1));

		$counter = 0;
		$objects = array();
		$customer_id = NULL;
		while($row = $ilDB->fetchAssoc($res))
		{
			if($customer_id == NULL)
			{
				$customer_id = $row['customer_id'];
			}
			else if ($customer_id != $row['customer_id'])
			{
				$counter = 0;
				$customer_id = $row['customer_id'];
			}

			$objects[$customer_id][$counter]['ref_id']		= $row['ref_id'];
			$objects[$customer_id][$counter]['pobject_id']	= $row['pobject_id'];
			$objects[$customer_id][$counter]['customer_id']	= $row['customer_id'];
			$objects[$customer_id][$counter]['access_enddate'] = $row['access_enddate'];
			$objects[$customer_id][$counter]['object_title']	= $row['object_title'];
			$objects[$customer_id][$counter]['subtype']		= $row['subtype'];

			$counter++;
		}
		return $objects;
	}
}
?>