<?php
/*
	+-----------------------------------------------------------------------------+
	| ILIAS open source                                                           |
	+-----------------------------------------------------------------------------+
	| Copyright (c) 1998-2006 ILIAS open source, University of Cologne            |
	|                                                                             |
	| This program is free software; you can redistribute it and/or               |
	| modify it under the terms of the GNU General Public License                 |
	| as published by the Free Software Foundation; either version 2              |
	| of the License, or (at your option) any later version.                      |
	|                                                                             |
	| This program is distributed in the hope that it will be useful,             |
	| but WITHOUT ANY WARRANTY; without even the implied warranty of              |
	| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               |
	| GNU General Public License for more details.                                |
	|                                                                             |
	| You should have received a copy of the GNU General Public License           |
	| along with this program; if not, write to the Free Software                 |
	| Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. |
	+-----------------------------------------------------------------------------+
*/

/** 
* Interface for shibboleth role assignment plugins
* 
* @author Stefan Meyer <meyer@leifos.com>
* @version $Id$
* 
*
* @ingroup ServicesAuthShibboleth
*/
interface ilShibbolethRoleAssignmentPlugin
{
	
	/**
	 * check role assignment for a specific plugin id 
	 * (defined in the shibboleth role assignment administration).
	 * 
	 * @param int	$a_plugin_id	Unique plugin id
	 * @param array $a_user_data	Array with user data ($_SERVER)
	 * @return bool whether the condition is fullfilled or not	
	 */
	public function checkRoleAssignment($a_plugin_id,$a_user_data);
}
?>
