<?php
/* Copyright (c) 1998-2011 ILIAS open source, Extended GPL, see docs/LICENSE */

include_once "./Services/Object/classes/class.ilObjectGUI.php";
include_once "./Modules/LearningModule/classes/class.ilObjContentObject.php";
include_once ("./Modules/LearningModule/classes/class.ilLMPageObjectGUI.php");
include_once ("./Modules/LearningModule/classes/class.ilStructureObjectGUI.php");
require_once 'Services/LinkChecker/interfaces/interface.ilLinkCheckerGUIRowHandling.php';

/**
 * Class ilObjContentObjectGUI
 *
 * @author Alex Killing <alex.killing@gmx.de>
 * @author Stefan Meyer <meyer@leifos.com>
 * @author Sascha Hofmann <saschahofmann@gmx.de>
 *
 * $Id$
 *
 * @ingroup ModulesLearningModule
 */
class ilObjContentObjectGUI extends ilObjectGUI implements ilLinkCheckerGUIRowHandling
{
	var $ctrl;

	/**
	* Constructor
	*
	* @access	public
	*/
	function ilObjContentObjectGUI($a_data,$a_id = 0,$a_call_by_reference = true, $a_prepare_output = false)
	{
		global $lng, $ilCtrl;
//echo "<br>ilobjcontobjgui-constructor-id-$a_id";
		$this->ctrl =& $ilCtrl;
		$lng->loadLanguageModule("content");
		$lng->loadLanguageModule("obj");
		parent::ilObjectGUI($a_data,$a_id,$a_call_by_reference,false);
	}

	/**
	* execute command
	*/
	function &executeCommand()
	{
		global $ilAccess, $lng, $ilTabs, $ilCtrl, $ilErr;
		
		if ($this->ctrl->getRedirectSource() == "ilinternallinkgui")
		{
			$this->explorer();
			return;
		}

		if ($this->ctrl->getCmdClass() == "ilinternallinkgui")
		{
			$this->ctrl->setReturn($this, "explorer");
		}

		// get next class that processes or forwards current command
		$next_class = $this->ctrl->getNextClass($this);

		// get current command
//		$cmd = $this->ctrl->getCmd("", array("downloadExportFile"));
		if ($_GET["to_props"] == 1)
		{
			$cmd = $this->ctrl->getCmd("properties");
		}
		else
		{
			$cmd = $this->ctrl->getCmd("chapters");
		}

		
//echo "-$cmd-".$next_class."-";
		switch($next_class)
		{
			case "illearningprogressgui":
				$this->addHeaderAction();
				$this->addLocations();
				include_once './Services/Tracking/classes/class.ilLearningProgressGUI.php';
				$this->setTabs("learning_progress");

				$new_gui =& new ilLearningProgressGUI(ilLearningProgressGUI::LP_CONTEXT_REPOSITORY,$this->object->getRefId());			
				$this->ctrl->forwardCommand($new_gui);

				break;

			case 'ilmdeditorgui':
				if(!$ilAccess->checkAccess('write','',$this->object->getRefId()))
				{
					$ilErr->raiseError($this->lng->txt('permission_denied'),$ilErr->WARNING);
				}
				
				$this->addHeaderAction();
				$this->addLocations();
				include_once 'Services/MetaData/classes/class.ilMDEditorGUI.php';
				$this->setTabs("meta");
				$md_gui =& new ilMDEditorGUI($this->object->getId(), 0, $this->object->getType());
				$md_gui->addObserver($this->object,'MDUpdateListener','General');

				$this->ctrl->forwardCommand($md_gui);
				break;

			case "ilobjstylesheetgui":
				$this->addLocations();
				include_once ("./Services/Style/classes/class.ilObjStyleSheetGUI.php");
				$this->ctrl->setReturn($this, "editStyleProperties");
				$style_gui =& new ilObjStyleSheetGUI("", $this->object->getStyleSheetId(), false, false);
				$style_gui->omitLocator();
				if ($cmd == "create" || $_GET["new_type"]=="sty")
				{
					$style_gui->setCreationMode(true);
				}
				$ret =& $this->ctrl->forwardCommand($style_gui);
				//$ret =& $style_gui->executeCommand();

				if ($cmd == "save" || $cmd == "copyStyle" || $cmd == "importStyle")
				{
					$style_id = $ret;
					$this->object->setStyleSheetId($style_id);
					$this->object->update();
					$this->ctrl->redirectByClass("ilobjstylesheetgui", "edit");
				}
				break;

			case "illmpageobjectgui":
				
				$ilTabs->setBackTarget($lng->txt("learning module"),
					$ilCtrl->getLinkTarget($this, "chapters"));
				$this->ctrl->saveParameter($this, array("obj_id"));
				$this->addLocations();
				$this->ctrl->setReturn($this, "chapters");
//echo "!";
				//$this->lm_obj =& $this->ilias->obj_factory->getInstanceByRefId($this->ref_id);

				$pg_gui =& new ilLMPageObjectGUI($this->object);
				if ($_GET["obj_id"] != "")
				{
					$obj =& ilLMObjectFactory::getInstance($this->object, $_GET["obj_id"]);
					$pg_gui->setLMPageObject($obj);
				}
				//$ret =& $pg_gui->executeCommand();
				$ret =& $this->ctrl->forwardCommand($pg_gui);
				if ($cmd == "save" || $cmd == "cancel")
				{
//					$this->ctrl->redirect($this, "pages");
				}
				break;

			case "ilstructureobjectgui":
				$ilTabs->setBackTarget($lng->txt("learning module"),
					$ilCtrl->getLinkTarget($this, "chapters"));

				$this->ctrl->saveParameter($this, array("obj_id"));
				$this->addLocations();
				$this->ctrl->setReturn($this, "chapters");
				$st_gui =& new ilStructureObjectGUI($this->object, $this->object->lm_tree);
				if ($_GET["obj_id"] != "")
				{
					$obj =& ilLMObjectFactory::getInstance($this->object, $_GET["obj_id"]);
					$st_gui->setStructureObject($obj);
				}
				//$ret =& $st_gui->executeCommand();
				$ret =& $this->ctrl->forwardCommand($st_gui);
				if ($cmd == "save" || $cmd == "cancel")
				{
					if ($_GET["obj_id"] == "")
					{
						$this->ctrl->redirect($this, "chapters");
					}
					else
					{
						$this->ctrl->setCmd("subchap");
						$this->executeCommand();
					}
				}
				break;

			case 'ilpermissiongui':
				if (strtolower($_GET["baseClass"]) == "iladministrationgui")
				{
					$this->prepareOutput();
				}
				else
				{
					$this->addHeaderAction();
					$this->addLocations(true);
					$this->setTabs("perm");
				}
				include_once("Services/AccessControl/classes/class.ilPermissionGUI.php");
				$perm_gui =& new ilPermissionGUI($this);
				$ret =& $this->ctrl->forwardCommand($perm_gui);
				break;

			// infoscreen
			case 'ilinfoscreengui':
				$this->addHeaderAction();
				$this->addLocations(true);
				$this->setTabs("info");
				include_once("./Services/InfoScreen/classes/class.ilInfoScreenGUI.php");
				$info = new ilInfoScreenGUI($this);
				$info->enablePrivateNotes();
				$info->enableLearningProgress();
		
				$info->enableNews();
				if ($ilAccess->checkAccess("write", "", $_GET["ref_id"]))
				{
					$info->enableNewsEditing();
					$info->setBlockProperty("news", "settings", true);
				}
				
				// show standard meta data section
				$info->addMetaDataSections($this->object->getId(), 0,
					$this->object->getType());
		
				$ret =& $this->ctrl->forwardCommand($info);
				break;
			
			case "ilexportgui":
				$this->addHeaderAction();
				$this->addLocations(true);
				$this->setTabs("export");
				include_once("./Services/Export/classes/class.ilExportGUI.php");
				$exp_gui = new ilExportGUI($this);
				$exp_gui->addFormat("xml", "", $this, "export");
				include_once("./Services/Object/classes/class.ilObjectTranslation.php");
				$ot = ilObjectTranslation::getInstance($this->object->getId());
				if ($ot->getContentActivated())
				{
					$lng->loadLanguageModule("meta");
					$langs = $ot->getLanguages();
					foreach ($langs as $l => $ldata)
					{
						$exp_gui->addFormat("html_".$l, "HTML (".$lng->txt("meta_l_".$l).")", $this, "exportHTML");
					}
				}
				else
				{
					$exp_gui->addFormat("html", "", $this, "exportHTML");
				}

				$exp_gui->addFormat("scorm", "", $this, "exportSCORM");
				$exp_gui->addCustomColumn($lng->txt("cont_public_access"),
						$this, "getPublicAccessColValue");
				$exp_gui->addCustomMultiCommand($lng->txt("cont_public_access"),
						$this, "publishExportFile");
				$ret = $this->ctrl->forwardCommand($exp_gui);
				break;

			case 'ilobjecttranslationgui':
				$this->addHeaderAction();
				$this->addLocations(true);
				//$this->checkPermissionBool("write");
				//$this->prepareOutput();
				//$this->tabs_gui->setTabActive('export');
				$this->setTabs("settings");
				$this->setSubTabs("obj_multilinguality");
				include_once("./Services/Object/classes/class.ilObjectTranslationGUI.php");
				$transgui = new ilObjectTranslationGUI($this);
				$transgui->setTitleDescrOnlyMode(false);
				$this->ctrl->forwardCommand($transgui);
				break;


			case "ilcommonactiondispatchergui":
				include_once("Services/Object/classes/class.ilCommonActionDispatcherGUI.php");
				$gui = ilCommonActionDispatcherGUI::getInstanceFromAjaxCall();
				$this->ctrl->forwardCommand($gui);
				break;

			case 'ilobjectcopygui':
				$this->prepareOutput();
				include_once './Services/Object/classes/class.ilObjectCopyGUI.php';
				$cp = new ilObjectCopyGUI($this);
				$cp->setType('lm');
				$this->ctrl->forwardCommand($cp);
				break;

			default:
				$new_type = $_POST["new_type"]
					? $_POST["new_type"]
					: $_GET["new_type"];


				if ($cmd == "create" &&
					!in_array($new_type, array("dbk", "lm")))
				{
					//$this->addLocations();
					switch ($new_type)
					{
						case "pg":
							$this->setTabs();
							$this->ctrl->setCmdClass("ilLMPageObjectGUI");
							$ret =& $this->executeCommand();
							break;

						case "st":
							$this->setTabs();
							$this->ctrl->setCmdClass("ilStructureObjectGUI");
							$ret =& $this->executeCommand();
							break;
					}
				}
				else
				{
					// creation of new dbk/lm in repository
					if ($this->getCreationMode() == true &&
						in_array($new_type, array("dbk", "lm")))
					{
						$this->prepareOutput();
						if ($cmd == "")			// this may be due to too big upload files
						{
							$cmd = "create";
						}
						$cmd .= "Object";
						$ret =& $this->$cmd();
					}
					else
					{
						$this->addHeaderAction();
						$this->addLocations();
						$ret =& $this->$cmd();
					}
				}
				break;
		}
		return $ret;
	}

	function _forwards()
	{
		return array("ilLMPageObjectGUI", "ilStructureObjectGUI","ilObjStyleSheetGUI");
	}

	/**
	* edit properties form
	*/
	function properties()
	{
		global $lng;

		$lng->loadLanguageModule("style");
		$this->setTabs("settings");
		$this->setSubTabs("settings");

		// lm properties
		$this->initPropertiesForm();
		$this->getPropertiesFormValues();
		
		if($this->object->getType() == "lm")
		{
			// Edit ecs export settings
			include_once 'Modules/LearningModule/classes/class.ilECSLearningModuleSettings.php';
			$ecs = new ilECSLearningModuleSettings($this->object);		
			$ecs->addSettingsToForm($this->form, 'lm');					
		}		
		
		$this->tpl->setContent($this->form->getHTML());
	}
	
	/**
	* Init properties form
	*/
	function initPropertiesForm()
	{
		global $ilCtrl, $lng;
		
		include_once("./Services/Form/classes/class.ilPropertyFormGUI.php");
		$this->form = new ilPropertyFormGUI();
		
		// title
		$ti = new ilTextInputGUI($lng->txt("title"), "title");
		//$ti->setMaxLength();
		//$ti->setSize();
		//$ti->setInfo($lng->txt(""));
		$ti->setRequired(true);
		$this->form->addItem($ti);
		
		// description
		$ta = new ilTextAreaInputGUI($lng->txt("desc"), "description");
		//$ta->setCols();
		//$ta->setRows();
		//$ta->setInfo($lng->txt(""));
		$this->form->addItem($ta);

		$lng->loadLanguageModule("rep");
		$section = new ilFormSectionHeaderGUI();
		$section->setTitle($this->lng->txt('rep_activation_availability'));
		$this->form->addItem($section);

		// online
		$online = new ilCheckboxInputGUI($lng->txt("cont_online"), "cobj_online");
		$this->form->addItem($online);

		// presentation
		$section = new ilFormSectionHeaderGUI();
		$section->setTitle($this->lng->txt('cont_presentation'));
		$this->form->addItem($section);

		// default layout
		$layout = self::getLayoutOption($lng->txt("cont_def_layout"), "lm_layout");
		$this->form->addItem($layout);

		// layout per page
		$lpp = new ilCheckboxInputGUI($lng->txt("cont_layout_per_page"), "layout_per_page");
		$lpp->setInfo($this->lng->txt("cont_layout_per_page_info"));
		$this->form->addItem($lpp);

		// page header
		$page_header = new ilSelectInputGUI($lng->txt("cont_page_header"), "lm_pg_header");
		$option = array ("st_title" => $this->lng->txt("cont_st_title"),
			"pg_title" => $this->lng->txt("cont_pg_title"),
			"none" => $this->lng->txt("cont_none"));
		$page_header->setOptions($option);
		$this->form->addItem($page_header);
		
		// chapter numeration
		$chap_num = new ilCheckboxInputGUI($lng->txt("cont_act_number"), "cobj_act_number");
		$this->form->addItem($chap_num);

		// toc mode
		$toc_mode = new ilSelectInputGUI($lng->txt("cont_toc_mode"), "toc_mode");
		$option = array ("chapters" => $this->lng->txt("cont_chapters_only"),
			"pages" => $this->lng->txt("cont_chapters_and_pages"));
		$toc_mode->setOptions($option);
		$this->form->addItem($toc_mode);

		// synchronize frames
		/*
		$synch = new ilCheckboxInputGUI($lng->txt("cont_synchronize_frames"), "cobj_clean_frames");
		$synch->setInfo($this->lng->txt("cont_synchronize_frames_desc"));
		$this->form->addItem($synch);*/

		// show progress icons
		$progr_icons = new ilCheckboxInputGUI($lng->txt("cont_progress_icons"), "progr_icons");
		$progr_icons->setInfo($this->lng->txt("cont_progress_icons_info"));
		$this->form->addItem($progr_icons);

		// self assessment
		$section = new ilFormSectionHeaderGUI();
		$section->setTitle($this->lng->txt('cont_self_assessment'));
		$this->form->addItem($section);

		// tries
		$radg = new ilRadioGroupInputGUI($lng->txt("cont_tries"), "store_tries");
		$radg->setValue(0);
		$op1 = new ilRadioOption($lng->txt("cont_tries_reset_on_visit"), 0,$lng->txt("cont_tries_reset_on_visit_info"));
		$radg->addOption($op1);
		$op2 = new ilRadioOption($lng->txt("cont_tries_store"), 1,$lng->txt("cont_tries_store_info"));
		$radg->addOption($op2);
		$this->form->addItem($radg);

		// restrict forward navigation
		$qfeed = new ilCheckboxInputGUI($lng->txt("cont_restrict_forw_nav"), "restrict_forw_nav");
		$qfeed->setInfo($this->lng->txt("cont_restrict_forw_nav_info"));
		$this->form->addItem($qfeed);

			// notification
			$not = new ilCheckboxInputGUI($lng->txt("cont_notify_on_blocked_users"), "notification_blocked_users");
			$not->setInfo($this->lng->txt("cont_notify_on_blocked_users_info"));
			$qfeed->addSubItem($not);

		// disable default feedback for questions
		$qfeed = new ilCheckboxInputGUI($lng->txt("cont_disable_def_feedback"), "disable_def_feedback");
		$qfeed->setInfo($this->lng->txt("cont_disable_def_feedback_info"));
		$this->form->addItem($qfeed);

		// additional features
		$section = new ilFormSectionHeaderGUI();
		$section->setTitle($this->lng->txt('obj_features'));
		$this->form->addItem($section);

		// public notes
		if (!$this->ilias->getSetting('disable_comments'))
		{
			$this->lng->loadLanguageModule("notes");
			$pub_nodes = new ilCheckboxInputGUI($lng->txt("notes_comments"), "cobj_pub_notes");
			$pub_nodes->setInfo($this->lng->txt("cont_lm_comments_desc"));
			$this->form->addItem($pub_nodes);
		}

		// history user comments
		$com = new ilCheckboxInputGUI($lng->txt("enable_hist_user_comments"), "cobj_user_comments");
		$com->setInfo($this->lng->txt("enable_hist_user_comments_desc"));
		$this->form->addItem($com);

		// rating
		$this->lng->loadLanguageModule('rating');
		$rate = new ilCheckboxInputGUI($this->lng->txt('rating_activate_rating'), 'rating');
		$rate->setInfo($this->lng->txt('rating_activate_rating_info'));
		$this->form->addItem($rate);
		$ratep = new ilCheckboxInputGUI($this->lng->txt('lm_activate_rating'), 'rating_pages');
		$this->form->addItem($ratep);

		$this->form->setTitle($lng->txt("cont_lm_properties"));
		$this->form->addCommandButton("saveProperties", $lng->txt("save"));
		$this->form->setFormAction($ilCtrl->getFormAction($this));
	}

	/**
	* Get values for properties form
	*/
	function getPropertiesFormValues()
	{
		global $ilUser;

		$values = array();

		$title = $this->object->getTitle();
		$description = $this->object->getDescription();
		include_once("./Services/Object/classes/class.ilObjectTranslation.php");
		$ot = ilObjectTranslation::getInstance($this->object->getId());
		if ($ot->getContentActivated())
		{
			$title = $ot->getDefaultTitle();
			$description = $ot->getDefaultDescription();
		}

		$values["title"] = $title;
		$values["description"] = $description;
		if ($this->object->getOnline())
		{
			$values["cobj_online"] = true;
		}
		$values["lm_layout"] = $this->object->getLayout();
		$values["lm_pg_header"] = $this->object->getPageHeader();
		if ($this->object->isActiveNumbering())
		{
			$values["cobj_act_number"] = true;
		}
		$values["toc_mode"] = $this->object->getTOCMode();
		if ($this->object->publicNotes())
		{
			$values["cobj_pub_notes"] = true;
		}
		if ($this->object->cleanFrames())
		{
			$values["cobj_clean_frames"] = true;
		}
		if ($this->object->isActiveHistoryUserComments())
		{
			$values["cobj_user_comments"] = true;
		}
		$values["layout_per_page"] = $this->object->getLayoutPerPage();
		$values["rating"] = $this->object->hasRating();
		$values["rating_pages"] = $this->object->hasRatingPages();
		$values["disable_def_feedback"] = $this->object->getDisableDefaultFeedback();
		$values["progr_icons"] = $this->object->getProgressIcons();
		$values["store_tries"] = $this->object->getStoreTries();
		$values["restrict_forw_nav"] = $this->object->getRestrictForwardNavigation();

		include_once "./Services/Notification/classes/class.ilNotification.php";
		$values["notification_blocked_users"] = ilNotification::hasNotification(
			ilNotification::TYPE_LM_BLOCKED_USERS, $ilUser->getId(),
			$this->object->getId());

		$this->form->setValuesByArray($values);
	}
	
	/**
	* save properties
	*/
	function saveProperties()
	{
		global $lng, $ilUser;

		$valid = false;
		$this->initPropertiesForm();
		if ($this->form->checkInput())
		{
			include_once("./Services/Object/classes/class.ilObjectTranslation.php");
			$ot = ilObjectTranslation::getInstance($this->object->getId());
			if ($ot->getContentActivated())
			{
				$ot->setDefaultTitle($_POST['title']);
				$ot->setDefaultDescription($_POST['description']);
				$ot->save();
			}

			$this->object->setTitle($_POST['title']);
			$this->object->setDescription($_POST['description']);
			$this->object->setLayout($_POST["lm_layout"]);
			$this->object->setPageHeader($_POST["lm_pg_header"]);
			$this->object->setTOCMode($_POST["toc_mode"]);
			$this->object->setOnline($_POST["cobj_online"]);
			$this->object->setActiveNumbering($_POST["cobj_act_number"]);
			$this->object->setCleanFrames($_POST["cobj_clean_frames"]);
			if (!$this->ilias->getSetting('disable_comments'))
			{
				$this->object->setPublicNotes($_POST["cobj_pub_notes"]);
			}
			$this->object->setHistoryUserComments($_POST["cobj_user_comments"]);
			$this->object->setLayoutPerPage($_POST["layout_per_page"]);
			$this->object->setRating($_POST["rating"]);
			$this->object->setRatingPages($_POST["rating_pages"]);
			$this->object->setDisableDefaultFeedback((int) $_POST["disable_def_feedback"]);
			$this->object->setProgressIcons((int) $_POST["progr_icons"]);

			$add_info = "";
			if ($_POST["restrict_forw_nav"] && !$_POST["store_tries"])
			{
				$_POST["store_tries"] = 1;
				$add_info = "</br>".$lng->txt("cont_automatically_set_store_tries");
				$add_info = str_replace("$1", $lng->txt("cont_tries_store"), $add_info);
				$add_info = str_replace("$2", $lng->txt("cont_restrict_forw_nav"), $add_info);
			}

			$this->object->setStoreTries((int) $_POST["store_tries"]);
			$this->object->setRestrictForwardNavigation((int) $_POST["restrict_forw_nav"]);
			$this->object->updateProperties();
			$this->object->update();

			include_once "./Services/Notification/classes/class.ilNotification.php";
			ilNotification::setNotification(ilNotification::TYPE_LM_BLOCKED_USERS,
				$ilUser->getId(), $this->object->getId(),
				(bool)$this->form->getInput("notification_blocked_users"));


			if($this->object->getType() == 'lm')
			{
				// Update ecs export settings
				include_once 'Modules/LearningModule/classes/class.ilECSLearningModuleSettings.php';	
				$ecs = new ilECSLearningModuleSettings($this->object);			
				if($ecs->handleSettingsUpdate())					
				{
					$valid = true;									
				}
			}
			else
			{
				$valid = true;
			}
		}
		
		if($valid)
		{
			ilUtil::sendSuccess($this->lng->txt("msg_obj_modified").$add_info, true);
			$this->ctrl->redirect($this, "properties");
		}
		else
		{
			$lng->loadLanguageModule("style");
			$this->setTabs("settings");
			$this->setSubTabs("cont_general_properties");

			$this->form->setValuesByPost();
			$this->tpl->setContent($this->form->getHTML());
		}
	}

	/**
	* Edit style properties
	*/
	function editStyleProperties()
	{
		global $tpl;
		
		$this->initStylePropertiesForm();
		$tpl->setContent($this->form->getHTML());
	}
	
	/**
	* Init style properties form
	*/
	function initStylePropertiesForm()
	{
		global $ilCtrl, $lng, $ilTabs, $ilSetting;
		
		$lng->loadLanguageModule("style");
		$this->setTabs();
		$ilTabs->setTabActive("settings");
		$this->setSubTabs("cont_style");

		include_once("./Services/Form/classes/class.ilPropertyFormGUI.php");
		$this->form = new ilPropertyFormGUI();
		
		$fixed_style = $ilSetting->get("fixed_content_style_id");
		$style_id = $this->object->getStyleSheetId();

		if ($fixed_style > 0)
		{
			$st = new ilNonEditableValueGUI($lng->txt("cont_current_style"));
			$st->setValue(ilObject::_lookupTitle($fixed_style)." (".
				$this->lng->txt("global_fixed").")");
			$this->form->addItem($st);
		}
		else
		{
			$st_styles = ilObjStyleSheet::_getStandardStyles(true, false,
				$_GET["ref_id"]);

			$st_styles[0] = $this->lng->txt("default");
			ksort($st_styles);

			if ($style_id > 0)
			{
				// individual style
				if (!ilObjStyleSheet::_lookupStandard($style_id))
				{
					$st = new ilNonEditableValueGUI($lng->txt("cont_current_style"));
					$st->setValue(ilObject::_lookupTitle($style_id));
					$this->form->addItem($st);

//$this->ctrl->getLinkTargetByClass("ilObjStyleSheetGUI", "edit"));

					// delete command
					$this->form->addCommandButton("editStyle",
						$lng->txt("cont_edit_style"));
					$this->form->addCommandButton("deleteStyle",
						$lng->txt("cont_delete_style"));
//$this->ctrl->getLinkTargetByClass("ilObjStyleSheetGUI", "delete"));
				}
			}

			if ($style_id <= 0 || ilObjStyleSheet::_lookupStandard($style_id))
			{
				$style_sel = ilUtil::formSelect ($style_id, "style_id",
					$st_styles, false, true);
				$style_sel = new ilSelectInputGUI($lng->txt("cont_current_style"), "style_id");
				$style_sel->setOptions($st_styles);
				$style_sel->setValue($style_id);
				$this->form->addItem($style_sel);
//$this->ctrl->getLinkTargetByClass("ilObjStyleSheetGUI", "create"));
				$this->form->addCommandButton("saveStyleSettings",
						$lng->txt("save"));
				$this->form->addCommandButton("createStyle",
					$lng->txt("sty_create_ind_style"));
			}
		}
		$this->form->setTitle($lng->txt("cont_style"));
		$this->form->setFormAction($ilCtrl->getFormAction($this));
	}
	
	/**
	* Create Style
	*/
	function createStyle()
	{
		global $ilCtrl;

		$ilCtrl->redirectByClass("ilobjstylesheetgui", "create");
	}
	
	/**
	* Edit Style
	*/
	function editStyle()
	{
		global $ilCtrl;

		$ilCtrl->redirectByClass("ilobjstylesheetgui", "edit");
	}

	/**
	* Delete Style
	*/
	function deleteStyle()
	{
		global $ilCtrl;

		$ilCtrl->redirectByClass("ilobjstylesheetgui", "delete");
	}

	/**
	* Save style settings
	*/
	function saveStyleSettings()
	{
		global $ilSetting;
	
		if ($ilSetting->get("fixed_content_style_id") <= 0 &&
			(ilObjStyleSheet::_lookupStandard($this->object->getStyleSheetId())
			|| $this->object->getStyleSheetId() == 0))
		{
			$this->object->setStyleSheetId(ilUtil::stripSlashes($_POST["style_id"]));
			$this->object->update();
			ilUtil::sendSuccess($this->lng->txt("msg_obj_modified"), true);
		}
		$this->ctrl->redirect($this, "editStyleProperties");
	}

	/**
	 * Init menu form
	 */
	public function initMenuForm()
	{
		global $lng, $ilCtrl;
	
		include_once("Services/Form/classes/class.ilPropertyFormGUI.php");
		$form = new ilPropertyFormGUI();
	
		// enable menu
		$menu = new ilCheckboxInputGUI($this->lng->txt("cont_active"), "cobj_act_lm_menu");
		$menu->setChecked($this->object->isActiveLMMenu());
		$form->addItem($menu);
		
		// toc
		$toc = new ilCheckboxInputGUI($this->lng->txt("cont_toc"), "cobj_act_toc");
		$toc->setChecked($this->object->isActiveTOC());
		$form->addItem($toc);
		
		// print view
		$print = new ilCheckboxInputGUI($this->lng->txt("cont_print_view"), "cobj_act_print");
		$print->setChecked($this->object->isActivePrintView());
		$form->addItem($print);
		
			// prevent glossary appendix
			$glo = new ilCheckboxInputGUI($this->lng->txt("cont_print_view_pre_glo"), "cobj_act_print_prev_glo");
			$glo->setChecked($this->object->isActivePreventGlossaryAppendix());
			$print->addSubItem($glo);
	
			// hide header and footer in print view
			$hhfp = new ilCheckboxInputGUI($this->lng->txt("cont_hide_head_foot_print"), "hide_head_foot_print");
			$hhfp->setChecked($this->object->getHideHeaderFooterPrint());
			$print->addSubItem($hhfp);
	
		// downloads
		$no_download_file_available =
			" ".$lng->txt("cont_no_download_file_available").
			" <a href='".$ilCtrl->getLinkTargetByClass("ilexportgui", "")."'>".$lng->txt("change")."</a>";
		$types = array("xml", "html", "scorm");
		foreach($types as $type)
		{
			if ($this->object->getPublicExportFile($type) != "")
			{
				if (is_file($this->object->getExportDirectory($type)."/".
					$this->object->getPublicExportFile($type)))
				{
					$no_download_file_available = "";
				}
			}
		}
		$dl = new ilCheckboxInputGUI($this->lng->txt("cont_downloads"), "cobj_act_downloads");
		$dl->setInfo($this->lng->txt("cont_downloads_desc").$no_download_file_available);
		$dl->setChecked($this->object->isActiveDownloads());
		$form->addItem($dl);
		
			// downloads in public area
			$pdl = new ilCheckboxInputGUI($this->lng->txt("cont_downloads_public_desc"), "cobj_act_downloads_public");
			$pdl->setChecked($this->object->isActiveDownloadsPublic());
			$dl->addSubItem($pdl);
			
		$form->addCommandButton("saveMenuProperties", $lng->txt("save"));
	                
		$form->setTitle($lng->txt("cont_lm_menu"));
		$form->setFormAction($ilCtrl->getFormAction($this));
		
		return $form;
	}
	
	/**
	 * Edit menu properies
	 */
	function editMenuProperties()
	{
		global $lng, $ilTabs, $ilCtrl, $tpl, $ilToolbar;

		$lng->loadLanguageModule("style");
		$this->setTabs();
		$ilTabs->setTabActive("settings");
		$this->setSubTabs("cont_lm_menu");
		
		$ilToolbar->setFormAction($ilCtrl->getFormAction($this));
		$ilToolbar->addFormButton($this->lng->txt("add_menu_entry"), "addMenuEntry");
		$ilToolbar->setCloseFormTag(false);
	
		$form = $this->initMenuForm();
		$form->setOpenTag(false);
		$form->setCloseTag(false);
		
		$this->__initLMMenuEditor();
		$entries = $this->lmme_obj->getMenuEntries();
		include_once("./Modules/LearningModule/classes/class.ilLMMenuItemsTableGUI.php");
		$table = new ilLMMenuItemsTableGUI($this, "editMenuProperties", $this->lmme_obj);
		$table->setOpenFormTag(false);
		
		$tpl->setContent($form->getHTML()."<br />".$table->getHTML());
	}

	/**
	* save properties
	*/
	function saveMenuProperties()
	{
		global $ilias;

		$this->object->setActiveLMMenu((int) $_POST["cobj_act_lm_menu"]);
		$this->object->setActiveTOC((int) $_POST["cobj_act_toc"]);
		$this->object->setActivePrintView((int) $_POST["cobj_act_print"]);
		$this->object->setActivePreventGlossaryAppendix((int) $_POST["cobj_act_print_prev_glo"]);
		$this->object->setHideHeaderFooterPrint((int) $_POST["hide_head_foot_print"]);
		$this->object->setActiveDownloads((int) $_POST["cobj_act_downloads"]);
		$this->object->setActiveDownloadsPublic((int) $_POST["cobj_act_downloads_public"]);
		$this->object->updateProperties();

		$this->__initLMMenuEditor();
//var_dump($_POST["menu_entries"]); exit;
		$this->lmme_obj->updateActiveStatus($_POST["menu_entries"]);

		ilUtil::sendSuccess($this->lng->txt("msg_obj_modified"), true);
		$this->ctrl->redirect($this, "editMenuProperties");
	}

	/**
	* output explorer tree
	*/
	function explorer()
	{
		global $ilUser, $ilias, $ilCtrl;

		switch ($this->object->getType())
		{
			case "lm":
				$gui_class = "ilobjlearningmodulegui";
				break;

			case "dlb":
				$gui_class = "ilobjdlbookgui";
				break;
		}

		$ilCtrl->setParameterByClass($gui_class, "active_node", $_GET["active_node"]);
		
		$this->tpl = new ilTemplate("tpl.main.html", true, true);
		// get learning module object
		//$this->lm_obj =& new ilObjLearningModule($this->ref_id, true);

		$this->tpl->setVariable("LOCATION_STYLESHEET", ilUtil::getStyleSheetLocation());

		//$this->tpl = new ilTemplate("tpl.explorer.html", false, false);
		$this->tpl->addBlockFile("CONTENT", "content", "tpl.explorer.html");
		$this->tpl->setVariable("IMG_SPACE", ilUtil::getImagePath("spacer.png", false));

		require_once ("./Modules/LearningModule/classes/class.ilLMEditorExplorer.php");
		$exp = new ilLMEditorExplorer($this->ctrl->getLinkTarget($this, "view"),
			$this->object, $gui_class);

		$exp->setTargetGet("obj_id");
		$exp->setExpandTarget($this->ctrl->getLinkTarget($this, "explorer"));

		if ($_GET["lmmovecopy"] == "1")
		{
			$this->proceedDragDrop();
		}


		if ($_GET["lmexpand"] == "")
		{
			$mtree = new ilTree($this->object->getId());
			$mtree->setTableNames('lm_tree','lm_data');
			$mtree->setTreeTablePK("lm_id");
			$expanded = $mtree->readRootId();
		}
		else
		{
			$expanded = $_GET["lmexpand"];
		}
		if ($_GET["active_node"] != "")
		{
			$path = $this->lm_tree->getPathId($_GET["active_node"]);
			$exp->setForceOpenPath($path);

			$exp->highlightNode($_GET["active_node"]);
		}
		$exp->setExpand($expanded);

		// build html-output
		$exp->setOutput(0);
		$output = $exp->getOutput();
		
		// asynchronous output
		if ($ilCtrl->isAsynch())
		{
			echo $output; exit;
		}

		include_once("./Services/COPage/classes/class.ilPageEditorGUI.php");
		
		/*if (ilPageEditorGUI::_doJSEditing())
		{
			//$this->tpl->touchBlock("includejavascript");

			$IDS = "";
			for ($i=0;$i<count($exp->iconList);$i++)
			{
				if ($i>0) $IDS .= ",";
				$IDS .= "'".$exp->iconList[$i]."'";
			}
			$this->tpl->setVariable("ICONIDS",$IDS);
			//$this->ctrl->setParameter($this, "lmovecopy", 1);
			$this->tpl->setVariable("TESTPFAD",$this->ctrl->getLinkTarget($this, "explorer")."&lmmovecopy=1");
			//$this->tpl->setVariable("POPUPLINK",$this->ctrl->getLinkTarget($this, "popup")."&ptype=movecopytreenode");
			$this->tpl->setVariable("POPUPLINK",$this->ctrl->getLinkTarget($this, "popup")."&ptype=movecopytreenode");
		}*/

		$this->tpl->setCurrentBlock("content");
		$this->tpl->setVariable("TXT_EXPLORER_HEADER", $this->lng->txt("cont_chap_and_pages"));
		$this->tpl->setVariable("EXP_REFRESH", $this->lng->txt("refresh"));
		$this->tpl->setVariable("EXPLORER",$output);
		$this->ctrl->setParameter($this, "lmexpand", $_GET["lmexpand"]);
		$this->tpl->setVariable("ACTION", $this->ctrl->getLinkTarget($this, "explorer"));
		$this->tpl->parseCurrentBlock();
		$this->tpl->show(false);
		exit;
	}

	/**
	* popup window for wysiwyg editor
	*/
	function popup()
	{
		include_once "./Services/COPage/classes/class.ilWysiwygUtil.php";
		$popup = new ilWysiwygUtil();
		$popup->show($_GET["ptype"]);
		exit;
	}

	/**
	* proceed drag and drop operations on pages/chapters
	*/
	function proceedDragDrop()
	{
		global $ilCtrl;
		
		$this->object->executeDragDrop($_POST["il_hform_source_id"], $_POST["il_hform_target_id"],
			$_POST["il_hform_fc"], $_POST["il_hform_as_subitem"]);
		$ilCtrl->redirect($this, "chapters");
	}

	/* protected function initCreationForms($a_new_type)
	{
		$forms = array(self::CFORM_NEW => $this->initCreateForm($a_new_type),
			self::CFORM_IMPORT => $this->initImportForm());

		return $forms;
	}*/

	protected function afterSave(ilObject $a_new_object)
	{
		$a_new_object->notify("new", $_GET["ref_id"], $_GET["parent_non_rbac_id"],
			$_GET["ref_id"], $a_new_object->getRefId());
		$a_new_object->setCleanFrames(true);
		$a_new_object->update();

		// create content object tree
		$a_new_object->createLMTree();
		
		// create a first chapter
		$a_new_object->addFirstChapterAndPage();

		// always send a message
		ilUtil::sendSuccess($this->lng->txt($this->type."_added"), true);
		ilUtil::redirect("ilias.php?ref_id=".$a_new_object->getRefId().
			"&baseClass=ilLMEditorGUI");
	}

	/**
	* Init import form.
	*/
	public function initImportForm()
	{
		global $lng, $ilCtrl;
	
		include_once("Services/Form/classes/class.ilPropertyFormGUI.php");
		$form = new ilPropertyFormGUI();
	
		$new_type = $_POST["new_type"] ? $_POST["new_type"] : $_GET["new_type"];
		$this->ctrl->setParameter($this, "new_type", $new_type);
		
		$form->setTarget(ilFrameTargetInfo::_getFrame("MainContent"));
		$form->setTableWidth("600px");
		
		// import file
		$fi = new ilFileInputGUI($this->lng->txt("file"), "xmldoc");
		$fi->setSuffixes(array("zip"));
		$fi->setRequired(true);
		$fi->setSize(30);
		$form->addItem($fi);
		
		// validation
		$cb = new ilCheckboxInputGUI($this->lng->txt("cont_validate_file"), "validate");
		$cb->setInfo($this->lng->txt(""));
		$form->addItem($cb);
		
		$form->addCommandButton("importFile", $lng->txt("import"));
		$form->addCommandButton("cancel", $lng->txt("cancel"));
	                
		$form->setTitle($this->lng->txt("import_".$new_type));
		$form->setFormAction($ilCtrl->getFormAction($this));

		return $form;
	}

	/**
	* add bib item (admin call)
	*/
	function addBibItemObject($a_target = "")
	{
		include_once "./Modules/LearningModule/classes/class.ilBibItemGUI.php";
		$bib_gui =& new ilBibItemGUI();
		$bib_gui->setObject($this->object);
		$bibItemName = $_POST["bibItemName"] ? $_POST["bibItemName"] : $_GET["bibItemName"];
		$bibItemIndex = $_POST["bibItemIndex"] ? $_POST["bibItemIndex"] : $_GET["bibItemIndex"];
		if ($bibItemIndex == "")
			$bibItemIndex = 0;
		$bibItemPath = $_POST["bibItemPath"] ? $_POST["bibItemPath"] : $_GET["bibItemPath"];
		if ($bibItemName != "")
		{
			$bib_gui->bib_obj->add($bibItemName, $bibItemPath, $bibItemIndex);
			$data = $bib_gui->bib_obj->getElement("BibItem");
			$bibItemIndex = (count($data) - 1);
		}
		else
		{
			ilUtil::sendInfo($this->lng->txt("bibitem_choose_element"), true);
		}
		if ($a_target == "")
		{
			$a_target = "adm_object.php?ref_id=" . $this->object->getRefId();
		}

		$bib_gui->edit("ADM_CONTENT", "adm_content", $a_target, $bibItemIndex);
	}

	/**
	* add bib item (module call)
	*/
	function addBibItem()
	{
		$this->setTabs();
		
		// questionable workaround to make this old stuff work
		$this->ctrl->setParameter($this, ilCtrl::IL_RTOKEN_NAME, $this->ctrl->getRequestToken());

		$this->addBibItemObject($this->ctrl->getLinkTarget($this));
	}

	/**
	* delete bib item (admin call)
	*/
	function deleteBibItemObject($a_target = "")
	{
		include_once "./Modules/LearningModule/classes/class.ilBibItemGUI.php";
		$bib_gui =& new ilBibItemGUI();
		$bib_gui->setObject($this->object);
		$bibItemIndex = $_POST["bibItemIndex"] ? $_POST["bibItemIndex"] : $_GET["bibItemIndex"];
		$bib_gui->bib_obj->delete($_GET["bibItemName"], $_GET["bibItemPath"], $bibItemIndex);
		if (strpos($bibItemIndex, ",") > 0)
		{
			$bibItemIndex = substr($bibItemIndex, 0, strpos($bibItemIndex, ","));
		}
		if ($a_target == "")
		{
			$a_target = "adm_object.php?ref_id=" . $this->object->getRefId();
		}

		$bib_gui->edit("ADM_CONTENT", "adm_content", $a_target,  max(0, $bibItemIndex - 1));
	}

	/**
	* delete bib item (module call)
	*/
	function deleteBibItem()
	{
		$this->setTabs();
		
		// questionable workaround to make this old stuff work
		$this->ctrl->setParameter($this, ilCtrl::IL_RTOKEN_NAME, $this->ctrl->getRequestToken());

		$this->deleteBibItemObject($this->ctrl->getLinkTarget($this));
	}


	/**
	* edit bib items (admin call)
	*/
	function editBibItemObject($a_target = "")
	{
		include_once "./Modules/LearningModule/classes/class.ilBibItemGUI.php";
		$bib_gui =& new ilBibItemGUI();
		$bib_gui->setObject($this->object);
		$bibItemIndex = $_POST["bibItemIndex"] ? $_POST["bibItemIndex"] : $_GET["bibItemIndex"];
		$bibItemIndex *= 1;
		if ($bibItemIndex < 0)
		{
			$bibItemIndex = 0;
		}
		if ($a_target == "")
		{
			$a_target = "adm_object.php?ref_id=" . $this->object->getRefId();
		}

		$bib_gui->edit("ADM_CONTENT", "adm_content", $a_target, $bibItemIndex);
	}

	/**
	* edit bib items (module call)
	*/
	function editBibItem()
	{
		$this->setTabs();
		
		// questionable workaround to make this old stuff work
		$this->ctrl->setParameter($this, ilCtrl::IL_RTOKEN_NAME, $this->ctrl->getRequestToken());
		
		$this->editBibItemObject($this->ctrl->getLinkTarget($this));
	}

	/**
	* save bib item (admin call)
	*/
	function saveBibItemObject($a_target = "")
	{
		include_once "./Modules/LearningModule/classes/class.ilBibItemGUI.php";
		$bib_gui =& new ilBibItemGUI();
		$bib_gui->setObject($this->object);
		$bibItemIndex = $_POST["bibItemIndex"] ? $_POST["bibItemIndex"] : $_GET["bibItemIndex"];
		$bibItemIndex *= 1;
		if ($bibItemIndex < 0)
		{
			$bibItemIndex = 0;
		}
		$bibItemIndex = $bib_gui->save($bibItemIndex);

		if ($a_target == "")
		{
			$a_target = "adm_object.php?ref_id=" . $this->object->getRefId();
		}

		$bib_gui->edit("ADM_CONTENT", "adm_content", $a_target, $bibItemIndex);
	}

	/**
	* save bib item (module call)
	*/
	function saveBibItem()
	{
		$this->setTabs();

		// questionable workaround to make this old stuff work
		$this->ctrl->setParameter($this, ilCtrl::IL_RTOKEN_NAME, $this->ctrl->getRequestToken());

		$this->saveBibItemObject($this->ctrl->getLinkTarget($this));
	}

	/**
	* export object
	*
	* @access	public
	*/
	function exportObject()
	{
		return;
	}

	/**
	* display dialogue for importing XML-LeaningObjects
	*
	* @access	public
	*/
	function importObject()
	{
		$this->createObject();
		return;
	}


	/**
	* display status information or report errors messages
	* in case of error
	*
	* @access	public
	*/
	function importFileObject()
	{
		global $_FILES, $rbacsystem, $ilDB, $tpl;

		include_once "./Modules/LearningModule/classes/class.ilObjLearningModule.php";

		if (!$rbacsystem->checkAccess("create", $_GET["ref_id"], $_GET["new_type"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_create_permission"), $this->ilias->error_obj->MESSAGE);
			return;
		}

		$form = $this->initImportForm();
		if ($form->checkInput())
		{
			// create and insert object in objecttree
			include_once("./Modules/LearningModule/classes/class.ilObjContentObject.php");
			$newObj = new ilObjContentObject();
			$newObj->setType($_GET["new_type"]);
			$newObj->setTitle($_FILES["xmldoc"]["name"]);
			$newObj->setDescription("");
			$newObj->create(true);
			$newObj->createReference();
			$newObj->putInTree($_GET["ref_id"]);
			$newObj->setPermissions($_GET["ref_id"]);
			$newObj->notify("new",$_GET["ref_id"],$_GET["parent_non_rbac_id"],$_GET["ref_id"],$newObj->getRefId());
	
			// create learning module tree
			$newObj->createLMTree();

			// import lm from file
			$mess = $newObj->importFromZipFile($_FILES["xmldoc"]["tmp_name"], $_FILES["xmldoc"]["name"],
				$_POST["validate"]);

			if ($mess == "")
			{
				ilUtil::sendSuccess($this->lng->txt($this->type."_added"),true);		
				ilUtil::redirect("ilias.php?ref_id=".$newObj->getRefId().
					"&baseClass=ilLMEditorGUI");
			}
			else
			{
				$link = '<a href="'."ilias.php?ref_id=".$newObj->getRefId().
					"&baseClass=ilLMEditorGUI".'" target="_top">'.$this->lng->txt("btn_next").'</a>';
				$tpl->setContent("<br />".$link."<br /><br />".$mess.$link);
			}
		}
		else
		{
			$form->setValuesByPost();
			$tpl->setContent($form->getHtml());
		}
	}

	/**
	* show chapters
	*/
	function chapters()
	{
		global $tree, $lng, $ilCtrl, $ilUser;

		$this->setTabs();
		$this->setContentSubTabs("chapters");
		
		$ilCtrl->setParameter($this, "backcmd", "chapters");
		
		include_once("./Modules/LearningModule/classes/class.ilChapterHierarchyFormGUI.php");
		$form_gui = new ilChapterHierarchyFormGUI($this->object->getType(), $_GET["transl"]);
		$form_gui->setFormAction($ilCtrl->getFormAction($this));
		$form_gui->setTitle($this->object->getTitle());
		$form_gui->setIcon(ilUtil::getImagePath("icon_lm.svg"));
		$form_gui->setTree($this->lm_tree);
		$form_gui->setMaxDepth(0);
		$form_gui->setCurrentTopNodeId($this->tree->getRootId());
		$form_gui->addMultiCommand($lng->txt("delete"), "delete");
		$form_gui->addMultiCommand($lng->txt("cut"), "cutItems");
		$form_gui->addMultiCommand($lng->txt("copy"), "copyItems");
		if ($this->object->getLayoutPerPage())
		{	
			$form_gui->addMultiCommand($lng->txt("cont_set_layout"), "setPageLayoutInHierarchy");
		}
		$form_gui->setDragIcon(ilUtil::getImagePath("icon_st.svg"));
		$form_gui->addCommand($lng->txt("cont_save_all_titles"), "saveAllTitles");
		$up_gui = ($this->object->getType() == "dbk")
			? "ilobjdlbookgui"
			: "ilobjlearningmodulegui";

		$ctpl = new ilTemplate("tpl.chap_and_pages.html", true, true, "Modules/LearningModule");
		$ctpl->setVariable("HIERARCHY_FORM", $form_gui->getHTML());
		$ilCtrl->setParameter($this, "obj_id", "");

		$ml_head = self::getMultiLangHeader($this->object->getId(), $this);		
		
		$this->tpl->setContent($ml_head.$ctpl->get());
	}

	/**
	 * Get multi lang header
	 *
	 * @param
	 * @return
	 */
	static function getMultiLangHeader($a_lm_id, $a_gui_class)
	{
		global $lng, $ilCtrl;
		
		// multi language
		include_once("./Services/Object/classes/class.ilObjectTranslation.php");
		$ot = ilObjectTranslation::getInstance($a_lm_id);
		//include_once("./Services/COPage/classes/class.ilPageMultiLang.php");
		//$ml = new ilPageMultiLang("lm", $a_lm_id);
		if ($ot->getContentActivated())
		{
			$lng->loadLanguageModule("meta");
			
			// info
			include_once("./Services/COPage/classes/class.ilPageMultiLangGUI.php");
			$ml_gui = new ilPageMultiLangGUI("lm", $a_lm_id);
			$ml_head = $ml_gui->getMultiLangInfo($_GET["transl"]);
			
			// language switch
			include_once("./Services/UIComponent/AdvancedSelectionList/classes/class.ilAdvancedSelectionListGUI.php");
			$list = new ilAdvancedSelectionListGUI();
			$list->setListTitle($lng->txt("actions"));
			$list->setId("copage_act");
			$entries = false;
			if (!in_array($_GET["transl"], array("", "-")))
			{
				$l = $ot->getMasterLanguage();
				$list->addItem($lng->txt("cont_edit_language_version").": ".
					$lng->txt("meta_l_".$l), "",
					$ilCtrl->getLinkTarget($a_gui_class, "editMasterLanguage"));
				$entries = true;
			}

			foreach ($ot->getLanguages() as $al => $lang)
			{
				if ($_GET["transl"] != $al &&
					$al != $ot->getMasterLanguage())
				{
					$ilCtrl->setParameter($a_gui_class, "totransl", $al);
					$list->addItem($lng->txt("cont_edit_language_version").": ".
						$lng->txt("meta_l_".$al), "",
						$ilCtrl->getLinkTarget($a_gui_class, "switchToLanguage"));
					$ilCtrl->setParameter($a_gui_class, "totransl", $_GET["totransl"]);
				}
				$entries = true;
			}
			
			if ($entries)
			{
				$ml_head = '<div class="ilFloatLeft">'.$ml_head.'</div><div style="margin: 5px 0;" class="small ilRight">'.$list->getHTML()."</div>";
			}

		}

		return $ml_head;
	}
	

	/*
	* List all pages of learning module
	*/
	function pages()
	{
		global $tree, $tpl, $ilToolbar, $ilCtrl, $lng;

		$this->setTabs();
		$this->setContentSubTabs("pages");

		$ilCtrl->setParameter($this, "backcmd", "pages");
		$ilCtrl->setParameterByClass("illmpageobjectgui", "new_type", "pg");
		$ilToolbar->addButton($lng->txt("pg_add"),
			$ilCtrl->getLinkTargetByClass("illmpageobjectgui", "create"));
		$ilCtrl->setParameterByClass("illmpageobjectgui", "new_type", "");

		include_once("./Modules/LearningModule/classes/class.ilLMPagesTableGUI.php");
		$t = new ilLMPagesTableGUI($this, "pages", $this->object);
		$tpl->setContent($t->getHTML());
	}

	/**
	* List all broken links
	*/
	function listLinks()
	{
		global $tpl;
		
		$this->setTabs();
		$this->setContentSubTabs("internal_links");
		
		include_once("./Modules/LearningModule/classes/class.ilLinksTableGUI.php");
		$table_gui = new ilLinksTableGUI($this, "listLinks",
			$this->object->getId(), $this->object->getType());
		
		$tpl->setContent($table_gui->getHTML());
	}
	
	/**
	 * Show maintenance
	 */
	function showMaintenance()
	{
		global $tpl, $ilToolbar;
		
		$this->setTabs();
		$this->setContentSubTabs("maintenance");
		
		$ilToolbar->addButton($this->lng->txt("cont_fix_tree"),
			$this->ctrl->getLinkTarget($this, "fixTreeConfirm"));
	}

	/**
	* activates or deactivates pages
	*/
	function activatePages()
	{
		if (is_array($_POST["id"]))
		{
			foreach($_POST["id"] as $id)
			{
				include_once("./Modules/LearningModule/classes/class.ilLMPage.php");
				$act = ilLMPage::_lookupActive($id, $this->object->getType());
				ilLMPage::_writeActive($id, $this->object->getType(), !$act);
			}
		}

		$this->ctrl->redirect($this, "pages");
	}

	/**
	* paste page
	*/
	function pastePage()
	{
		if(ilEditClipboard::getContentObjectType() != "pg")
		{
			$this->ilias->raiseError($this->lng->txt("no_page_in_clipboard"),$this->ilias->error_obj->MESSAGE);
		}

		// paste selected object
		$id = ilEditClipboard::getContentObjectId();

		// copy page, if action is copy
		if (ilEditClipboard::getAction() == "copy")
		{
			// check wether page belongs to lm
			if (ilLMObject::_lookupContObjID(ilEditClipboard::getContentObjectId())
				== $this->object->getID())
			{
				$lm_page = new ilLMPageObject($this->object, $id);
				$new_page =& $lm_page->copy();
				$id = $new_page->getId();
			}
			else
			{
				// get page from other content object into current content object
				$lm_id = ilLMObject::_lookupContObjID(ilEditClipboard::getContentObjectId());
				$lm_obj =& $this->ilias->obj_factory->getInstanceByObjId($lm_id);
				$lm_page = new ilLMPageObject($lm_obj, $id);
				$copied_nodes = array();
				$new_page =& $lm_page->copyToOtherContObject($this->object, $copied_nodes);
				$id = $new_page->getId();
				ilLMObject::updateInternalLinks($copied_nodes);
			}
		}

		// cut is not be possible in "all pages" form yet
		if (ilEditClipboard::getAction() == "cut")
		{
			// check wether page belongs not to lm
			if (ilLMObject::_lookupContObjID(ilEditClipboard::getContentObjectId())
				!= $this->object->getID())
			{
				$lm_id = ilLMObject::_lookupContObjID(ilEditClipboard::getContentObjectId());
				$lm_obj =& $this->ilias->obj_factory->getInstanceByObjId($lm_id);
				$lm_page = new ilLMPageObject($lm_obj, $id);
				$lm_page->setLMId($this->object->getID());
				$lm_page->update();
				$page =& $lm_page->getPageObject();
				$page->buildDom();
				$page->setParentId($this->object->getID());
				$page->update();
			}
		}


		ilEditClipboard::clear();
		$this->ctrl->redirect($this, "pages");
	}

	/**
	* copy page
	*/
	function copyPage()
	{
		global $ilUser;
		
		if(!isset($_POST["id"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}

		$items = ilUtil::stripSlashesArray($_POST["id"]);
		ilLMObject::clipboardCopy($this->object->getId(), $items);
		ilEditClipboard::setAction("copy");

		ilUtil::sendInfo($this->lng->txt("cont_selected_items_have_been_copied"), true);

		$this->ctrl->redirect($this, "pages");
	}

	/**
	* confirm deletion screen for page object and structure object deletion
	*
	* @param	int		$a_parent_subobj_id		id of parent object (structure object)
	*											of the objects, that should be deleted
	*											(or no parent object id for top level)
	*/
	function delete($a_parent_subobj_id = 0)
	{
		if(!isset($_POST["id"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}

		if(count($_POST["id"]) == 1 && $_POST["id"][0] == IL_FIRST_NODE)
		{
			$this->ilias->raiseError($this->lng->txt("cont_select_item"), $this->ilias->error_obj->MESSAGE);
		}

		if ($a_parent_subobj_id == 0)
		{
			$this->setTabs();
		}
		
		if ($a_parent_subobj_id != 0)
		{
			$this->ctrl->setParameterByClass("ilStructureObjectGUI", "backcmd", $_GET["backcmd"]);
			$this->ctrl->setParameterByClass("ilStructureObjectGUI", "obj_id", $a_parent_subobj_id);
			$form_action = $this->ctrl->getFormActionByClass("ilStructureObjectGUI");
		}
		else
		{
			$this->ctrl->setParameter($this, "backcmd", $_GET["backcmd"]);
			$form_action = $this->ctrl->getFormAction($this);
		}
		
		// display confirmation message
		include_once("./Services/Utilities/classes/class.ilConfirmationGUI.php");
		$cgui = new ilConfirmationGUI();
		$cgui->setFormAction($form_action);
		$cgui->setHeaderText($this->lng->txt("info_delete_sure"));
		$cgui->setCancel($this->lng->txt("cancel"), "cancelDelete");
		$cgui->setConfirm($this->lng->txt("confirm"), "confirmedDelete");
		
		foreach($_POST["id"] as $id)
		{
			if ($id != IL_FIRST_NODE)
			{
				$obj = new ilLMObject($this->object, $id);				
				$caption = ilUtil::getImageTagByType($obj->getType(), $this->tpl->tplPath).	
					" ".$obj->getTitle();
				
				$cgui->addItem("id[]", $id, $caption);
			}						
		}

		$this->tpl->setContent($cgui->getHTML());
	}

	/**
	* cancel delete
	*/
	function cancelDelete()
	{		
		$this->ctrl->redirect($this, $_GET["backcmd"]);

	}

	/**
	* delete page object or structure objects
	*
	* @param	int		$a_parent_subobj_id		id of parent object (structure object)
	*											of the objects, that should be deleted
	*											(or no parent object id for top level)
	*/
	function confirmedDelete($a_parent_subobj_id = 0)
	{
		$tree = new ilTree($this->object->getId());
		$tree->setTableNames('lm_tree','lm_data');
		$tree->setTreeTablePK("lm_id");

		// check number of objects
		if (!$_POST["id"])
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}

		// delete all selected objects
		foreach ($_POST["id"] as $id)
		{
			if ($id != IL_FIRST_NODE)
			{
				$obj =& ilLMObjectFactory::getInstance($this->object, $id, false);
				$node_data = $tree->getNodeData($id);
				if (is_object($obj))
				{
					$obj->setLMId($this->object->getId());

					include_once("./Services/History/classes/class.ilHistory.php");
					ilHistory::_createEntry($this->object->getId(), "delete_".$obj->getType(),
						array(ilLMObject::_lookupTitle($id), $id),
						$this->object->getType());

					$obj->delete();
				}
				if($tree->isInTree($id))
				{
					$tree->deleteTree($node_data);
				}
			}
		}

		// check the tree
		$this->object->checkTree();

		// feedback
		ilUtil::sendSuccess($this->lng->txt("info_deleted"),true);

		if ($a_parent_subobj_id == 0)
		{
			$this->ctrl->redirect($this, $_GET["backcmd"]);
		}
	}



	/**
	* get context path in content object tree
	*
	* @param	int		$a_endnode_id		id of endnode
	* @param	int		$a_startnode_id		id of startnode
	*/
	function getContextPath($a_endnode_id, $a_startnode_id = 1)
	{
		$path = "";

		$tmpPath = $this->lm_tree->getPathFull($a_endnode_id, $a_startnode_id);

		// count -1, to exclude the learning module itself
		for ($i = 1; $i < (count($tmpPath) - 1); $i++)
		{
			if ($path != "")
			{
				$path .= " > ";
			}

			$path .= $tmpPath[$i]["title"];
		}

		return $path;
	}



	/**
	* show possible action (form buttons)
	*
	* @access	public
	*/
	function showActions($a_actions)
	{
		foreach ($a_actions as $name => $lng)
		{
			$d[$name] = array("name" => $name, "lng" => $lng);
		}

		$notoperations = array();

		$operations = array();

		if (is_array($d))
		{
			foreach ($d as $row)
			{
				if (!in_array($row["name"], $notoperations))
				{
					$operations[] = $row;
				}
			}
		}

		if (count($operations)>0)
		{
			foreach ($operations as $val)
			{
				$this->tpl->setCurrentBlock("operation_btn");
				$this->tpl->setVariable("BTN_NAME", $val["name"]);
				$this->tpl->setVariable("BTN_VALUE", $this->lng->txt($val["lng"]));
				$this->tpl->parseCurrentBlock();
			}

			$this->tpl->setCurrentBlock("operation");
			$this->tpl->setVariable("IMG_ARROW",ilUtil::getImagePath("arrow_downright.svg"));
			$this->tpl->parseCurrentBlock();
		}
	}

	/**
	* edit permissions
	*/
	function perm()
	{
		$this->setTabs();

		$this->setFormAction("addRole", $this->ctrl->getLinkTarget($this, "addRole"));
		$this->setFormAction("permSave", $this->ctrl->getLinkTarget($this, "permSave"));
		$this->permObject();
	}


	/**
	* save permissions
	*/
	function permSave()
	{
		$this->setReturnLocation("permSave", $this->ctrl->getLinkTarget($this, "perm"));
		$this->permSaveObject();
	}

	/**
	* info permissions
	*/
	function info()
	{
		$this->setTabs();
		$this->infoObject();
	}


	/**
	* add local role
	*/
	function addRole()
	{
		$this->setReturnLocation("addRole", $this->ctrl->getLinkTarget($this, "perm"));
		$this->addRoleObject();
	}


	/**
	* show owner of content object
	*/
	function owner()
	{
		$this->setTabs();
		$this->ownerObject();
	}


	/**
	* view content object
	*/
	function view()
	{
		if (strtolower($_GET["baseClass"]) == "iladministrationgui")
		{
			$this->prepareOutput();
			parent::viewObject();
		}
		else
		{
			$this->viewObject();
		}
	}


	/**
	* move a single chapter  (selection)
	*/
	function moveChapter($a_parent_subobj_id = 0)
	{
		if(!isset($_POST["id"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}
//echo "Hallo::"; exit;
		if(count($_POST["id"]) > 1)
		{
			$this->ilias->raiseError($this->lng->txt("cont_select_max_one_item"),$this->ilias->error_obj->MESSAGE);
		}

		if(count($_POST["id"]) == 1 && $_POST["id"][0] == IL_FIRST_NODE)
		{
			$this->ilias->raiseError($this->lng->txt("cont_select_item"), $this->ilias->error_obj->MESSAGE);
		}

		// SAVE POST VALUES
		ilEditClipboard::storeContentObject("st", $_POST["id"][0], "move");

		ilUtil::sendInfo($this->lng->txt("cont_chap_select_target_now"), true);

		if ($a_parent_subobj_id == 0)
		{
			$this->ctrl->redirect($this, "chapters");
		}
	}


	/**
	* copy a single chapter  (selection)
	*/
	function copyChapter($a_parent_subobj_id = 0)
	{
		$this->copyItems();
	}

	/**
	* paste chapter
	*/
	function pasteChapter($a_parent_subobj_id = 0)
	{
		return $this->insertChapterClip(false);
	}

	/**
	* move page
	*/
	function movePage()
	{
		global $ilUser;
		
		if(!isset($_POST["id"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}

		ilUtil::sendInfo($this->lng->txt("cont_selected_items_have_been_cut"), true);

		$items = ilUtil::stripSlashesArray($_POST["id"]);
		ilLMObject::clipboardCut($this->object->getId(), $items);
		ilEditClipboard::setAction("cut");
		
		$this->ctrl->redirect($this, "pages");
	}

	/**
	* cancel action
	*/
	function cancel()
	{
		if ($_GET["new_type"] == "pg")
		{
			$this->ctrl->redirect($this, "pages");
		}
		else
		{
			$this->ctrl->redirect($this, "chapters");
		}
	}


	/**
	* export content object
	*/
	function export()
	{
		require_once("./Modules/LearningModule/classes/class.ilContObjectExport.php");
		$cont_exp = new ilContObjectExport($this->object);
		$cont_exp->buildExportFile();
//		$this->ctrl->redirect($this, "exportList");
	}

	/**
	 * Get public access value for export table 
	 */
	function getPublicAccessColValue($a_type, $a_file)
	{
		global $lng, $ilCtrl;

		$changelink = "<a href='".$ilCtrl->getLinkTarget($this, "editMenuProperties")."'>".$lng->txt("change")."</a>";
		if (!$this->object->isActiveLMMenu())
		{
			$add = "<br />".$lng->txt("cont_download_no_menu")." ".$changelink;
		}
		else if (!$this->object->isActiveDownloads())
		{
			$add = "<br />".$lng->txt("cont_download_no_download")." ".$changelink;
		}

		
		if ($this->object->getPublicExportFile($a_type) == $a_file)
		{
			return $lng->txt("yes").$add;
		}
	
		return " ";		
	}



	/**
	* download export file
	*/
	function publishExportFile($a_files)
	{
		global $ilCtrl;
		
		if(!isset($a_files))
		{
			ilUtil::sendFailure($this->lng->txt("no_checkbox"), true);
		}
		else
		{
			foreach ($a_files as $f)
			{
				$file = explode(":", $f);
				$export_dir = $this->object->getExportDirectory($file[0]);
		
				if ($this->object->getPublicExportFile($file[0]) ==
					$file[1])
				{
					$this->object->setPublicExportFile($file[0], "");
				}
				else
				{
					$this->object->setPublicExportFile($file[0], $file[1]);
				}
			}
			$this->object->update();
		}
		$ilCtrl->redirectByClass("ilexportgui");
	}

	/**
	* download export file
	*/
	function downloadPDFFile()
	{
		if(!isset($_POST["file"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}

		if (count($_POST["file"]) > 1)
		{
			$this->ilias->raiseError($this->lng->txt("cont_select_max_one_item"),$this->ilias->error_obj->MESSAGE);
		}


		$export_dir = $this->object->getOfflineDirectory();
		
		$file = basename($_POST["file"][0]);
		
		ilUtil::deliverFile($export_dir."/".$file, $file);
	}


	/**
	* confirm screen for tree fixing
	*
	*/
	function fixTreeConfirm()
	{
		$this->setTabs();
		$this->setContentSubTabs("maintenance");
		
		// display confirmation message
		include_once("./Services/Utilities/classes/class.ilConfirmationGUI.php");
		$cgui = new ilConfirmationGUI();
		$cgui->setFormAction($this->ctrl->getFormAction($this));
		$cgui->setHeaderText($this->lng->txt("cont_fix_tree_confirm"));
		$cgui->setCancel($this->lng->txt("cancel"), "showMaintenance");
		$cgui->setConfirm($this->lng->txt("cont_fix_tree"), "fixTree");
		
		$this->tpl->setContent($cgui->getHTML());
	}

	/**
	 * Fix tree
	 */
	function fixTree()
	{
		$this->object->fixTree();
		ilUtil::sendSuccess($this->lng->txt("cont_tree_fixed"), true);
		$this->ctrl->redirect($this, "showMaintenance");
	}

	/**
	* get lm menu html
	*/
	function setilLMMenu($a_offline = false, $a_export_format = "",
		$a_active = "content", $a_use_global_tabs = false, $a_as_subtabs = false,
		$a_cur_page = 0)
	{
		global $ilCtrl,$ilUser, $ilAccess, $ilTabs, $rbacsystem, $ilPluginAdmin, $ilHelp;

		$ilHelp->setScreenIdComponent("lm");
		
		if ($a_as_subtabs)
		{
			$addcmd = "addSubTabTarget";
			$getcmd = "getSubTabHTML";
		}
		else
		{
			$addcmd = "addTarget";
			$getcmd = "getHTML";
		}
		
		$active[$a_active] = true;

		if (!$this->object->isActiveLMMenu())
		{
			return "";
		}

		if ($a_use_global_tabs)
		{
			$tabs_gui = $ilTabs;
		}
		else
		{
			$tabs_gui = new ilTabsGUI();
		}
		
		// Determine whether the view of a learning resource should
		// be shown in the frameset of ilias, or in a separate window.
		//$showViewInFrameset = $this->ilias->ini->readVariable("layout","view_target") == "frame";
		$showViewInFrameset = true;

		if ($showViewInFrameset && !$a_offline)
		{
			$buttonTarget = ilFrameTargetInfo::_getFrame("MainContent");
		}
		else
		{
			$buttonTarget = "_top";
		}

		if ($a_export_format == "scorm")
		{
			$buttonTarget = "";
		}
		
		include_once("./Services/Payment/classes/class.ilPaymentObject.php");
		$requires_purchase_to_access = ilPaymentObject::_requiresPurchaseToAccess((int)$_GET['ref_id']);

		// content
		if (!$a_offline && $ilAccess->checkAccess("read", "", $_GET["ref_id"]))
		{
			$ilCtrl->setParameterByClass("illmpresentationgui", "obj_id", $_GET["obj_id"]);
			$tabs_gui->$addcmd("content",
				$ilCtrl->getLinkTargetByClass("illmpresentationgui", "layout"),
				"", "", $buttonTarget,  $active["content"]);
			if ($active["content"])
			{
				$ilHelp->setScreenId("content");
				$ilHelp->setSubScreenId("content");
			}
		}

		// table of contents
		if (!$requires_purchase_to_access && $this->object->isActiveTOC() && $ilAccess->checkAccess("read", "", $_GET["ref_id"]))
		{
			if (!$a_offline)
			{
				$ilCtrl->setParameterByClass("illmpresentationgui", "obj_id", $_GET["obj_id"]);
				$link = $ilCtrl->getLinkTargetByClass("illmpresentationgui", "showTableOfContents");
			}
			else
			{
				$link = "./table_of_contents.html";
			}
			
			$tabs_gui->$addcmd("cont_toc", $link,
					"", "", $buttonTarget, $active["toc"]);
		}

		// print view
		if (!$requires_purchase_to_access && $this->object->isActivePrintView() && $ilAccess->checkAccess("read", "", $_GET["ref_id"]))
		{
			if (!$a_offline)		// has to be implemented for offline mode
			{
				$ilCtrl->setParameterByClass("illmpresentationgui", "obj_id", $_GET["obj_id"]);
				$link = $ilCtrl->getLinkTargetByClass("illmpresentationgui", "showPrintViewSelection");
				$tabs_gui->$addcmd("cont_print_view", $link,
					"", "", $buttonTarget, $active["print"]);
			}
		}
		
		// download
		if (!$requires_purchase_to_access && $ilUser->getId() == ANONYMOUS_USER_ID)
		{
			$is_public = $this->object->isActiveDownloadsPublic();
		}
		else if(!$requires_purchase_to_access)
		{
			$is_public = true;
		}

		if (!$requires_purchase_to_access && $this->object->isActiveDownloads() && !$a_offline && $is_public &&
			$ilAccess->checkAccess("read", "", $_GET["ref_id"]))
		{
			$ilCtrl->setParameterByClass("illmpresentationgui", "obj_id", $_GET["obj_id"]);
			$link = $ilCtrl->getLinkTargetByClass("illmpresentationgui", "showDownloadList");
			$tabs_gui->$addcmd("download", $link,
				"", "", $buttonTarget, $active["download"]);
		}

		// info button
		if ($a_export_format != "scorm" && !$a_offline)
		{
			if (!$a_offline)
			{
				$ilCtrl->setParameterByClass("illmpresentationgui", "obj_id", $_GET["obj_id"]);
				$link = $this->ctrl->getLinkTargetByClass(
						array("illmpresentationgui", "ilinfoscreengui"), "showSummary");
			}
			else
			{
				$link = "./info.html";
			}
			
			$tabs_gui->$addcmd(($requires_purchase_to_access ? 'buy' : 'info_short'), $link,
					"", "", $buttonTarget, $active["info"]);
		}
		
		include_once './Services/Tracking/classes/class.ilLearningProgressAccess.php';
		if(!$a_offline &&
			$ilAccess->checkAccess("read", "", $_GET["ref_id"]) && // #14075
			ilLearningProgressAccess::checkAccess($_GET["ref_id"])) 
		{								
			include_once './Services/Object/classes/class.ilObjectLP.php';
			$olp = ilObjectLP::getInstance($this->object->getId());			
			if($olp->getCurrentMode() == ilLPObjSettings::LP_MODE_COLLECTION_MANUAL)
			{
				$tabs_gui->$addcmd("learning_progress", 
					$this->ctrl->getLinkTargetByClass(array("illmpresentationgui", "illearningprogressgui"), "editmanual"),
						"", "", $buttonTarget, $active["learning_progress"]);
			}
			else if($olp->getCurrentMode() == ilLPObjSettings::LP_MODE_COLLECTION_TLT)
			{
				$tabs_gui->$addcmd("learning_progress", 
					$this->ctrl->getLinkTargetByClass(array("illmpresentationgui", "illearningprogressgui"), "showtlt"),
						"", "", $buttonTarget, $active["learning_progress"]);
			}
		}
		
		// edit learning module
		if (!$a_offline && $a_cur_page > 0)
		{
			if ($rbacsystem->checkAccess("write", $_GET["ref_id"]))
			{
				//$page_id = $this->getCurrentPageId();
				$page_id = $a_cur_page;
				$tabs_gui->$addcmd("edit_page", ILIAS_HTTP_PATH."/ilias.php?baseClass=ilLMEditorGUI&ref_id=".$_GET["ref_id"].
					"&obj_id=".$page_id."&to_page=1",
					"", "", $buttonTarget, $active["edit_page"]);
			}
		}
		
		if(!$requires_purchase_to_access)
		{
			// get user defined menu entries
			$this->__initLMMenuEditor();
			$entries = $this->lmme_obj->getMenuEntries(true);
	
			if (count($entries) > 0 && $ilAccess->checkAccess("read", "", $_GET["ref_id"]))
			{
				foreach ($entries as $entry)
				{
					// build goto-link for internal resources
					if ($entry["type"] == "intern")
					{
						$entry["link"] = ILIAS_HTTP_PATH."/goto.php?target=".$entry["link"];
					}
	
					// add http:// prefix if not exist
					if (!strstr($entry["link"],'://') && !strstr($entry["link"],'mailto:'))
					{
						$entry["link"] = "http://".$entry["link"];
					}
					
					if (!strstr($entry["link"],'mailto:'))
					{
						$entry["link"] = ilUtil::appendUrlParameterString($entry["link"], "ref_id=".$this->ref_id."&structure_id=".$this->obj_id);
					}
					$tabs_gui->$addcmd($entry["title"],
						$entry["link"],
						"", "", "_blank", "", true);
				}
			}
		}

		// user interface hook [uihk]
		$pl_names = $ilPluginAdmin->getActivePluginsForSlot(IL_COMP_SERVICE, "UIComponent", "uihk");
		$plugin_html = false;
		foreach ($pl_names as $pl)
		{
			$ui_plugin = ilPluginAdmin::getPluginObject(IL_COMP_SERVICE, "UIComponent", "uihk", $pl);
			$gui_class = $ui_plugin->getUIClassInstance();
			$resp = $gui_class->modifyGUI("Modules/LearningModule", "lm_menu_tabs",
				array("lm_menu_tabs" => $tabs_gui));
		}


		return $tabs_gui->$getcmd();
	}

	/**
	* export content object
	*/
	function createPDF()
	{
		require_once("./Modules/LearningModule/classes/class.ilContObjectExport.php");
		$cont_exp = new ilContObjectExport($this->object, "pdf");
		$cont_exp->buildExportFile();
		$this->offlineList();
	}

	/**
	 * create html package
	 */
	function exportHTML()
	{
		include_once("./Services/Object/classes/class.ilObjectTranslation.php");
		$ot = ilObjectTranslation::getInstance($this->object->getId());
		$lang = "";
		if ($ot->getContentActivated())
		{
			$format = explode("_", $_POST["format"]);
			$lang = ilUtil::stripSlashes($format[1]);
		}
		require_once("./Modules/LearningModule/classes/class.ilContObjectExport.php");
		$cont_exp = new ilContObjectExport($this->object, "html", $lang);
		$cont_exp->buildExportFile();
//echo $this->tpl->get();
//		$this->ctrl->redirect($this, "exportList");
	}

	/**
	* create scorm package
	*/
	function exportSCORM()
	{
		require_once("./Modules/LearningModule/classes/class.ilContObjectExport.php");
		$cont_exp = new ilContObjectExport($this->object, "scorm");
		$cont_exp->buildExportFile();
//echo $this->tpl->get();
//		$this->ctrl->redirect($this, "exportList");
	}

	/**
	* display locator
	*
	* @param	boolean		$a_omit_obj_id	set to true, if obj id is not page id (e.g. permission gui)
	*/
	function addLocations($a_omit_obj_id = false)
	{
		global $lng, $tree, $ilLocator, $ilCtrl;

		$par_id = $tree->getParentId($_GET["ref_id"]);
		$parent_title = ilObject::_lookupTitle(ilObject::_lookupObjId($par_id));

		// parent is not root folder, "shorten" locator
		if($par_id != ROOT_FOLDER_ID)
		{
			$this->ctrl->addLocation("...",
				"");
		}
		else
		{
			// if parent is root folder and has no custom title
			// we adapt it [see $ilLocator->addRepositoryItems()]
			if ($parent_title == "ILIAS")
			{
				$parent_title = $lng->txt("repository");
			}
		}

		$ilCtrl->setParameterByClass("ilrepositorygui", "ref_id", $par_id);
		$this->ctrl->addLocation($parent_title,
			$ilCtrl->getLinkTargetByClass("ilrepositorygui", "frameset"),
			ilFrameTargetInfo::_getFrame("MainContent"), $par_id);
		$ilCtrl->setParameterByClass("ilrepositorygui", "ref_id", $_GET["ref_id"]);
		
		if (!$a_omit_obj_id)
		{
			$obj_id = $_GET["obj_id"];
		}
		$lmtree =& $this->object->getTree();

		if (($obj_id != 0) && $lmtree->isInTree($obj_id))
		{
			$path = $lmtree->getPathFull($obj_id);
		}
		else
		{
			$path = $lmtree->getPathFull($lmtree->getRootId());
			if ($obj_id != 0)
			{
				$path[] = array("type" => "pg", "child" => $this->obj_id,
					"title" => ilLMPageObject::_getPresentationTitle($this->obj_id));
			}
		}

		$modifier = 1;

		foreach ($path as $key => $row)
		{
			if ($row["child"] == 1)
			{
				$this->ctrl->setParameter($this, "obj_id", "");
				$this->ctrl->addLocation(
					$this->object->getTitle(),
					$this->ctrl->getLinkTarget($this, "chapters"), "", $_GET["ref_id"]);
			}
			else
			{
				$title = $row["title"];
				switch($row["type"])
				{
					case "st":
						$this->ctrl->setParameterByClass("ilstructureobjectgui", "obj_id", $row["child"]);
						$this->ctrl->addLocation(
							$title,
							$this->ctrl->getLinkTargetByClass("ilstructureobjectgui", "view"));
						break;

					case "pg":
						$this->ctrl->setParameterByClass("illmpageobjectgui", "obj_id", $row["child"]);
						$this->ctrl->addLocation(
							$title,
							$this->ctrl->getLinkTargetByClass("illmpageobjectgui", "edit"));
						break;
				}
			}
		}
		if (!$a_omit_obj_id)
		{
			$this->ctrl->setParameter($this, "obj_id", $_GET["obj_id"]);
		}
	}

	////
	//// Questions
	////


	/**
	 * List questions
	 */
	function listQuestions()
	{
		global $tpl;

		$this->setTabs("questions");
		$this->setQuestionsSubTabs("question_stats");

		include_once("./Modules/LearningModule/classes/class.ilLMQuestionListTableGUI.php");
		$table = new ilLMQuestionListTableGUI($this, "listQuestions", $this->object);
		$tpl->setContent($table->getHTML());

	}

	/**
	 * List blocked users
	 */
	function listBlockedUsers()
	{
		global $tpl;

		$this->setTabs("questions");
		$this->setQuestionsSubTabs("blocked_users");

		include_once("./Modules/LearningModule/classes/class.ilLMBlockedUsersTableGUI.php");
		$table = new ilLMBlockedUsersTableGUI($this, "listBlockedUsers", $this->object);
		$tpl->setContent($table->getHTML());

	}

	/**
	 * Reset number of tries
	 */
	function resetNumberOfTries()
	{
		global $lng, $ilCtrl;

		include_once("./Services/COPage/classes/class.ilPageQuestionProcessor.php");
		if (is_array($_POST["userquest_id"]))
		{
			foreach ($_POST["userquest_id"] as $uqid)
			{
				$uqid = explode(":", $uqid);
				ilPageQuestionProcessor::resetTries((int) $uqid[0], (int) $uqid[1]);
			}
			ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		}
		$ilCtrl->redirect($this, "listBlockedUsers");
	}

	/**
	 * Unlock blocked question
	 */
	function unlockQuestion()
	{
		global $lng, $ilCtrl;

		include_once("./Services/COPage/classes/class.ilPageQuestionProcessor.php");
		if (is_array($_POST["userquest_id"]))
		{
			foreach ($_POST["userquest_id"] as $uqid)
			{
				$uqid = explode(":", $uqid);
				ilPageQuestionProcessor::unlock((int) $uqid[0], (int) $uqid[1]);
			}
			ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		}
		$ilCtrl->redirect($this, "listBlockedUsers");
	}

	/**
	 * Send Mail to blocked users
	 */
	function sendMailToBlockedUsers()
	{
		global $ilCtrl;

		if (!is_array($_POST["userquest_id"]))
		{
			ilUtil::sendFailure($this->lng->txt("no_checkbox"), 1);
			$ilCtrl->redirect($this, "listBlockedUsers");
		}

		$rcps = array();
		foreach($_POST["userquest_id"] as $uqid)
		{
			$uqid = explode(":", $uqid);
			$login = ilObjUser::_lookupLogin($uqid[1]);
			if (!in_array($login, $rcps))
			{
				$rcps[] = $login;
			}
		}
		require_once 'Services/Mail/classes/class.ilMailFormCall.php';
		ilUtil::redirect(ilMailFormCall::getRedirectTarget($this, 'listBlockedUsers',
			array(),
			array(
				'type' => 'new',
				'rcp_to' => implode(',',$rcps),
				'sig'	=> $this->getBlockedUsersMailSignature()
			)));
	}

	/**
	 * Get mail signature for blocked users
	 */
	protected function getBlockedUsersMailSignature()
	{
		$link = chr(13).chr(10).chr(13).chr(10);
		$link .= $this->lng->txt('cont_blocked_users_mail_link');
		$link .= chr(13).chr(10).chr(13).chr(10);
		include_once './Services/Link/classes/class.ilLink.php';
		$link .= ilLink::_getLink($this->object->getRefId());
		return rawurlencode(base64_encode($link));
	}

	
	////
	//// Tabs
	////


	/**
	* output tabs
	*/
	function setTabs($a_act = "")
	{
		global $lng, $ilHelp;
		
		$ilHelp->setScreenIdComponent("lm");
		
		$this->addTabs($a_act);
		parent::setTitleAndDescription();
		$this->tpl->setTitle($this->object->getTitle());
		$this->tpl->setTitleIcon(ilUtil::getImagePath("icon_lm.svg"),
			$lng->txt("obj_lm"));
	}

	/**
	 * Set pages tabs
	 *
	 * @param string $a_active active subtab
	 */
	function setContentSubTabs($a_active)
	{
		global $ilTabs, $lng, $ilCtrl;

		$lm_set = new ilSetting("lm");

		// chapters
		$ilTabs->addSubtab("chapters",
			$lng->txt("cont_chapters"),
			$ilCtrl->getLinkTarget($this, "chapters"));
		
		// all pages
		$ilTabs->addSubtab("pages",
			$lng->txt("cont_all_pages"),
			$ilCtrl->getLinkTarget($this, "pages"));

		// export ids
		if ($lm_set->get("html_export_ids"))
		{
			if (!ilObjContentObject::isOnlineHelpModule($this->object->getRefId()))
			{
				$ilTabs->addSubtab("export_ids",
					$lng->txt("cont_html_export_ids"),
					$ilCtrl->getLinkTarget($this, "showExportIDsOverview"));
			}
		}
		if (ilObjContentObject::isOnlineHelpModule($this->object->getRefId()))
		{
			$lng->loadLanguageModule("help");
			$ilTabs->addSubtab("export_ids",
				$lng->txt("cont_online_help_ids"),
				$ilCtrl->getLinkTarget($this, "showExportIDsOverview"));
			
			$ilTabs->addSubtab("help_tooltips",
				$lng->txt("help_tooltips"),
				$ilCtrl->getLinkTarget($this, "showTooltipList"));
		}
		
		// list links
		$ilTabs->addSubtab("internal_links",
			$lng->txt("cont_internal_links"),
			$ilCtrl->getLinkTarget($this, "listLinks"));

		// web link checker
		if ($this->object->getType() == "lm")
		{
			if(@include_once('HTTP/Request.php'))
			{
				$ilTabs->addSubtab("link_check",
					$lng->txt("link_check"),
					$ilCtrl->getLinkTarget($this, "linkChecker"));
			}
		}

		$ilTabs->addSubtab("history",
			$lng->txt("history"),
			$this->ctrl->getLinkTarget($this, "history"));

		// maintenance
		$ilTabs->addSubtab("maintenance",
			$lng->txt("cont_maintenance"),
			$ilCtrl->getLinkTarget($this, "showMaintenance"));
		
		$ilTabs->activateSubTab($a_active);
		$ilTabs->activateTab("content");
	}

	/**
	 * Set pages tabs
	 *
	 * @param string $a_active active subtab
	 */
	function setQuestionsSubTabs($a_active)
	{
		global $ilTabs, $lng, $ilCtrl;

		// chapters
		$ilTabs->addSubtab("question_stats",
			$lng->txt("cont_question_stats"),
			$ilCtrl->getLinkTarget($this, "listQuestions"));

		// blocked users
		$ilTabs->addSubtab("blocked_users",
			$lng->txt("cont_blocked_users"),
			$ilCtrl->getLinkTarget($this, "listBlockedUsers"));

		$ilTabs->activateSubTab($a_active);
	}

	/**
	 * Adds tabs
	 */
	function addTabs($a_act = "")
	{
		global $rbacsystem, $ilUser, $ilTabs, $lng;
		
		$tabs_gui = $ilTabs;

		// content
		$ilTabs->addTab("content",
			$lng->txt("content"),
			$this->ctrl->getLinkTarget($this, "chapters"));

		// info
		$ilTabs->addTab("info",
			$lng->txt("info_short"),
			$this->ctrl->getLinkTargetByClass("ilinfoscreengui",'showSummary'));
			
		// settings
		$ilTabs->addTab("settings",
			$lng->txt("settings"),
			$this->ctrl->getLinkTarget($this,'properties'));

		// questions
		$ilTabs->addTab("questions",
			$lng->txt("objs_qst"),
			$this->ctrl->getLinkTarget($this, "listQuestions"));

		// learning progress
		include_once './Services/Tracking/classes/class.ilLearningProgressAccess.php';
		if(ilLearningProgressAccess::checkAccess($this->object->getRefId()) and ($this->object->getType() == 'lm' or $this->object->getType() == 'dbk'))
		{
			$ilTabs->addTab('learning_progress',
				$lng->txt("learning_progress"),
				$this->ctrl->getLinkTargetByClass(array('illearningprogressgui'),''));
		}

		if ($this->object->getType() != "lm")
		{
			// bibliographical data
			$ilTabs->addTab("bib_data",
				$lng->txt("bib_data"),
				$this->ctrl->getLinkTarget($this, "editBibItem"));
		}

		// meta data
		$ilTabs->addTab("meta",
			$lng->txt("meta_data"),
			$this->ctrl->getLinkTargetByClass('ilmdeditorgui',''));

		if ($this->object->getType() == "lm")
		{				
			// export
			$ilTabs->addTab("export",
				$lng->txt("export"),
				$this->ctrl->getLinkTargetByClass("ilexportgui", ""));		
		}
		
		// permissions
		if ($rbacsystem->checkAccess('edit_permission',$this->object->getRefId()))
		{
			$ilTabs->addTab("perm",
				$lng->txt("perm_settings"),
				$this->ctrl->getLinkTargetByClass(array(get_class($this),'ilpermissiongui'), "perm"));
		}
		
		if ($a_act != "")
		{
			$ilTabs->activateTab($a_act);
		}
		
		// presentation view
		$ilTabs->addNonTabbedLink("pres_mode", $lng->txt("cont_presentation_view"),
			"ilias.php?baseClass=ilLMPresentationGUI&ref_id=".$this->object->getRefID(), "_top");
	}

	/**
	* Set sub tabs
	*/
	function setSubTabs($a_active)
	{
		global $ilTabs, $ilSetting;

		if (in_array($a_active,
			array("settings", "cont_style", "cont_lm_menu", "public_section",
				"cont_glossaries", "cont_multilinguality", "obj_multilinguality")))
		{
			// general properties
			$ilTabs->addSubTabTarget("settings",
				$this->ctrl->getLinkTarget($this, 'properties'),
				"", "");
				
			// style properties
			$ilTabs->addSubTabTarget("cont_style",
				$this->ctrl->getLinkTarget($this, 'editStyleProperties'),
				"", "");

			// menu properties
			$ilTabs->addSubTabTarget("cont_lm_menu",
				$this->ctrl->getLinkTarget($this, 'editMenuProperties'),
				"", "");

			// glossaries
			$ilTabs->addSubTabTarget("cont_glossaries",
				$this->ctrl->getLinkTarget($this, 'editGlossaries'),
				"", "");

			if ($ilSetting->get("pub_section"))
			{
				if ($this->object->getType() != "dbk")
				{
					// public section
					$ilTabs->addSubTabTarget("public_section",
						$this->ctrl->getLinkTarget($this, 'editPublicSection'),
						"", "");
				}
			}

			// multilinguality
			/* $ilTabs->addSubTabTarget("cont_multilinguality",
				$this->ctrl->getLinkTargetByClass("ilPageMultiLangGUI", ''),
				"", "");*/

			$ilTabs->addSubTabTarget("obj_multilinguality",
				$this->ctrl->getLinkTargetByClass("ilobjecttranslationgui", ""));

			$ilTabs->setSubTabActive($a_active);
		}
	}

	function editPublicSection()
	{
		global $ilTabs, $ilToolbar, $ilAccess;

		
		if (!$ilAccess->checkAccessOfUser(ANONYMOUS_USER_ID, "read", "", $this->object->getRefId()))
		{
			ilUtil::sendInfo($this->lng->txt("cont_anonymous_user_missing_perm"));
		}
		
		$this->setTabs();
		$this->setSubTabs("public_section");
		$ilTabs->setTabActive("settings");

		$this->tpl->addBlockFile("ADM_CONTENT", "adm_content", "tpl.lm_public_selector.html",
			"Modules/LearningModule");

		// get learning module object
		$this->lm_obj = new ilObjLearningModule($this->ref_id, true);


		// public mode
		$modes = array("complete" => $this->lng->txt("all_pages"), "selected" => $this->lng->txt("selected_pages_only"));
		include_once("./Services/Form/classes/class.ilSelectInputGUI.php");
		$si = new ilSelectInputGUI($this->lng->txt("choose_public_mode"), "lm_public_mode");
		$si->setOptions($modes);
		$si->setValue($this->object->getPublicAccessMode());
		$ilToolbar->addInputItem($si, true);
		$ilToolbar->addFormButton($this->lng->txt("save"), "savePublicSectionAccess");
		$ilToolbar->setFormAction($this->ctrl->getFormAction($this,"savePublicSectionAccess"));

		if ($this->object->getPublicAccessMode() == "selected")
		{
			$this->tpl->setCurrentBlock("select_pages");
			$this->tpl->setVariable("FORMACTION", $this->ctrl->getLinkTarget($this, "savePublicSectionPages"));

			include_once ("./Modules/LearningModule/classes/class.ilPublicSectionExplorerGUI.php");
			$tree = new ilPublicSectionExplorerGUI($this,"editPublicSection", $this->lm_obj);
			$tree->setSelectMode("pages", true);
			$tree->setSkipRootNode(true);

			$this->tpl->setVariable("EXPLORER",$tree->getHTML());
			$this->tpl->setVariable("TXT_SAVE", $this->lng->txt("save"));
			
			$this->tpl->parseCurrentBlock();
		}
	}

	function savePublicSection()
	{
		//var_dump($_POST["lm_public_mode"]);exit;
		$this->object->setPublicAccessMode($_POST["lm_public_mode"]);
		$this->object->updateProperties();
		ilLMObject::_writePublicAccessStatus($_POST["pages"],$this->object->getId());
		ilUtil::sendSuccess($this->lng->txt("msg_obj_modified"), true);
		$this->ctrl->redirect($this, "editPublicSection");
	}

	/**
	 * Saves lm access mode
	 */
	function savePublicSectionAccess()
	{
		$this->object->setPublicAccessMode($_POST["lm_public_mode"]);
		$this->object->updateProperties();
		ilUtil::sendSuccess($this->lng->txt("msg_obj_modified"), true);
		$this->ctrl->redirect($this, "editPublicSection");
	}

	/**
	 * Saves public lm pages
	 */
	function savePublicSectionPages()
	{
		ilLMObject::_writePublicAccessStatus($_POST["pages"],$this->object->getId());
		ilUtil::sendSuccess($this->lng->txt("msg_obj_modified"), true);
		$this->ctrl->redirect($this, "editPublicSection");
	}

	/**
	* history
	*
	* @access	public
	*/
	function history()
	{
		$this->setTabs("content");
		$this->setContentSubTabs("history");

		require_once("./Services/History/classes/class.ilHistoryTableGUI.php");
		$hist_gui =& new ilHistoryTableGUI($this,"history",
			$this->object->getId() ,$this->object->getType());
		$hist_gui->initTable();
		$hist_gui->setCommentVisibility($this->object->isActiveHistoryUserComments());

		$this->tpl->setContent($hist_gui->getHTML());
	}
	
	/**
	 * 
	 * @see		ilLinkCheckerGUIRowHandling::formatInvalidLinkArray()
	 * @param	array Unformatted array
	 * @return	array Formatted array
	 * @access	public
	 * 
	 */
	public function formatInvalidLinkArray(Array $row)
	{
		$row['title'] =  ilLMPageObject::_getPresentationTitle($row['page_id'], $this->object->getPageHeader());
	
		require_once 'Services/UIComponent/AdvancedSelectionList/classes/class.ilAdvancedSelectionListGUI.php';
		$actions = new ilAdvancedSelectionListGUI();
		$actions->setSelectionHeaderClass('small');	
		$actions->setItemLinkClass('xsmall');		
		$actions->setListTitle($this->lng->txt('actions'));		
		$actions->setId($row['page_id']);
		$this->ctrl->setParameterByClass('ilLMPageObjectGUI', 'obj_id', $row['page_id']);
		$actions->addItem(
			$this->lng->txt('edit'),
			'',
			$this->ctrl->getLinkTargetByClass('ilLMPageObjectGUI', 'edit')
		);
		$this->ctrl->clearParametersByClass('ilLMPageObjectGUI');
		$row['action_html'] = $actions->getHTML();		
		
		return $row;
	}

	function linkChecker()
	{
		global $ilias, $ilUser, $tpl;

		$this->__initLinkChecker();

		$this->setTabs();
		$this->setContentSubTabs("link_check");
		
		require_once './Services/LinkChecker/classes/class.ilLinkCheckerTableGUI.php';
		
		$toolbar = new ilToolbarGUI();
		
		// #13684
		include_once "Services/Cron/classes/class.ilCronManager.php";
		if(ilCronManager::isJobActive("lm_link_check"))
		{
			include_once './Services/LinkChecker/classes/class.ilLinkCheckNotify.php';
			include_once 'Services/Form/classes/class.ilPropertyFormGUI.php';
			
			$chb = new ilCheckboxInputGUI($this->lng->txt('link_check_message_a'), 'link_check_message');
			$chb->setValue(1);
			$chb->setChecked((bool)ilLinkCheckNotify::_getNotifyStatus($ilUser->getId(),$this->object->getId()));
			$chb->setOptionTitle($this->lng->txt('link_check_message_b'));
			
			$toolbar->addInputItem($chb);
			$toolbar->addFormButton($this->lng->txt('save'), 'saveLinkCheck');
			$toolbar->setFormAction($this->ctrl->getLinkTarget($this, 'saveLinkCheck'));
		}
		
		$tgui = new ilLinkCheckerTableGUI($this, 'linkChecker');
		$tgui->setLinkChecker($this->link_checker_obj)
			 ->setRowHandler($this)
			 ->setRefreshButton($this->lng->txt('refresh'), 'refreshLinkCheck');
		
		return $tpl->setContent($tgui->prepareHTML()->getHTML().$toolbar->getHTML());
	}
	
	function saveLinkCheck()
	{
		global $ilDB,$ilUser;

		include_once './Services/LinkChecker/classes/class.ilLinkCheckNotify.php';

		$link_check_notify =& new ilLinkCheckNotify($ilDB);
		$link_check_notify->setUserId($ilUser->getId());
		$link_check_notify->setObjId($this->object->getId());

		if($_POST['link_check_message'])
		{
			ilUtil::sendSuccess($this->lng->txt('link_check_message_enabled'));
			$link_check_notify->addNotifier();
		}
		else
		{
			ilUtil::sendSuccess($this->lng->txt('link_check_message_disabled'));
			$link_check_notify->deleteNotifier();
		}
		$this->linkChecker();

		return true;
	}



	function refreshLinkCheck()
	{
		$this->__initLinkChecker();

		if(!$this->link_checker_obj->checkPear())
		{
			ilUtil::sendFailure($this->lng->txt('missing_pear_library'));
			$this->linkChecker();

			return false;
		}

		$this->link_checker_obj->checkLinks();
		ilUtil::sendSuccess($this->lng->txt('link_checker_refreshed'));

		$this->linkChecker();

		return true;
	}

	function __initLinkChecker()
	{
		global $ilDB;

		include_once './Services/LinkChecker/classes/class.ilLinkChecker.php';

		$this->link_checker_obj =& new ilLinkChecker($ilDB,false);
		$this->link_checker_obj->setObjId($this->object->getId());

		return true;
	}

	function __initLMMenuEditor()
	{
		include_once './Modules/LearningModule/classes/class.ilLMMenuEditor.php';

		$this->lmme_obj =& new ilLMMenuEditor();
		$this->lmme_obj->setObjId($this->object->getId());

		return true;
	}

	/**
	* display add menu entry form
	*/
	function addMenuEntry()
	{
		global $ilTabs, $ilToolbar, $tpl, $ilCtrl;
		
		$this->setTabs();

		$ilTabs->setTabActive("settings");
		$this->setSubTabs("cont_lm_menu");

		$ilToolbar->addButton($this->lng->txt("lm_menu_select_internal_object"),
			$ilCtrl->getLinkTarget($this, "showEntrySelector"));
		
		$form = $this->initMenuEntryForm("create");
		$this->tpl->setContent($form->getHTML());
	}

	/**
	 * Init menu entry form.
	 *
	 * @param string $a_mode Edit Mode
	 */
	public function initMenuEntryForm($a_mode = "edit")
	{
		global $lng, $ilCtrl;
	
		include_once("Services/Form/classes/class.ilPropertyFormGUI.php");
		$form = new ilPropertyFormGUI();

		// title
		$ti = new ilTextInputGUI($this->lng->txt("lm_menu_entry_title"), "title");
		$ti->setMaxLength(255);
		$ti->setSize(40);
		$form->addItem($ti);
		
		// target
		$ta = new ilTextInputGUI($this->lng->txt("lm_menu_entry_target"), "target");
		$ta->setMaxLength(255);
		$ta->setSize(40);
		$form->addItem($ta);
		
		if ($a_mode == "edit")
		{
			$this->__initLMMenuEditor();
			$this->lmme_obj->readEntry($_REQUEST["menu_entry"]);
			$ti->setValue($this->lmme_obj->getTitle());
			$ta->setValue($this->lmme_obj->getTarget());
		}

		if (isset($_GET["link_ref_id"]))
		{
			$link_ref_id = (int) $_GET["link_ref_id"];
			$obj_type = ilObject::_lookupType($link_ref_id,true);
			$obj_id = ilObject::_lookupObjectId($link_ref_id);
			$title = ilObject::_lookupTitle($obj_id);

			$target_link = $obj_type."_".$link_ref_id;
			$ti->setValue($title);
			$ta->setValue($target_link);
			
			// link ref id
			$hi = new ilHiddenInputGUI("link_ref_id");
			$hi->setValue($link_ref_id);
			$form->addItem($hi);
		}
		
		
		// save and cancel commands
		if ($a_mode == "create")
		{
			$form->addCommandButton("saveMenuEntry", $lng->txt("save"));
			$form->addCommandButton("editMenuProperties", $lng->txt("cancel"));
			$form->setTitle($lng->txt("lm_menu_new_entry"));
		}
		else
		{
			$form->addCommandButton("updateMenuEntry", $lng->txt("save"));
			$form->addCommandButton("editMenuProperties", $lng->txt("cancel"));
			$form->setTitle($lng->txt("lm_menu_edit_entry"));
		}
		
		$form->setFormAction($ilCtrl->getFormAction($this));
	 
		return $form;
	}
	
	/**
	* save new menu entry
	*/
	function saveMenuEntry()
	{
		global $ilCtrl;
		
		// check title and target
		if (empty($_POST["title"]))
		{
			//$this->ilias->raiseError($this->lng->txt("please_enter_title"),$this->ilias->error_obj->MESSAGE);
			ilUtil::sendFailure($this->lng->txt("please_enter_title") , true);
			$ilCtrl->redirect($this, "addMenuEntry");
		}
		if (empty($_POST["target"]))
		{
			//$this->ilias->raiseError($this->lng->txt("please_enter_target"),$this->ilias->error_obj->MESSAGE);
			ilUtil::sendFailure($this->lng->txt("please_enter_target"), true);
			$ilCtrl->redirect($this, "addMenuEntry");
		}

		$this->__initLMMenuEditor();
		$this->lmme_obj->setTitle($_POST["title"]);
		$this->lmme_obj->setTarget($_POST["target"]);
		$this->lmme_obj->setLinkRefId($_POST["link_ref_id"]);

		if ($_POST["link_ref_id"])
		{
			$this->lmme_obj->setLinkType("intern");
		}

		$this->lmme_obj->create();

		ilUtil::sendSuccess($this->lng->txt("msg_entry_added"), true);
		$this->ctrl->redirect($this, "editMenuProperties");
	}

	/**
	* drop a menu entry
	*/
	function deleteMenuEntry()
	{
		if (empty($_GET["menu_entry"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_menu_entry_id"),$this->ilias->error_obj->MESSAGE);
		}

		$this->__initLMMenuEditor();
		$this->lmme_obj->delete($_GET["menu_entry"]);

		ilUtil::sendSuccess($this->lng->txt("msg_entry_removed"), true);
		$this->ctrl->redirect($this, "editMenuProperties");
	}

	/**
	* edit menu entry form
	*/
	function editMenuEntry()
	{
		global $ilToolbar, $ilCtrl;
		
		if (empty($_GET["menu_entry"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_menu_entry_id"),$this->ilias->error_obj->MESSAGE);
		}

		$ilCtrl->saveParameter($this, array("menu_entry"));
		$ilToolbar->addButton($this->lng->txt("lm_menu_select_internal_object"),
		$ilCtrl->getLinkTarget($this, "showEntrySelector"));
		
		$form = $this->initMenuEntryForm("edit");
		$this->tpl->setContent($form->getHTML());
	}

	/**
	* update a menu entry
	*/
	function updateMenuEntry()
	{
		if (empty($_REQUEST["menu_entry"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_menu_entry_id"),$this->ilias->error_obj->MESSAGE);
		}

		// check title and target
		if (empty($_POST["title"]))
		{
			$this->ilias->raiseError($this->lng->txt("please_enter_title"),$this->ilias->error_obj->MESSAGE);
		}
		if (empty($_POST["target"]))
		{
			$this->ilias->raiseError($this->lng->txt("please_enter_target"),$this->ilias->error_obj->MESSAGE);
		}

		$this->__initLMMenuEditor();
		$this->lmme_obj->readEntry($_REQUEST["menu_entry"]);
		$this->lmme_obj->setTitle($_POST["title"]);
		$this->lmme_obj->setTarget($_POST["target"]);
		$this->lmme_obj->update();

		ilUtil::sendSuccess($this->lng->txt("msg_entry_updated"), true);
		$this->ctrl->redirect($this, "editMenuProperties");
	}

	function showEntrySelector()
	{
		global $ilTabs, $ilCtrl;
		
		$this->setTabs();

		$ilTabs->setTabActive("settings");
		$this->setSubTabs("cont_lm_menu");

		$ilCtrl->saveParameter($this, array("menu_entry"));
		
		$this->tpl->addBlockFile("ADM_CONTENT", "adm_content", "tpl.lm_menu_object_selector.html","Modules/LearningModule");

		ilUtil::sendInfo($this->lng->txt("lm_menu_select_object_to_add"));

		require_once ("./Modules/LearningModule/classes/class.ilLMMenuObjectSelector.php");
		$exp = new ilLMMenuObjectSelector($this->ctrl->getLinkTarget($this,'test'),$this);

		$exp->setExpand($_GET["lm_menu_expand"] ? $_GET["lm_menu_expand"] : $this->tree->readRootId());
		$exp->setExpandTarget($this->ctrl->getLinkTarget($this,'showEntrySelector'));
		$exp->setTargetGet("ref_id");
		$exp->setRefId($this->cur_ref_id);

		$sel_types = array('mcst', 'mep', 'cat', 'lm','dbk','glo','frm','exc','tst','svy', 'chat', 'wiki', 'sahs',
			"crs", "grp", "book", "tst", "file");
		$exp->setSelectableTypes($sel_types);

		//$exp->setTargetGet("obj_id");

		// build html-output
		$exp->setOutput(0);
		$output = $exp->getOutput();

		// get page ids
		foreach ($exp->format_options as $node)
		{
			if (!$node["container"])
			{
				$pages[] = $node["child"];
			}
		}

		//$this->tpl->setCurrentBlock("content");
		//var_dump($this->object->getPublicAccessMode());
		// access mode selector
		$this->tpl->setVariable("TXT_SET_PUBLIC_MODE", $this->lng->txt("set_public_mode"));
		$this->tpl->setVariable("TXT_CHOOSE_PUBLIC_MODE", $this->lng->txt("choose_public_mode"));
		$modes = array("complete" => $this->lng->txt("all_pages"), "selected" => $this->lng->txt("selected_pages_only"));
		$select_public_mode = ilUtil::formSelect ($this->object->getPublicAccessMode(),"lm_public_mode",$modes, false, true);
		$this->tpl->setVariable("SELECT_PUBLIC_MODE", $select_public_mode);

		$this->tpl->setVariable("TXT_EXPLORER_HEADER", $this->lng->txt("choose_public_pages"));
		$this->tpl->setVariable("EXP_REFRESH", $this->lng->txt("refresh"));
		$this->tpl->setVariable("EXPLORER",$output);
		$this->tpl->setVariable("ONCLICK",$js_pages);
		$this->tpl->setVariable("TXT_CHECKALL", $this->lng->txt("check_all"));
		$this->tpl->setVariable("TXT_UNCHECKALL", $this->lng->txt("uncheck_all"));
		$this->tpl->setVariable("TXT_SAVE", $this->lng->txt("save"));
		$this->tpl->setVariable("FORMACTION", $this->ctrl->getLinkTarget($this, "savePublicSection"));
		//$this->tpl->parseCurrentBlock();
	}

	/**
	* select page as header
	*/
	function selectHeader()
	{
		if(!isset($_POST["id"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}
		if(count($_POST["id"]) > 1)
		{
			$this->ilias->raiseError($this->lng->txt("cont_select_max_one_item"),$this->ilias->error_obj->MESSAGE);
		}
		if ($_POST["id"][0] != $this->object->getHeaderPage())
		{
			$this->object->setHeaderPage($_POST["id"][0]);
		}
		else
		{
			$this->object->setHeaderPage(0);
		}
		$this->object->updateProperties();
		$this->ctrl->redirect($this, "pages");
	}

	/**
	* select page as footer
	*/
	function selectFooter()
	{
		if(!isset($_POST["id"]))
		{
			$this->ilias->raiseError($this->lng->txt("no_checkbox"),$this->ilias->error_obj->MESSAGE);
		}
		if(count($_POST["id"]) > 1)
		{
			$this->ilias->raiseError($this->lng->txt("cont_select_max_one_item"),$this->ilias->error_obj->MESSAGE);
		}
		if ($_POST["id"][0] != $this->object->getFooterPage())
		{
			$this->object->setFooterPage($_POST["id"][0]);
		}
		else
		{
			$this->object->setFooterPage(0);
		}
		$this->object->updateProperties();
		$this->ctrl->redirect($this, "pages");
	}

	/**
	* Save all titles of chapters/pages
	*/
	function saveAllTitles()
	{
		global $ilCtrl;
		
		ilLMObject::saveTitles($this->object, ilUtil::stripSlashesArray($_POST["title"]), $_GET["transl"]);
		
		$ilCtrl->redirect($this, "chapters");
	}

	/**
	* Insert (multiple) chapters at node
	*/
	function insertChapter()
	{
		global $ilCtrl, $lng;
		
		include_once("./Modules/LearningModule/classes/class.ilChapterHierarchyFormGUI.php");
		
		$num = ilChapterHierarchyFormGUI::getPostMulti();
		$node_id = ilChapterHierarchyFormGUI::getPostNodeId();
		
		if (!ilChapterHierarchyFormGUI::getPostFirstChild())	// insert after node id
		{
			$parent_id = $this->lm_tree->getParentId($node_id);
			$target = $node_id;
		}
		else													// insert as first child
		{
			$parent_id = $node_id;
			$target = IL_FIRST_NODE;
		}

		for ($i = 1; $i <= $num; $i++)
		{
			$chap = new ilStructureObject($this->object);
			$chap->setType("st");
			$chap->setTitle($lng->txt("cont_new_chap"));
			$chap->setLMId($this->object->getId());
			$chap->create();
			ilLMObject::putInTree($chap, $parent_id, $target);
		}

		$ilCtrl->redirect($this, "chapters");
	}
	
	/**
	* Insert Chapter from clipboard
	*/
	function insertChapterClip()
	{
		global $ilUser, $ilCtrl, $ilLog;
		
		include_once("./Modules/LearningModule/classes/class.ilChapterHierarchyFormGUI.php");
		
		$node_id = ilChapterHierarchyFormGUI::getPostNodeId();
		$first_child = ilChapterHierarchyFormGUI::getPostFirstChild();

		$ilLog->write("InsertChapterClip, num: $num, node_id: $node_id, ".
			" getPostFirstChild ".ilChapterHierarchyFormGUI::getPostFirstChild());

		if (!$first_child)	// insert after node id
		{
			$parent_id = $this->lm_tree->getParentId($node_id);
			$target = $node_id;
		}
		else													// insert as first child
		{
			$parent_id = $node_id;
			$target = IL_FIRST_NODE;
		}
		
		// copy and paste
		$chapters = $ilUser->getClipboardObjects("st", true);
		$copied_nodes = array();
		foreach ($chapters as $chap)
		{
			$ilLog->write("Call pasteTree, Target LM: ".$this->object->getId().", Chapter ID: ".$chap["id"]
				.", Parent ID: ".$parent_id.", Target: ".$target);
			$cid = ilLMObject::pasteTree($this->object, $chap["id"], $parent_id,
				$target, $chap["insert_time"], $copied_nodes,
				(ilEditClipboard::getAction() == "copy"));
			$target = $cid;
		}
		ilLMObject::updateInternalLinks($copied_nodes);

		if (ilEditClipboard::getAction() == "cut")
		{
			$ilUser->clipboardDeleteObjectsOfType("pg");
			$ilUser->clipboardDeleteObjectsOfType("st");
			ilEditClipboard::clear();
		}
		
		$this->object->checkTree();
		$ilCtrl->redirect($this, "chapters");
	}

	/**
	* redirect script
	*
	* @param	string		$a_target
	*/
	public static function _goto($a_target)
	{
		global $ilAccess, $ilErr, $lng;

		if ($ilAccess->checkAccess("read", "", $a_target))
		{
			$_GET["baseClass"] = "ilLMPresentationGUI";
			$_GET["ref_id"] = $a_target;
			include("ilias.php");
			exit;
		} else if ($ilAccess->checkAccess("visible", "", $a_target))
		{
			$_GET["baseClass"] = "ilLMPresentationGUI";
			$_GET["ref_id"] = $a_target;
			$_GET["cmd"] = "infoScreen";
			include("ilias.php");
			exit;
		}
		else if ($ilAccess->checkAccess("read", "", ROOT_FOLDER_ID))
		{
			ilUtil::sendFailure(sprintf($lng->txt("msg_no_perm_read_item"),
				ilObject::_lookupTitle(ilObject::_lookupObjId($a_target))), true);
			ilObjectGUI::_gotoRepositoryRoot();
		}


		$ilErr->raiseError($lng->txt("msg_no_perm_read_lm"), $ilErr->FATAL);
	}

	/**
	* Copy items to clipboard, then cut them from the current tree
	*/
	function cutItems($a_return = "chapters")
	{
		global $ilCtrl, $lng;
		
		$items = ilUtil::stripSlashesArray($_POST["id"]);
		if (!is_array($items))
		{
			ilUtil::sendFailure($lng->txt("no_checkbox"), true);
			$ilCtrl->redirect($this, $a_return);
		}

		$todel = array();			// delete IDs < 0 (needed for non-js editing)
		foreach($items as $k => $item)
		{
			if ($item < 0)
			{
				$todel[] = $k;
			}
		}
		foreach($todel as $k)
		{
			unset($items[$k]);
		}
		ilLMObject::clipboardCut($this->object->getId(), $items);
		ilEditClipboard::setAction("cut");
		ilUtil::sendInfo($lng->txt("cont_selected_items_have_been_cut"), true);
		
		$ilCtrl->redirect($this, $a_return);
	}

	/**
	* Copy items to clipboard
	*/
	function copyItems()
	{
		global $ilCtrl, $lng;
		
		$items = ilUtil::stripSlashesArray($_POST["id"]);
		if (!is_array($items))
		{
			ilUtil::sendFailure($lng->txt("no_checkbox"), true);
			$ilCtrl->redirect($this, "chapters");
		}

		$todel = array();				// delete IDs < 0 (needed for non-js editing)
		foreach($items as $k => $item)
		{
			if ($item < 0)
			{
				$todel[] = $k;
			}
		}
		foreach($todel as $k)
		{
			unset($items[$k]);
		}
		ilLMObject::clipboardCopy($this->object->getId(), $items);
		ilEditClipboard::setAction("copy");
		ilUtil::sendInfo($lng->txt("cont_selected_items_have_been_copied"), true);
		$ilCtrl->redirect($this, "chapters");
	}

	/**
	* Cut chapter(s)
	*/
	function cutChapter()
	{
		$this->cutItems("chapters");
	}

	////
	//// HTML export IDs
	////

	/**
	 * Show export IDs overview
	 *
	 * @param
	 * @return
	 */
	function showExportIDsOverview($a_validation = false)
	{
		global $tpl, $ilToolbar, $lng, $ilCtrl;

		$this->setTabs();
		$this->setContentSubTabs("export_ids");
		
		if (ilObjContentObject::isOnlineHelpModule($this->object->getRefId()))
		{
			// toolbar
			$ilToolbar->setFormAction($ilCtrl->getFormAction($this));
			include_once("./Services/Form/classes/class.ilSelectInputGUI.php");
			$lm_tree = $this->object->getTree();
			$childs = $lm_tree->getChilds($lm_tree->readRootId());
			$options = array("" => $lng->txt("all"));
			foreach ($childs as $c)
			{
				$options[$c["child"]] = $c["title"];
			}
			$si = new ilSelectInputGUI($this->lng->txt("help_component"), "help_chap");
			$si->setOptions($options);
			$si->setValue(ilSession::get("help_chap"));
			$ilToolbar->addInputItem($si, true);
			$ilToolbar->addFormButton($lng->txt("help_filter"), "filterHelpChapters");
			
			include_once("./Modules/LearningModule/classes/class.ilHelpMappingTableGUI.php");
			$tbl = new ilHelpMappingTableGUI($this, "showExportIDsOverview", $a_validation, false);
		}
		else
		{
			include_once("./Modules/LearningModule/classes/class.ilExportIDTableGUI.php");
			$tbl = new ilExportIDTableGUI($this, "showExportIDsOverview", $a_validation, false);
		}

		$tpl->setContent($tbl->getHTML());
	}
	
	/**
	 * Filter help chapters
	 *
	 * @param
	 * @return
	 */
	function filterHelpChapters()
	{
		global $ilCtrl;
		
		ilSession::set("help_chap", ilUtil::stripSlashes($_POST["help_chap"]));
		$ilCtrl->redirect($this, "showExportIDsOverview");
	}
	

	/**
	 * Save export IDs
	 */
	function saveExportIds()
	{
		global $ilCtrl, $lng;

		// check all export ids
		$ok = true;
		if (is_array($_POST["exportid"]))
		{
			foreach ($_POST["exportid"] as $pg_id => $exp_id)
			{
				if ($exp_id != "" && !preg_match("/^([a-zA-Z]+)[0-9a-zA-Z_]*$/",
					trim($exp_id)))
				{
					$ok = false;
				}
			}
		}
		if (!$ok)
		{
			ilUtil::sendFailure($lng->txt("cont_exp_ids_not_resp_format1").": a-z, A-Z, 0-9, '_'. ".
				$lng->txt("cont_exp_ids_not_resp_format3")." ".
				$lng->txt("cont_exp_ids_not_resp_format2"));
			$this->showExportIDsOverview(true);
			return;
		}


		if (is_array($_POST["exportid"]))
		{
			foreach ($_POST["exportid"] as $pg_id => $exp_id)
			{
				ilLMPageObject::saveExportId($this->object->getId(), $pg_id,
					ilUtil::stripSlashes($exp_id), ilLMObject::_lookupType($pg_id));
			}
		}

		ilUtil::sendSuccess($lng->txt("cont_saved_export_ids"), true);
		$ilCtrl->redirect($this, "showExportIdsOverview");
	}

	/**
	 * Save help mapping
	 *
	 * @param
	 * @return
	 */
	function saveHelpMapping()
	{
		global $lng, $ilCtrl;
		
		include_once("./Services/Help/classes/class.ilHelpMapping.php");
		if (is_array($_POST["screen_ids"]))
		{
			foreach ($_POST["screen_ids"] as $chap => $ids)
			{
				$ids = explode("\n", $ids);
				ilHelpMapping::saveScreenIdsForChapter($chap, $ids);
			}
		}
		ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		$ilCtrl->redirect($this, "showExportIdsOverview");
	}
	
	////
	//// Help tooltips
	////

	/**
	 * Show export IDs overview
	 *
	 * @param
	 * @return
	 */
	function showTooltipList()
	{
		global $tpl, $ilToolbar, $ilCtrl, $lng;

		$this->setTabs();
		$this->setContentSubTabs("help_tooltips");
		
		$ilToolbar->setFormAction($ilCtrl->getFormAction($this));
		include_once("./Services/Form/classes/class.ilTextInputGUI.php");
		$ti = new ilTextInputGUI($this->lng->txt("help_tooltip_id"), "tooltip_id");
		$ti->setMaxLength(200);
		$ti->setSize(20);
		$ilToolbar->addInputItem($ti, true);
		$ilToolbar->addFormButton($lng->txt("add"), "addTooltip");
		$ilToolbar->addSeparator();
		
		include_once("./Services/Form/classes/class.ilSelectInputGUI.php");
		$options = ilHelp::getTooltipComponents();
		if (ilSession::get("help_tt_comp") != "")
		{
			$options[ilSession::get("help_tt_comp")] = ilSession::get("help_tt_comp");
		}
		$si = new ilSelectInputGUI($this->lng->txt("help_component"), "help_tt_comp");
		$si->setOptions($options);
		$si->setValue(ilSession::get("help_tt_comp"));
		$ilToolbar->addInputItem($si, true);
		$ilToolbar->addFormButton($lng->txt("help_filter"), "filterTooltips");
		
		include_once("./Modules/LearningModule/classes/class.ilHelpTooltipTableGUI.php");
		$tbl = new ilHelpTooltipTableGUI($this, "showTooltipList", ilSession::get("help_tt_comp"));

		$tpl->setContent($tbl->getHTML());
	}

	/**
	 * Add tooltip
	 *
	 * @param
	 * @return
	 */
	function addTooltip()
	{
		global $lng, $ilCtrl;
		
		$tt_id = ilUtil::stripSlashes($_POST["tooltip_id"]);
		if (trim($tt_id) != "")
		{
			if (is_int(strpos($tt_id, "_")))
			{
				include_once("./Services/Help/classes/class.ilHelp.php");
				ilHelp::addTooltip(trim($tt_id), "");
				ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);

				$fu = strpos($tt_id, "_");
				$comp = substr($tt_id, 0, $fu);
				ilSession::set("help_tt_comp", ilUtil::stripSlashes($comp));
			}
			else
			{
				ilUtil::sendFailure($lng->txt("cont_help_no_valid_tooltip_id"), true);
			}
		}
		$ilCtrl->redirect($this, "showTooltipList");
	}
	
	/**
	 * Filter tooltips
	 *
	 * @param
	 * @return
	 */
	function filterTooltips()
	{
		global $lng, $ilCtrl;
		
		ilSession::set("help_tt_comp", ilUtil::stripSlashes($_POST["help_tt_comp"]));
		$ilCtrl->redirect($this, "showTooltipList");
	}
	
	
	/**
	 * Save tooltips
	 *
	 * @param
	 * @return
	 */
	function saveTooltips()
	{
		global $ilCtrl, $lng;
		
		include_once("./Services/Help/classes/class.ilHelp.php");

		if (is_array($_POST["text"]))
		{
			foreach ($_POST["text"] as $id => $text)
			{
				ilHelp::updateTooltip((int) $id, ilUtil::stripSlashes($text),
					ilUtil::stripSlashes($_POST["tt_id"][(int) $id]));
			}
			ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		}
		$ilCtrl->redirect($this, "showTooltipList");
	}
	
	/**
	 * Delete tooltips
	 */
	function deleteTooltips()
	{
		global $lng, $ilCtrl;
		
		if (is_array($_POST["id"]))
		{
			include_once("./Services/Help/classes/class.ilHelp.php");
			foreach ($_POST["id"] as $id)
			{
				ilHelp::deleteTooltip((int) $id);
			}
			ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		}
		$ilCtrl->redirect($this, "showTooltipList");
	}

	/**
	 * Save help mapping
	 *
	 * @param
	 * @return
	 */
/*	function saveHelpMapping()
	{
		global $lng, $ilCtrl;
		
		include_once("./Services/Help/classes/class.ilHelpMapping.php");
		if (is_array($_POST["screen_ids"]))
		{
			foreach ($_POST["screen_ids"] as $chap => $ids)
			{
				$ids = explode("\n", $ids);
				ilHelpMapping::saveScreenIdsForChapter($chap, $ids);
			}
		}
		ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		$ilCtrl->redirect($this, "showExportIdsOverview");
	}*/

	
	////
	//// Set layout
	////
	
	/**
	 * Get layout option
	 *
	 * @return object layout form option
	 */
	static function getLayoutOption($a_txt, $a_var, $a_def_option = "")
	{
		global $lng;
		
		// default layout
		$layout = new ilRadioGroupInputGUI($a_txt, $a_var);
		if ($a_def_option != "")
		{
			if (is_file($im = ilUtil::getImagePath("layout_".$a_def_option.".png")))
			{
				$im_tag = ilUtil::img($im, $a_def_option);
			}
			$layout->addOption(new ilRadioOption("<table><tr><td>".$im_tag."</td><td><b>".
				$lng->txt("cont_lm_default_layout").
				"</b>: ".$lng->txt("cont_layout_".$a_def_option).
				"</td></tr></table>", ""));
		}
		foreach(ilObjContentObject::getAvailableLayouts() as $l)
		{
			$im_tag = "";
			if (is_file($im = ilUtil::getImagePath("layout_".$l.".png")))
			{
				$im_tag = ilUtil::img($im, $l);
			}
			$layout->addOption(new ilRadioOption("<table><tr><td style='padding: 0px 5px 5px;'>".
				$im_tag."</td><td style='padding:5px;'><b>".$lng->txt("cont_layout_".$l)."</b>: ".
				$lng->txt("cont_layout_".$l."_desc")."</td></tr></table>", $l));
		}
		
		return $layout;
	}
	
	/**
	 * Set layout for multipl pages
	 */
	function setPageLayoutInHierarchy()
	{
		global $ilCtrl;
		$ilCtrl->setParameter($this, "hierarchy", "1");
		$this->setPageLayout(true);
	}
	
	
	/**
	 * Set layout for multipl pages
	 */
	function setPageLayout($a_in_hierarchy = false)
	{
		global $tpl, $ilCtrl, $lng;
		
		if (!is_array($_POST["id"]))
		{
			ilUtil::sendFailure($lng->txt("no_checkbox"), true);
			
			if ($a_in_hierarchy)
			{
				$ilCtrl->redirect($this, "chapters");
			}
			else
			{
				$ilCtrl->redirect($this, "pages");
			}
		}
		
		$this->initSetPageLayoutForm();
		
		$tpl->setContent($this->form->getHTML());
	}
	
	/**
	 * Init set page layout form.
	 */
	public function initSetPageLayoutForm()
	{
		global $lng, $ilCtrl;
	
		include_once("Services/Form/classes/class.ilPropertyFormGUI.php");
		$this->form = new ilPropertyFormGUI();
		
		if (is_array($_POST["id"]))
		{
			foreach ($_POST["id"] as $id)
			{
				$hi = new ilHiddenInputGUI("id[]");
				$hi->setValue($id);
				$this->form->addItem($hi);
			}
		}
		$layout = self::getLayoutOption($lng->txt("cont_layout"), "layout",
			$this->object->getLayout());
		$this->form->addItem($layout);
	
		$this->form->addCommandButton("savePageLayout", $lng->txt("save"));
		$this->form->addCommandButton("pages", $lng->txt("cancel"));
		
		$this->form->setTitle($lng->txt("cont_set_layout"));
		$this->form->setFormAction($ilCtrl->getFormAction($this));
	 
	}
	
	/**
	 * Save page layout
	 */
	function savePageLayout()
	{
		global $lng, $ilCtrl;
		
		$ilCtrl->setParameter($this, "hierarchy", $_GET["hierarchy"]);
		
		foreach ($_POST["id"] as $id)
		{
			ilLMPageObject::writeLayout(ilUtil::stripSlashes($id),
				ilUtil::stripSlashes($_POST["layout"]),
				$this->object);
		}
		ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		
		if ($_GET["hierarchy"] == 1)
		{
			$ilCtrl->redirect($this, "chapters");
		}
		else
		{
			$ilCtrl->redirect($this, "pages");
		}
	}
	
	//
	// Auto glossaries
	//
	
	/**
	 * Edit automatically linked glossaries
	 *
	 * @param
	 * @return
	 */
	function editGlossaries()
	{
		global $tpl, $ilToolbar, $lng, $ilCtrl, $ilTabs;
		
		$this->setTabs();
		$ilTabs->setTabActive("settings");
		$this->setSubTabs("cont_glossaries");
		
		$ilToolbar->addButton($lng->txt("add"),
			$ilCtrl->getLinkTarget($this, "showLMGlossarySelector"));
		
		include_once("./Modules/LearningModule/classes/class.ilLMGlossaryTableGUI.php");
		$tab = new ilLMGlossaryTableGUI($this->object, $this, "editGlossaries");
		
		$tpl->setContent($tab->getHTML());
	}
	
	/**
	 * Select LM Glossary
	 *
	 * @param
	 * @return
	 */
	function showLMGlossarySelector()
	{
		global $tpl, $lng, $ilCtrl, $tree, $ilUser, $ilTabs;
		
		$this->setTabs();
		$ilTabs->setTabActive("settings");
		$this->setSubTabs("cont_glossaries");

		include_once 'Services/Search/classes/class.ilSearchRootSelector.php';
		
		$exp = new ilSearchRootSelector($ilCtrl->getLinkTarget($this,'showLMGlossarySelector'));
		$exp->setExpand($_GET["search_root_expand"] ? $_GET["search_root_expand"] : $tree->readRootId());
		$exp->setExpandTarget($ilCtrl->getLinkTarget($this,'showLMGlossarySelector'));
		$exp->setTargetClass(get_class($this));
		$exp->setCmd('confirmGlossarySelection');
		$exp->setClickableTypes(array("glo"));
		$exp->addFilter("glo");

		// build html-output
		$exp->setOutput(0);
		$tpl->setContent($exp->getOutput());

	}
	
	/**
	 * Confirm glossary selection
	 */
	function confirmGlossarySelection()
	{
		global $ilCtrl, $tpl, $lng;
			
		include_once("./Services/Utilities/classes/class.ilConfirmationGUI.php");
		$cgui = new ilConfirmationGUI();
		$ilCtrl->setParameter($this, "glo_ref_id", $_GET["root_id"]);
		$cgui->setFormAction($ilCtrl->getFormAction($this));
		$cgui->setHeaderText($lng->txt("cont_link_glo_in_lm"));
		$cgui->setCancel($lng->txt("no"), "selectLMGlossary");
		$cgui->setConfirm($lng->txt("yes"), "selectLMGlossaryLink");
		$tpl->setContent($cgui->getHTML());
	}
	
	/**
	 * Select a glossary and link all its terms 
	 *
	 * @param
	 * @return
	 */
	function selectLMGlossaryLink()
	{
		$glo_ref_id = (int) $_GET["glo_ref_id"];
		$glo_id = ilObject::_lookupObjId($glo_ref_id);
		$this->object->autoLinkGlossaryTerms($glo_id);
		$this->selectLMGlossary();
	}
	
	
	/**
	 * Select lm glossary
	 *
	 * @param
	 * @return
	 */
	function selectLMGlossary()
	{
		global $ilCtrl, $lng;
		
		$glos = $this->object->getAutoGlossaries();
		$glo_ref_id = (int) $_GET["glo_ref_id"];
		$glo_id = ilObject::_lookupObjId($glo_ref_id);
		if (!in_array($glo_id, $glos))
		{
			$glos[] = $glo_id;
		}
		$this->object->setAutoGlossaries($glos);
		$this->object->update();
		
		ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		$ilCtrl->redirect($this, "editGlossaries");
	}
	
	/**
	 * Remove lm glossary
	 *
	 * @param
	 * @return
	 */
	function removeLMGlossary()
	{
		global $ilCtrl, $lng;
		
		$this->object->removeAutoGlossary((int) $_GET["glo_id"]);
		$this->object->update();
		
		ilUtil::sendSuccess($lng->txt("msg_obj_modified"), true);
		$ilCtrl->redirect($this, "editGlossaries");
	}
	
	/**
	 * Edit master language
	 *
	 * @param
	 * @return
	 */
	function editMasterLanguage()
	{
		global $ilCtrl;
		
		$ilCtrl->setParameter($this, "transl", "");
		$ilCtrl->redirect($this, "chapters");
	}

	/**
	 * Switch to language
	 *
	 * @param
	 * @return
	 */
	function switchToLanguage()
	{
		global $ilCtrl;
		
		$ilCtrl->setParameter($this, "transl", $_GET["totransl"]); 
		$ilCtrl->redirect($this, "chapters");
	}
	
	function redrawHeaderAction()
	{
		// #12281
		return parent::redrawHeaderActionObject();
	}

}
?>
