/*
 * Decompiled with CFR 0.152.
 */
package chatserver.handler;

import chatserver.ActionHandler;
import chatserver.ActionHandlerException;
import chatserver.HttpChatCallInformation;
import chatserver.Message;
import chatserver.MissingArgumentException;
import chatserver.Subscriber;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostActionHandler
implements ActionHandler {
    @Override
    public Map<String, Object> handle(HttpChatCallInformation info) throws ActionHandlerException {
        if (!info.getParams().containsKey("message")) {
            throw new ActionHandlerException(new MissingArgumentException("no message given"));
        }
        int sub = 0;
        if (info.getParams().containsKey("sub")) {
            sub = info.getParams().getInt("sub");
        }
        String recipients = (String)info.getParams().get("recipients");
        int publicMessage = info.getParams().getInt("public");
        if (publicMessage == 0 && recipients != null) {
            String[] recipientsArray;
            for (String recipient : recipientsArray = recipients.split(",")) {
                try {
                    Subscriber subscriber = info.getScope().getSubscibers().getSubscriberById(Integer.parseInt(recipient));
                    if (subscriber == null || sub != 0 && !info.getScope().isSubscriberSubscribedToSubScope(subscriber, sub)) continue;
                    subscriber.addMessage(new Message((String)info.getParams().get("message")));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Message message = new Message((String)info.getParams().get("message"));
            if (sub == 0) {
                info.getScope().getSubscibers().notify(message);
            } else {
                info.getScope().getSubScopeSubscribers(sub).notify(message);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        return result;
    }
}

