/*
 * Decompiled with CFR 0.152.
 */
package chatserver.handler;

import chatserver.ActionHandler;
import chatserver.ActionHandlerException;
import chatserver.HttpChatCallInformation;
import chatserver.MapMessageNotifier;
import chatserver.MissingArgumentException;
import chatserver.Subscriber;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollActionHandler
implements ActionHandler {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public Map<String, Object> handle(HttpChatCallInformation info) throws ActionHandlerException {
        int nextPosition;
        if (!info.getParams().containsKey("id")) {
            throw new ActionHandlerException(new MissingArgumentException("id"));
        }
        if (!info.getParams().containsKey("pos")) {
            throw new ActionHandlerException(new MissingArgumentException("pos"));
        }
        int id = info.getParams().getInt("id");
        int buffer_position = info.getParams().getInt("pos");
        if (info.getScope().getSubscibers().getSubscriberBySessionId(id) == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("subscribed", false);
            result.put("messages", new LinkedList());
            result.put("next_position", 0);
            return result;
        }
        Subscriber subscriber = info.getScope().getSubscibers().getSubscriberBySessionId(id);
        subscriber.refreshSubscription();
        Logger.getLogger("default").log(Level.FINEST, "[{0}] Session refreshed for subscriber {1,number} in scope {2,number}, Current datetime: {3}", new Object[]{info.getInstance().getIliasClient(), subscriber.getId(), info.getScope().getId(), this.sdf.format(new Date(subscriber.getLastConnect()))});
        MapMessageNotifier notifier = new MapMessageNotifier();
        double secondsWaited = 0.0;
        int startingPosition = nextPosition = buffer_position;
        try {
            while ((nextPosition = subscriber.notify(notifier, buffer_position)) == startingPosition) {
                Thread.sleep(500L);
                if (notifier.getMessages().size() == 0 && (secondsWaited += 0.5) < 1.0) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new ActionHandlerException(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("messages", notifier.getMessages());
        result.put("next_position", nextPosition);
        result.put("subscribed", true);
        return result;
    }
}

