/*
 * Decompiled with CFR 0.152.
 */
package chatserver.handler;

import chatserver.ActionHandler;
import chatserver.ActionHandlerException;
import chatserver.ChatScope;
import chatserver.HttpChatCallInformation;
import chatserver.Message;
import chatserver.MissingArgumentException;
import chatserver.RemoteInstance;
import chatserver.Subscriber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KickActionHandler
implements ActionHandler {
    @Override
    public Map<String, Object> handle(HttpChatCallInformation info) throws ActionHandlerException {
        if (!info.getParams().containsKey("message")) {
            throw new ActionHandlerException(new MissingArgumentException("no message given"));
        }
        int userToKick = info.getParams().getInt("userToKick");
        Subscriber user = info.getScope().getSubscibers().getSubscriberById(userToKick);
        info.getScope().getSubscibers().notify(new Message((String)info.getParams().get("message")));
        info.getScope().detatchSubscriber(info.getScope().getSubscibers().getSubscriberById(userToKick));
        try {
            this.sendFeedback(info.getInstance(), info.getScope(), user);
        }
        catch (Exception e) {
            throw new ActionHandlerException(e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFeedback(RemoteInstance instance, ChatScope scope, Subscriber user) throws IOException {
        String query = "task=disconnectedUsers&handledAction=kick&scope[" + scope.getId() + "]=" + user.getId();
        URLConnection connection = instance.getFeedbackConnection("");
        Logger.getLogger("default").log(Level.INFO, "[{0}] Calling {1} for disconnected users", new Object[]{instance.getIliasClient(), connection.getURL()});
        Logger.getLogger("default").log(Level.INFO, "[{0}] Body {1}", new Object[]{instance.getIliasClient(), query});
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept-Charset", "utf-8");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        OutputStream output = null;
        InputStream in = null;
        try {
            output = connection.getOutputStream();
            output.write(query.getBytes("utf-8"));
            in = connection.getInputStream();
        }
        catch (Exception e) {
            Logger.getLogger("default").log(Level.SEVERE, null, e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Logger.getLogger("default").log(Level.SEVERE, null, e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Logger.getLogger("default").log(Level.SEVERE, null, e);
                }
            }
        }
    }
}

