/*
 * Decompiled with CFR 0.152.
 */
package chatserver.handler;

import chatserver.ActionHandler;
import chatserver.ActionHandlerException;
import chatserver.HttpChatCallInformation;
import chatserver.Message;
import chatserver.MissingArgumentException;
import chatserver.Subscriber;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectActionHandler
implements ActionHandler {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static HashSet<Integer> knownSessionIdSet = new HashSet();

    private static int generateSessionId() {
        int tmp;
        Random generator = new Random(System.currentTimeMillis());
        while (knownSessionIdSet.contains(tmp = generator.nextInt())) {
        }
        knownSessionIdSet.add(tmp);
        return tmp;
    }

    @Override
    public Map<String, Object> handle(HttpChatCallInformation info) throws ActionHandlerException {
        if (!info.getParams().containsKey("id")) {
            throw new ActionHandlerException(new MissingArgumentException("id"));
        }
        int id = info.getParams().getInt("id");
        HashMap<String, Object> result = new HashMap<String, Object>();
        int sessionId = ConnectActionHandler.generateSessionId();
        if (info.getScope().getSubscibers().getSubscriberById(id) != null) {
            Subscriber subscriber = info.getScope().getSubscibers().getSubscriberById(id);
            info.getScope().getSubscibers().registerSession(sessionId, subscriber);
            Logger.getLogger("default").log(Level.INFO, "[{0}] Registered session {1,number} for substriber {2,number} in scope {3,number}", new Object[]{info.getInstance().getIliasClient(), sessionId, subscriber.getId(), info.getScope().getId()});
        } else {
            Subscriber subscriber = new Subscriber();
            subscriber.setId(id);
            subscriber.addSessionId(sessionId);
            info.getScope().attatchSubscriber(subscriber);
            Logger.getLogger("default").log(Level.INFO, "[{0}] Registered session {1,number} for new substriber {2,number} in scope {3,number}", new Object[]{info.getInstance().getIliasClient(), sessionId, subscriber.getId(), info.getScope().getId()});
            if (info.getParams().containsKey("message") && ((String)info.getParams().get("message")).length() > 0) {
                info.getScope().getSubscibers().notify(new Message((String)info.getParams().get("message")));
            }
        }
        result.put("session-id", sessionId);
        return result;
    }
}

