/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.Message;
import chatserver.Subscriber;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriberList
implements Iterable<Subscriber> {
    private List<Subscriber> subscribers = new LinkedList<Subscriber>();
    private Map<Integer, Subscriber> subscribersById = new HashMap<Integer, Subscriber>();
    private Map<Integer, Subscriber> subscribersBySessionId = new HashMap<Integer, Subscriber>();

    public void add(Subscriber subscriber) {
        this.subscribers.add(subscriber);
        this.subscribersById.put(subscriber.getId(), subscriber);
        for (Integer id : subscriber.getSessions()) {
            this.subscribersBySessionId.put(id, subscriber);
        }
    }

    public Subscriber getSubscriberById(int id) {
        return this.subscribersById.get(id);
    }

    public Subscriber getSubscriberBySessionId(int id) {
        return this.subscribersBySessionId.get(id);
    }

    public void remove(Subscriber subscriber) {
        this.subscribers.remove(subscriber);
        this.subscribersById.remove(subscriber.getId());
        for (Integer id : subscriber.getSessions()) {
            this.subscribersBySessionId.remove(id);
        }
    }

    @Override
    public Iterator<Subscriber> iterator() {
        return new Iterator<Subscriber>(){
            private Iterator<Subscriber> iterator;
            private Subscriber current;
            {
                this.iterator = SubscriberList.this.subscribers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Subscriber next() {
                this.current = this.iterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                SubscriberList.this.subscribersById.remove(this.current.getId());
            }
        };
    }

    public void notify(Message message) {
        for (Subscriber subscriber : this.subscribers) {
            subscriber.addMessage(message);
        }
    }

    public int size() {
        return this.subscribers.size();
    }

    public void registerSession(int sessionId, Subscriber subscriber) {
        subscriber.addSessionId(sessionId);
        this.subscribersBySessionId.put(sessionId, subscriber);
    }
}

