/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.BufferMessage;
import chatserver.Message;
import chatserver.MessageBuffer;
import chatserver.MessageNotifier;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscriber {
    private MessageBuffer buffer = new MessageBuffer();
    private int id;
    private long lastConnect = System.currentTimeMillis();
    private List<Integer> sessions = new LinkedList<Integer>();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void addMessage(Message message) {
        this.buffer.enqueue(message);
    }

    public int notify(MessageNotifier notifier, int position) {
        BufferMessage message = null;
        while (this.buffer.hasEntries(position) && (message = this.buffer.dequeue(position)) != null) {
            notifier.notify(message.getMessage());
            position = message.getPosition();
        }
        if (position == -1) {
            position = this.buffer.getListEndPosition();
        }
        return message == null ? position : message.getPosition();
    }

    public void refreshSubscription() {
        this.lastConnect = System.currentTimeMillis();
    }

    public long getLastConnect() {
        return this.lastConnect;
    }

    public void addSessionId(int id) {
        this.sessions.add(id);
    }

    public List<Integer> getSessions() {
        return this.sessions;
    }
}

