/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.ChatScopeList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteInstance {
    private String name;
    private String hash;
    private String feedbackUrl;
    private ChatScopeList scopeList = new ChatScopeList();
    private String iliasSession;
    private String iliasClient;
    private String iliasUser;
    private String iliasPassword;
    private long lastLoggedIn;

    public RemoteInstance(String name, String hash, String feedbackUrl) {
        this.name = name;
        this.hash = hash;
        this.feedbackUrl = feedbackUrl;
        if (this.feedbackUrl.charAt(this.feedbackUrl.length() - 1) != '/') {
            this.feedbackUrl = this.feedbackUrl + "/";
        }
    }

    public static RemoteInstance fromProperties(Properties props) {
        RemoteInstance instance = new RemoteInstance(props.getProperty("name"), props.getProperty("hash"), props.getProperty("url"));
        instance.setIliasUser(props.getProperty("user"));
        instance.setIliasPassword(props.getProperty("password"));
        instance.setIliasClient(props.getProperty("client"));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection getFeedbackConnection(String query) throws MalformedURLException, IOException {
        RemoteInstance remoteInstance = this;
        synchronized (remoteInstance) {
            if (System.currentTimeMillis() - this.lastLoggedIn > 60000L) {
                this.login();
            }
        }
        if (!query.equals("")) {
            query = "&" + query;
        }
        URL url = new URL(this.feedbackUrl + "ilias.php?baseClass=ilObjChatroomGUI&serverInquiry=true" + query);
        URLConnection con = url.openConnection();
        Logger.getLogger("default").finer("[" + this.getIliasClient() + "] Calling ILIAS with session " + this.getIliasSession());
        con.setRequestProperty("Cookie", "ilClientId=" + this.getIliasClient() + ";" + "PHPSESSID=" + this.getIliasSession());
        return con;
    }

    public void login() {
        block7: {
            String soapURL = this.feedbackUrl + "webservice/soap/server.php";
            HttpURLConnection connection = null;
            try {
                int c;
                URL u = new URL(soapURL);
                URLConnection uc = u.openConnection();
                connection = (HttpURLConnection)uc;
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("SOAPAction", "urn:ilUserAdministration#login");
                connection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
                OutputStream out = connection.getOutputStream();
                OutputStreamWriter wout = new OutputStreamWriter(out);
                wout.write("<SOAP-ENV:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:ilUserAdministration\">\n");
                wout.write("<SOAP-ENV:Header/>\n");
                wout.write("<SOAP-ENV:Body>\n");
                wout.write("<urn:login soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n");
                wout.write("<client xsi:type=\"xsd:string\">" + this.getIliasClient() + "</client>\n");
                wout.write("<username xsi:type=\"xsd:string\">" + this.getIliasUser() + "</username>\n");
                wout.write("<password xsi:type=\"xsd:string\">" + this.getIliasPassword() + "</password>\n");
                wout.write("</urn:login>\n");
                wout.write("</SOAP-ENV:Body>\n");
                wout.write("</SOAP-ENV:Envelope>");
                ((Writer)wout).flush();
                ((Writer)wout).close();
                StringBuilder bfr = new StringBuilder();
                InputStream in = connection.getInputStream();
                while ((c = in.read()) != -1) {
                    bfr.append((char)c);
                }
                in.close();
                Pattern ptr = Pattern.compile("<sid xsi:type=\"xsd:string\">(.*?)::(.*?)</sid>", 32);
                Matcher m = ptr.matcher(bfr.toString());
                if (!m.find()) {
                    Logger.getLogger("default").severe("[" + this.getIliasClient() + "] Could not find session, unable to login to ILIAS using user " + this.getIliasUser());
                    throw new RuntimeException("Could not login");
                }
                this.setIliasSession(m.group(1));
                Logger.getLogger("default").finer("[" + this.getIliasClient() + "] Logged in to ILIAS using user " + this.getIliasUser() + ", Session: " + this.getIliasSession());
                this.lastLoggedIn = System.currentTimeMillis();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (connection == null) break block7;
                Logger.getLogger("default").log(Level.SEVERE, "[" + this.getIliasClient() + "] Unable to login to ILIAS using user " + this.getIliasUser(), e);
                InputStream in = connection.getErrorStream();
                try {
                    int b;
                    while ((b = in.read()) >= 0) {
                        System.out.print((char)b);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger("default").log(Level.SEVERE, null, ex);
                }
                throw new RuntimeException("Could not login");
            }
        }
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChatScopeList getScopeList() {
        return this.scopeList;
    }

    public String getIliasSession() {
        return this.iliasSession;
    }

    public void setIliasSession(String ilias_session) {
        this.iliasSession = ilias_session;
    }

    public String getIliasClient() {
        return this.iliasClient;
    }

    public void setIliasClient(String ilias_client) {
        this.iliasClient = ilias_client;
    }

    public String getIliasUser() {
        return this.iliasUser;
    }

    public void setIliasUser(String iliasUser) {
        this.iliasUser = iliasUser;
    }

    public String getIliasPassword() {
        return this.iliasPassword;
    }

    public void setIliasPassword(String iliasPassword) {
        this.iliasPassword = iliasPassword;
    }
}

