/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.BufferMessage;
import chatserver.Message;

class MessageBuffer {
    private int maxSize = 100;
    private int listEnd = 0;
    private Message[] buffer = new Message[this.maxSize];

    MessageBuffer() {
    }

    public void enqueue(Message message) {
        this.buffer[this.listEnd] = message;
        this.listEnd = (this.listEnd + 1) % this.maxSize;
    }

    public BufferMessage dequeue(int position) {
        if (position == -1) {
            position = this.listEnd;
        }
        if (this.hasEntries(position) && this.buffer[position % this.maxSize] != null) {
            Message m = this.buffer[position % this.maxSize];
            position = (position + 1) % this.maxSize;
            return new BufferMessage(m, position);
        }
        return null;
    }

    public boolean hasEntries(int position) {
        return position != this.listEnd;
    }

    public int getListEndPosition() {
        return this.listEnd;
    }
}

