/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.HttpUserHandler;
import chatserver.RemoteInstance;
import chatserver.RemoteInstances;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private RemoteInstances instances = new RemoteInstances();

    public Main(Properties serverProperties, Vector<Properties> instanceProperties) throws FileNotFoundException, IOException {
        for (Properties instanceProps : instanceProperties.toArray(new Properties[0])) {
            RemoteInstance instance = RemoteInstance.fromProperties(instanceProps);
            this.instances.registerRemoteInstance(instance);
            Logger.getLogger("default").log(Level.INFO, "Loaded instance file {0}", instanceProps.getProperty("origin"));
        }
        this.initializeServer();
        HttpUserHandler handler = new HttpUserHandler(this.instances);
        InetSocketAddress address = new InetSocketAddress(serverProperties.getProperty("host"), Integer.parseInt(serverProperties.getProperty("port")));
        handler.start(address, serverProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initializeServer() throws MalformedURLException, IOException {
        for (RemoteInstance instance : this.instances) {
            instance.login();
            String query = "task=serverStarted";
            URLConnection connection = instance.getFeedbackConnection("");
            Logger.getLogger("default").log(Level.INFO, "[{0}] Calling {1} for disconnected users", new Object[]{instance.getIliasClient(), connection.getURL()});
            Logger.getLogger("default").log(Level.INFO, "[{0}] Body {1}", new Object[]{instance.getIliasClient(), query});
            connection.setDoOutput(true);
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            OutputStream output = null;
            try {
                output = connection.getOutputStream();
                output.write(query.getBytes("utf-8"));
            }
            catch (Exception e) {
                Logger.getLogger("default").log(Level.SEVERE, null, e);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger("default").log(Level.SEVERE, null, e);
                    }
                }
            }
            InputStream in = null;
            try {
                int letter;
                in = connection.getInputStream();
                while (-1 != (letter = in.read())) {
                }
            }
            catch (Exception e) {
                Logger.getLogger("default").log(Level.SEVERE, null, e);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    Logger.getLogger("default").log(Level.SEVERE, null, e);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Logger logger = Logger.getLogger("default");
        logger.setUseParentHandlers(false);
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(Level.ALL);
        logger.addHandler(ch);
        if (args.length < 2) {
            logger.log(Level.WARNING, Main.getUsage());
            System.exit(1);
        }
        Properties props = new Properties();
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(args[0]));
            props.load(bis);
            bis.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to load server properties file", e);
            System.exit(1);
        }
        if (props.getProperty("log_path") != null) {
            try {
                FileHandler fh = new FileHandler(props.getProperty("log_path"));
                fh.setFormatter(new SimpleFormatter());
                fh.setLevel(Level.ALL);
                logger.addHandler(fh);
                logger.info("Successfully attached filte logger: " + props.getProperty("log_path"));
            }
            catch (IOException e) {
                logger.info("Could not attach file logger: " + e.getMessage());
            }
            catch (SecurityException e) {
                logger.info("Could not attach file logger: " + e.getMessage());
            }
        } else {
            logger.log(Level.INFO, "Hint: You can enable file logging by adding the property \"log_path\" to {0}", args[0]);
        }
        if (props.getProperty("log_level") != null) {
            try {
                logger.setLevel(Level.parse(props.getProperty("log_level")));
                logger.info("Set global log level: " + logger.getLevel());
            }
            catch (IllegalArgumentException e) {
                logger.info("Passed log level not supported, fallback to default");
            }
        } else {
            logger.log(Level.INFO, "Hint: You can set the log level by adding the property \"log_level\" to {0}", args[0]);
        }
        logger.info("Server starting");
        Vector<Properties> oProperties = new Vector<Properties>();
        try {
            for (int i = 1; i < args.length; ++i) {
                Properties oProp = new Properties();
                oProp.load(new BufferedInputStream(new FileInputStream(new File(args[i]))));
                oProp.put("origin", args[i]);
                oProperties.add(oProp);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to load client properties file", e);
            System.exit(1);
        }
        if (oProperties.size() <= 0) {
            logger.log(Level.SEVERE, "No client configurations given");
            System.exit(1);
        }
        new Main(props, oProperties);
    }

    private static String getUsage() {
        return "== Usage ==\n\nSingle ILIAS client:\n\tjava -jar Chatserver.jar \"path/to/server.properties\" \"path/to/client.properties\"\n\nMultiple ILIAS clients:\n\tjava -jar Chatserver.jar \"path/to/server.properties\" \"path/to/first/client.properties\" \"path/to/second/client.properties\" ....";
    }
}

