/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.ActionHandler;
import chatserver.ActionHandlerException;
import chatserver.ChatHandler;
import chatserver.HttpChatCallInformation;
import chatserver.HttpJsonHandler;
import chatserver.HttpSessionGC;
import chatserver.RemoteInstances;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUserHandler
implements ChatHandler {
    protected HttpServer server;
    protected RemoteInstances instances;

    public HttpUserHandler(RemoteInstances instances) {
        this.instances = instances;
    }

    private Map<String, Object> handleCall(HttpChatCallInformation info) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ActionHandlerException {
        ActionHandler handler = (ActionHandler)Class.forName("chatserver.handler." + info.getAction() + "ActionHandler").newInstance();
        return handler.handle(info);
    }

    public void start(InetSocketAddress address, Properties props) throws IOException {
        boolean useSSL = props.get("https").equals("1");
        final String[] allowedBackendHosts = ((String)props.get("privileged_hosts")).split(",");
        if (!useSSL) {
            this.server = HttpServer.create(address, 0);
        } else {
            try {
                final SSLContext sslContext = SSLContext.getInstance("TLSv1");
                char[] keypass = ((String)props.get("keypass")).toCharArray();
                char[] storepass = ((String)props.get("storepass")).toCharArray();
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(new FileInputStream((String)props.get("keystore")), storepass);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, keypass);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ks);
                HttpsServer sslserver = HttpsServer.create(address, 0);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                sslserver.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                    public void configure(HttpsParameters params) {
                        try {
                            SSLParameters sslparams = sslContext.getDefaultSSLParameters();
                            sslparams.setProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
                            params.setSSLParameters(sslparams);
                        }
                        catch (Exception ex) {
                            Logger.getLogger("default").severe("Failed to create HTTPS port... exit");
                            System.exit(1);
                        }
                    }
                });
                this.server = sslserver;
            }
            catch (KeyManagementException ex) {
                Logger.getLogger(HttpUserHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnrecoverableKeyException ex) {
                Logger.getLogger(HttpUserHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(HttpUserHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (CertificateException ex) {
                Logger.getLogger(HttpUserHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (KeyStoreException ex) {
                Logger.getLogger(HttpUserHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.server.createContext("/backend", new HttpJsonHandler(this.instances){

            @Override
            public Map<String, Object> handleRequest(HttpExchange he, HttpChatCallInformation info) throws Exception {
                String remote = he.getRemoteAddress().getAddress().getHostAddress();
                Logger.getLogger("default").finer("Backend connection from " + remote + ": " + he.getRequestURI().toString());
                for (String allowedHost : allowedBackendHosts) {
                    if (!allowedHost.equals(remote)) continue;
                    Logger.getLogger("default").finer("Accepted connection from " + remote + ": " + he.getRequestURI().toString());
                    return HttpUserHandler.this.handleCall(info);
                }
                Logger.getLogger("default").warning("Refused connection from " + remote + " (not in the list of allowed hosts): " + he.getRequestURI().toString());
                throw new Exception(remote + " is not in the list of allowed hosts");
            }
        });
        this.server.createContext("/frontend", new HttpJsonHandler(this.instances){

            @Override
            public Map<String, Object> handleRequest(HttpExchange he, HttpChatCallInformation info) throws Exception {
                Logger.getLogger("default").finest("Frontend connection from " + he.getRemoteAddress().getAddress().getHostAddress().toString() + ": " + he.getRequestURI().toString());
                if (!info.getAction().equals("Poll") && !info.getAction().equals("Status")) {
                    Logger.getLogger("default").warning("Access from " + he.getRemoteAddress().getAddress().getHostAddress().toString() + " denied to handler: " + info.getAction());
                    throw new Exception(info.getAction() + " is not accessible by frontend call. Use /backend instead.");
                }
                return HttpUserHandler.this.handleCall(info);
            }
        });
        this.server.setExecutor(Executors.newFixedThreadPool(10));
        this.server.start();
        HttpSessionGC gcHandler = new HttpSessionGC(this.instances);
        gcHandler.startGC();
    }
}

