/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.ChatScope;
import chatserver.DisconnectTupple;
import chatserver.RemoteInstance;
import chatserver.RemoteInstances;
import chatserver.Subscriber;
import chatserver.SubscriberList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpSessionGC {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final RemoteInstances instances;
    private ScheduledFuture<?> gcHandle;
    private long sessionTimeout = 10000L;

    public HttpSessionGC(RemoteInstances instances) {
        this.instances = instances;
    }

    public void startGC() {
        Runnable gc = new Runnable(){

            @Override
            public void run() {
                HashMap<RemoteInstance, List<DisconnectTupple>> usersToDisconnect = new HashMap<RemoteInstance, List<DisconnectTupple>>();
                for (RemoteInstance instance : HttpSessionGC.this.instances) {
                    LinkedList<DisconnectTupple> disconnectsByInstance = new LinkedList<DisconnectTupple>();
                    for (ChatScope scope : instance.getScopeList()) {
                        Iterator<Subscriber> subscribers = scope.getSubscibers().iterator();
                        DisconnectTupple disconnectInfo = new DisconnectTupple(scope, new SubscriberList());
                        while (subscribers.hasNext()) {
                            Subscriber subscriber = subscribers.next();
                            if (System.currentTimeMillis() - subscriber.getLastConnect() <= HttpSessionGC.this.sessionTimeout) continue;
                            Logger.getLogger("default").log(Level.INFO, "[{0}] Will remove subscriber {1,number} from scope {2,number}, Last connect: {3}, Current datetime: {4}", new Object[]{instance.getIliasClient(), subscriber.getId(), scope.getId(), HttpSessionGC.this.sdf.format(new Date(subscriber.getLastConnect())), HttpSessionGC.this.sdf.format(new Date(System.currentTimeMillis()))});
                            subscribers.remove();
                            Logger.getLogger("default").log(Level.INFO, "[{0}] Removed subscriber {1,number} from subscriber list in scope {2,number}", new Object[]{instance.getIliasClient(), subscriber.getId(), scope.getId()});
                            disconnectInfo.getSubscriberList().add(subscriber);
                        }
                        if (disconnectInfo.getSubscriberList().size() <= 0) continue;
                        disconnectsByInstance.add(disconnectInfo);
                    }
                    if (disconnectsByInstance.size() <= 0) continue;
                    usersToDisconnect.put(instance, disconnectsByInstance);
                }
                try {
                    this.sendFeedback(usersToDisconnect);
                }
                catch (IOException e) {
                    Logger.getLogger("default").log(Level.SEVERE, null, e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void sendFeedback(Map<RemoteInstance, List<DisconnectTupple>> data) throws IOException {
                for (RemoteInstance instance : data.keySet()) {
                    String query = "";
                    for (DisconnectTupple tupple : data.get(instance)) {
                        if (!query.equals("")) {
                            query = query + "&";
                        }
                        String subs_to_disconnect = "";
                        for (Subscriber subscriber : tupple.getSubscriberList()) {
                            if (!subs_to_disconnect.equals("")) {
                                subs_to_disconnect = subs_to_disconnect + ",";
                            }
                            subs_to_disconnect = subs_to_disconnect + subscriber.getId();
                        }
                        if (subs_to_disconnect.equals("")) continue;
                        query = query + "scope[" + tupple.getScope().getId() + "]=" + subs_to_disconnect;
                    }
                    if (query.equals("")) continue;
                    query = "task=disconnectedUsers&" + query;
                    URLConnection connection = instance.getFeedbackConnection("");
                    Logger.getLogger("default").log(Level.INFO, "[{0}] Calling {1} for disconnected users", new Object[]{instance.getIliasClient(), connection.getURL()});
                    Logger.getLogger("default").log(Level.INFO, "[{0}] Body {1}", new Object[]{instance.getIliasClient(), query});
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Accept-Charset", "utf-8");
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
                    OutputStream output = null;
                    InputStream in = null;
                    try {
                        output = connection.getOutputStream();
                        output.write(query.getBytes("utf-8"));
                        in = connection.getInputStream();
                    }
                    catch (IOException e) {
                        Logger.getLogger("default").log(Level.SEVERE, null, e);
                    }
                    finally {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException e) {
                                Logger.getLogger("default").log(Level.SEVERE, null, e);
                            }
                        }
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger("default").log(Level.SEVERE, null, e);
                        }
                    }
                }
            }
        };
        this.gcHandle = this.scheduler.scheduleAtFixedRate(gc, 10L, 10L, TimeUnit.SECONDS);
    }

    public void stopGC() {
        this.gcHandle.cancel(true);
    }
}

