/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.ChatScope;
import chatserver.ChatScopeList;
import chatserver.HttpChatCallInformation;
import chatserver.InvalidCallException;
import chatserver.Parameters;
import chatserver.RemoteInstance;
import chatserver.RemoteInstances;
import com.google.gson.Gson;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpJsonHandler
implements HttpHandler {
    private RemoteInstances instances;

    public HttpJsonHandler(RemoteInstances instances) {
        this.instances = instances;
    }

    @Override
    public void handle(HttpExchange he) throws IOException {
        try {
            Map<String, Object> result;
            HttpChatCallInformation info = this.parseBackendUrl(this.instances, he.getRequestURI());
            try {
                result = this.handleRequest(he, info);
            }
            catch (Exception e) {
                result = this.getExceptionResult(e);
            }
            Gson json = new Gson();
            String resultString = json.toJson(result);
            if (info.getParams().containsKey("callback")) {
                resultString = (String)info.getParams().get("callback") + "(" + resultString + ")";
            }
            he.getResponseHeaders().add("connection", "close");
            he.getResponseHeaders().add("content-type", "text/javascript");
            he.sendResponseHeaders(200, resultString.getBytes().length);
            try {
                he.getResponseBody().write(resultString.getBytes());
            }
            catch (IOException e) {}
        }
        catch (IOException e) {
            String resultString = "uncaught exception of type " + e.getClass().getName();
            he.getResponseHeaders().add("connection", "close");
            he.sendResponseHeaders(500, resultString.getBytes().length);
            he.getResponseBody().write(resultString.getBytes());
        }
        he.getResponseBody().close();
    }

    private Parameters queryToMap(String query) {
        if (query == null || query.length() == 0) {
            return new Parameters();
        }
        Pattern p = Pattern.compile("[^&=]+=[^&]*");
        Matcher m = p.matcher(query);
        Parameters result = new Parameters();
        try {
            while (m.find()) {
                String part = query.substring(m.start(), m.end());
                String[] parts = part.split("=", 2);
                if (parts.length > 1) {
                    result.put(URLDecoder.decode(parts[0], "utf-8"), URLDecoder.decode(parts[1], "utf-8"));
                    continue;
                }
                result.put(URLDecoder.decode(parts[0], "utf-8"), "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private HttpChatCallInformation parseBackendUrl(RemoteInstances instances, URI uri) {
        String url = uri.getPath();
        String query = uri.getRawQuery();
        Parameters params = this.queryToMap(query);
        String[] parts = url.split("/", 5);
        String hash = parts[3];
        if (instances.getRemoteInstanceByHash(hash) != null) {
            ChatScope scope;
            RemoteInstance instance = instances.getRemoteInstanceByHash(hash);
            ChatScopeList scopeList = instance.getScopeList();
            if (scopeList.getScopeById(Integer.parseInt(parts[4])) != null) {
                scope = scopeList.getScopeById(Integer.parseInt(parts[4]));
            } else {
                scope = new ChatScope();
                scope.setId(Integer.parseInt(parts[4]));
                scopeList.add(scope);
            }
            return new HttpChatCallInformation(instance, scope, parts[2], params);
        }
        throw new InvalidCallException();
    }

    public Map<String, Object> getExceptionResult(Exception e) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", true);
        result.put("error-type", e.getClass().getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(baos));
        result.put("error-trace", new String(baos.toByteArray()));
        return result;
    }

    public abstract Map<String, Object> handleRequest(HttpExchange var1, HttpChatCallInformation var2) throws Exception;
}

