/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.ChatScope;
import chatserver.Message;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatScopeList
implements Iterable<ChatScope> {
    private List<ChatScope> scopes = new LinkedList<ChatScope>();
    private Map<Integer, ChatScope> scopesById = new HashMap<Integer, ChatScope>();

    public void add(ChatScope scope) {
        this.scopes.add(scope);
        this.scopesById.put(scope.getId(), scope);
    }

    public ChatScope getScopeById(int id) {
        return this.scopesById.get(id);
    }

    public void remove(ChatScope scope) {
        this.scopes.remove(scope);
        this.scopesById.remove(scope.getId());
    }

    @Override
    public Iterator<ChatScope> iterator() {
        return this.scopes.iterator();
    }

    public void notify(Message message) {
        for (ChatScope scope : this.scopes) {
            scope.getSubscibers().notify(message);
        }
    }
}

