/*
 * Decompiled with CFR 0.152.
 */
package chatserver;

import chatserver.Subscriber;
import chatserver.SubscriberList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChatScope {
    private int id = 0;
    private SubscriberList subscribers = new SubscriberList();
    private Map<Integer, ChatScope> subScopes = new HashMap<Integer, ChatScope>();
    private Map<Subscriber, Set<ChatScope>> subScopesBySubscriber = new HashMap<Subscriber, Set<ChatScope>>();
    private Map<ChatScope, SubscriberList> subscribersBySubScopes = new HashMap<ChatScope, SubscriberList>();

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void attatchSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void detatchSubscriber(Subscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    public SubscriberList getSubscibers() {
        return this.subscribers;
    }

    public ChatScope createSubScope(int scopeId) {
        if (this.subScopes.containsKey(scopeId)) {
            return this.subScopes.get(scopeId);
        }
        ChatScope sub = new ChatScope();
        sub.setId(scopeId);
        this.subScopes.put(scopeId, sub);
        this.subscribersBySubScopes.put(sub, new SubscriberList());
        return sub;
    }

    public void attachSubscriberToSubScope(Integer scopeId, Subscriber subscriber) {
        if (this.isSubscriberSubscribedToSubScope(subscriber, scopeId)) {
            return;
        }
        this.subScopes.get(scopeId).attatchSubscriber(subscriber);
        if (!this.subScopesBySubscriber.containsKey(subscriber)) {
            this.subScopesBySubscriber.put(subscriber, new HashSet());
        }
        this.subScopesBySubscriber.get(subscriber).add(this.subScopes.get(scopeId));
        this.subscribersBySubScopes.get(this.subScopes.get(scopeId)).add(subscriber);
    }

    public void detachSubscriberToSubScope(Integer scopeId, Subscriber subscriber) {
        this.subScopes.get(scopeId).detatchSubscriber(subscriber);
        if (this.subScopesBySubscriber.containsKey(subscriber)) {
            this.subScopesBySubscriber.remove(subscriber);
        }
        this.subscribersBySubScopes.get(this.subScopes.get(scopeId)).remove(subscriber);
    }

    public boolean isSubscriberSubscribedToSubScope(Subscriber subscriber, int scopeId) {
        return this.subScopes.containsKey(scopeId) && this.subScopesBySubscriber.containsKey(subscriber) && this.subScopesBySubscriber.get(subscriber).contains(this.subScopes.get(scopeId));
    }

    public SubscriberList getSubScopeSubscribers(int scopeId) {
        return this.subscribersBySubScopes.get(this.subScopes.get(scopeId));
    }

    public boolean subScopeExists(int scopeId) {
        return this.subScopes.containsKey(scopeId);
    }
}

