/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.pfplms.scorm.cmi.components;

import gnu.regexp.RE;
import java.util.Hashtable;

public class FormatChecker {
    private static Hashtable regexp = new Hashtable();
    private static RE RE_Feedback = null;
    private static Hashtable regexpFeedback = new Hashtable();
    private static RE RE_CMIBlank;
    private static RE RE_CMIBoolean;
    private static RE RE_CMIDecimal;
    private static RE RE_CMIIdentifier;
    private static RE RE_CMIInteger;
    private static RE RE_CMISInteger;
    private static RE RE_CMIString255;
    private static RE RE_CMIString4096;
    private static RE RE_CMITime;
    private static RE RE_CMITimespan;
    private static RE RE_choice;
    private static RE RE_fill_in;
    private static RE RE_likert;
    private static RE RE_matching;
    private static RE RE_numeric;
    private static RE RE_performance;
    private static RE RE_sequencing;
    private static RE RE_true_false;
    private static RE RE_Credit;
    private static RE RE_Entry;
    private static RE RE_Exit;
    private static RE RE_Interaction;
    private static RE RE_Mode;
    private static RE RE_Result;
    private static RE RE_Status;
    private static RE RE_TimeLimitAction;

    public FormatChecker() {
        try {
            RE_CMIBlank = new RE((Object)"", 32);
            RE_CMIBoolean = new RE((Object)"^(true|false)$", 32);
            RE_CMIDecimal = new RE((Object)"^[-+]??(\\d+)??(\\.)??(\\d)+$", 32);
            RE_CMIIdentifier = new RE((Object)"^\\S{1,255}$", 32);
            RE_CMIInteger = new RE((Object)"^\\d{1,5}$", 32);
            RE_CMISInteger = new RE((Object)"^[-+]??\\d{1,5}$", 32);
            RE_CMIString255 = new RE((Object)"^[\\S\\s]{0,255}$", 32);
            RE_CMIString4096 = new RE((Object)"^[\\S\\s]{0,4096}$", 32);
            RE_CMITime = new RE((Object)"^(0[0-9]|1[0-9]|2[1-3]):[0-5]\\d:[0-5]\\d(\\.((\\d)|(\\d\\d)))*$", 32);
            RE_CMITimespan = new RE((Object)"^(\\d){2,4}:(\\d\\d)\\:(\\d\\d)((\\.)((\\d)|(\\d\\d)))*$", 32);
            RE_choice = new RE((Object)"^([a-z\\d])?((,)([a-z\\d]))*$|^{([a-z\\d])??((,)([a-z\\d]))*}$", 32);
            RE_fill_in = new RE((Object)"^[\\S\\s]{0,255}$", 32);
            RE_likert = new RE((Object)"^[a-z0-9]?$", 32);
            RE_matching = new RE((Object)"^([a-z\\d]\\.[a-z\\d])??(,([a-z\\d]\\.[a-z\\d]))*$|^{([a-z\\d]\\.[a-z\\d])??(,([a-z\\d]\\.[a-z\\d]))*}$", 32);
            RE_numeric = new RE((Object)"^[-+]??(\\d+)??(\\.)??(\\d)+$", 32);
            RE_performance = new RE((Object)"^[\\S\\s]{0,255}$", 32);
            RE_sequencing = new RE((Object)"^([a-z\\d])??(,[a-z\\d])*$", 32);
            RE_true_false = new RE((Object)"^(t|f|0|1)$", 32);
            RE_Credit = new RE((Object)"^(credit|no-credit)$", 32);
            RE_Entry = new RE((Object)"^(ab-initio|resume)??$", 32);
            RE_Exit = new RE((Object)"^(time-out|suspend|logout)??$", 32);
            RE_Interaction = new RE((Object)"^(true-false|choice|fill-in|matching|performance|likert|sequencing|numeric)$", 32);
            RE_Mode = new RE((Object)"^(normal|review|browse)$", 32);
            RE_Result = new RE((Object)"^(correct|wrong|unanticipated|neutral|([+-]?\\d+)\\.?\\d*)$", 32);
            RE_Status = new RE((Object)"^(passed|completed|failed|incomplete|browsed|not attempted)$", 32);
            RE_TimeLimitAction = new RE((Object)"^(exit,message|exit,no message|continue,message|continue,no message)$", 32);
        }
        catch (Exception exception) {}
        regexpFeedback.put("choice", RE_choice);
        regexpFeedback.put("fill-in", RE_fill_in);
        regexpFeedback.put("likert", RE_likert);
        regexpFeedback.put("matching", RE_matching);
        regexpFeedback.put("numeric", RE_numeric);
        regexpFeedback.put("performance", RE_performance);
        regexpFeedback.put("sequencing", RE_sequencing);
        regexpFeedback.put("true-false", RE_true_false);
        regexp.put("cmi.core.student_id", RE_CMIIdentifier);
        regexp.put("cmi.core.student_name", RE_CMIString255);
        regexp.put("cmi.core.lesson_location", RE_CMIString255);
        regexp.put("cmi.core.credit", RE_Credit);
        regexp.put("cmi.core.lesson_status", RE_Status);
        regexp.put("cmi.core.entry", RE_Entry);
        regexp.put("cmi.core.score.raw", RE_CMIDecimal);
        regexp.put("cmi.core.score.max", RE_CMIDecimal);
        regexp.put("cmi.core.score.min", RE_CMIDecimal);
        regexp.put("cmi.core.total_time", RE_CMITimespan);
        regexp.put("cmi.core.lesson_mode", RE_Mode);
        regexp.put("cmi.core.exit", RE_Exit);
        regexp.put("cmi.core.session_time", RE_CMITimespan);
        regexp.put("cmi.suspend_data", RE_CMIString4096);
        regexp.put("cmi.launch_data", RE_CMIString4096);
        regexp.put("cmi.comments", RE_CMIString4096);
        regexp.put("cmi.comments_from_lms", RE_CMIString4096);
        regexp.put("cmi.objectives.n.id", RE_CMIIdentifier);
        regexp.put("cmi.objectives.n.score.raw", RE_CMIDecimal);
        regexp.put("cmi.objectives.n.score.max", RE_CMIDecimal);
        regexp.put("cmi.objectives.n.score.min", RE_CMIDecimal);
        regexp.put("cmi.objectives.n.status", RE_Status);
        regexp.put("cmi.student_data.mastery_score", RE_CMIDecimal);
        regexp.put("cmi.student_data.max_time_allowed", RE_CMITimespan);
        regexp.put("cmi.student_data.time_limit_action", RE_TimeLimitAction);
        regexp.put("cmi.student_preference.audio", RE_CMISInteger);
        regexp.put("cmi.student_preference.language", RE_CMIString255);
        regexp.put("cmi.student_preference.speed", RE_CMISInteger);
        regexp.put("cmi.student_preference.text", RE_CMISInteger);
        regexp.put("cmi.interactions.n.id", RE_CMIIdentifier);
        regexp.put("cmi.interactions.n.objectives.n.id", RE_CMIIdentifier);
        regexp.put("cmi.interactions.n.time", RE_CMITime);
        regexp.put("cmi.interactions.n.type", RE_Interaction);
        regexp.put("cmi.interactions.n.weighting", RE_CMIDecimal);
        regexp.put("cmi.interactions.n.result", RE_Result);
        regexp.put("cmi.interactions.n.latency", RE_CMITimespan);
    }

    public void setFeedbackType(String string) {
        Object v;
        RE_Feedback = null;
        if (!string.equals("") && (v = regexpFeedback.get(string)) != null) {
            RE_Feedback = (RE)v;
        }
    }

    public boolean check(String string, String string2) {
        RE rE = string.equals("cmi.interactions.n.correct_responses.n.pattern") || string.equals("cmi.interactions.n.student_response") ? RE_Feedback : (RE)regexp.get(string);
        if (rE == null) {
            return false;
        }
        return rE.getMatch((Object)string2) != null;
    }
}

