/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.pfplms.scorm.cmi;

import ch.ethz.pfplms.scorm.cmi.cmiTime;
import ch.ethz.pfplms.scorm.cmi.components.AccessChecker;
import ch.ethz.pfplms.scorm.cmi.components.CMI;
import ch.ethz.pfplms.scorm.cmi.components.FormatChecker;
import ch.ethz.pfplms.scorm.cmi.components.RangeChecker;
import ch.ethz.pfplms.scorm.cmi.components.SyntaxChecker;
import java.util.Enumeration;
import java.util.Hashtable;

public class Manager {
    public static final int ENONE = 0;
    public static final int ESYNTAX = 201;
    public static final int ENOCHLD = 202;
    public static final int ENOCNT = 203;
    public static final int EISKEY = 402;
    public static final int ERDONLY = 403;
    public static final int EWRONLY = 404;
    public static final int ETYPE = 405;
    private static int error;
    private static Hashtable cntd;
    private static Hashtable cmi;
    private static Hashtable trans;
    private static Hashtable trNew;
    private static Hashtable trMod;
    private static SyntaxChecker sc;
    private static AccessChecker ac;
    private static FormatChecker fc;
    private static RangeChecker rc;

    public Manager() {
        CMI.init(cmi);
    }

    public final Hashtable getCmiHash() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = cmi.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (string.indexOf(".n.") != -1 || !string.startsWith("cmi.")) continue;
            hashtable.put(string, cmi.get(string));
        }
        return hashtable;
    }

    public final int getErrorCode() {
        return error;
    }

    public final void put(String string, String string2) {
        error = 0;
        if (!sc.check(string)) {
            error = 201;
            return;
        }
        String string3 = sc.getElement();
        boolean bl = ac.isWriteable(string);
        boolean bl2 = ac.isReadable(string);
        if (!bl2 && !bl) {
            error = 201;
            return;
        }
        if (string.endsWith("._children")) {
            int n = error = bl2 ? 402 : 202;
        }
        if (string.endsWith("._count")) {
            int n = error = bl2 ? 402 : 203;
        }
        if (error != 0) {
            return;
        }
        if (!bl) {
            error = 403;
            return;
        }
        error = AccessChecker.getError();
        if (error != 0) {
            return;
        }
        if (sc.numCounters() > 0) {
            this.checkSequence();
        }
        if (error != 0) {
            return;
        }
        Object v = cmi.get(sc.getFeedbackType());
        fc.setFeedbackType(v == null ? "" : v.toString());
        if (!fc.check(sc.getElement(), string2)) {
            error = 405;
            return;
        }
        if (!rc.check(string3, string2)) {
            error = 405;
            return;
        }
        if (string.equals("cmi.core.session_time")) {
            string2 = new cmiTime(cmi.get("cmi.core.total_time").toString()).getTotal(string2);
            string = "cmi.core.total_time";
            cmi.put(string, string2);
            error = 0;
            return;
        }
        if (sc.numCounters() > 0) {
            this.handleLists(string, string2);
            return;
        }
        if (string.equals("cmi.core.lesson_status") && string2.equals("not attempted")) {
            error = 405;
            return;
        }
        if (string.equals("cmi.comments") && (v = cmi.get("cmi.comments")) != null && (string2 = String.valueOf(v.toString()) + string2).length() > 4096) {
            error = 201;
            return;
        }
        cmi.put(string, string2);
        error = 0;
    }

    private final void handleLists(String string, String string2) {
        int n = 0;
        while (n < sc.numCounters()) {
            String string3 = sc.getCounter(n);
            String string4 = sc.getArray(n);
            Object v = cmi.get(string3);
            int n2 = v == null ? 0 : Integer.parseInt(v.toString());
            int n3 = Integer.parseInt(sc.getIndex(n));
            if (!cntd.containsKey(string4)) {
                v = cmi.get(string3);
                int n4 = v == null ? 0 : Integer.parseInt(v.toString());
                cntd.put(string4, "1");
                cmi.put(string3, Integer.toString(++n4));
            }
            if (n3 > n2) {
                error = 201;
                return;
            }
            ++n;
        }
        cmi.put(string, string2);
        error = 0;
    }

    private final void checkSequence() {
        int n = 0;
        while (n < sc.numCounters()) {
            String string = sc.getCounter(n);
            Object v = cmi.get(string);
            int n2 = v == null ? 0 : Integer.parseInt(v.toString());
            int n3 = Integer.parseInt(sc.getIndex(n));
            if (n3 > n2) {
                error = 201;
                return;
            }
            ++n;
        }
    }

    public final void sysput(String string, String string2) {
        sc.check(string);
        if (!sc.getCounter().equals(string) && sc.numCounters() > 0) {
            cntd.put(sc.getArray(sc.numCounters() - 1), "1");
        }
        cmi.put(string, string2);
    }

    public final void sysput(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = (String)hashtable.get(string);
            this.sysput(string, string2);
        }
    }

    public final String sysget(String string) {
        sc.check(string);
        Object v = cmi.get(string);
        if (string.equals(sc.getCounter()) && v == null) {
            return "0";
        }
        if (v == null) {
            return "";
        }
        return v.toString();
    }

    public final String get(String string) {
        error = 0;
        if (!sc.check(string)) {
            error = 201;
            return "";
        }
        String string2 = sc.getElement();
        boolean bl = ac.isReadable(string);
        error = AccessChecker.getError();
        if (!bl) {
            if (string.endsWith("._children")) {
                error = 202;
            }
            if (string.endsWith("._count")) {
                error = 203;
            }
        }
        if (error != 0) {
            return "";
        }
        boolean bl2 = ac.isWriteable(string);
        if (bl2 && !bl) {
            error = 404;
            return "";
        }
        if (!bl && !bl2) {
            error = !string.equals(string2) ? 203 : 201;
            return "";
        }
        Object v = cmi.get(string);
        if (string.equals(sc.getCounter())) {
            if (v == null) {
                return "0";
            }
            return v.toString();
        }
        Object v2 = cmi.get(string2);
        if (v2 != null) {
            return v2.toString();
        }
        if (v == null) {
            return "";
        }
        return v.toString();
    }

    public final void reset() {
        cmi.clear();
        CMI.init(cmi);
        cntd.clear();
        error = 0;
    }

    public final void transBegin() {
        Hashtable hashtable = cmi;
        synchronized (hashtable) {
            trans.clear();
            trNew.clear();
            trMod.clear();
            Enumeration enumeration = cmi.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                trans.put(k, cmi.get(k));
            }
            return;
        }
    }

    public final void transEnd() {
        Hashtable hashtable = cmi;
        synchronized (hashtable) {
            Enumeration enumeration = cmi.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = cmi.get(k);
                Object v2 = trans.get(k);
                if (v2 == null) {
                    trNew.put(k, v);
                    continue;
                }
                if (v.toString().equals(v2.toString())) continue;
                trMod.put(k, v);
            }
            return;
        }
    }

    public final Hashtable getTransNew() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = trNew.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable.put(k, cmi.get(k));
        }
        return hashtable;
    }

    public final Hashtable getTransMod() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = trMod.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable.put(k, cmi.get(k));
        }
        return hashtable;
    }

    static {
        cntd = new Hashtable();
        cmi = new Hashtable();
        trans = new Hashtable();
        trNew = new Hashtable();
        trMod = new Hashtable();
        sc = new SyntaxChecker();
        ac = new AccessChecker();
        fc = new FormatChecker();
        rc = new RangeChecker();
    }
}

