/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.pfplms.scorm.api;

import ch.ethz.pfplms.scorm.api.ApiAdapterInterface;
import ch.ethz.pfplms.scorm.api.components.ErrorHandler;
import ch.ethz.pfplms.scorm.api.components.StateManager;
import ch.ethz.pfplms.scorm.cmi.Manager;
import java.util.Hashtable;

public class ApiAdapter
implements ApiAdapterInterface {
    protected Manager cm = new Manager();
    protected ErrorHandler eh = new ErrorHandler();
    protected StateManager sm = new StateManager();

    public final Hashtable getCmiHash() {
        return this.cm.getCmiHash();
    }

    public final String isError() {
        if (this.eh.isError()) {
            return "false";
        }
        return "true";
    }

    public void reset() {
        this.sm.reset();
        this.eh.reset();
        this.cm.reset();
    }

    public String LMSInitialize(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            this.eh.setDiagnostic("LMSInitialize with bad argument");
            this.eh.setErrorCode(201);
            if (this.eh.isError()) {
                return "false";
            }
            return "true";
        }
        if (StateManager.isInitialized()) {
            this.eh.setDiagnostic("LMSInitialize called in initialized state");
            this.eh.setErrorCode(101);
            if (this.eh.isError()) {
                return "false";
            }
            return "true";
        }
        this.sm.reset();
        if (StateManager.processEvent(0)) {
            this.eh.reset();
            if (this.eh.isError()) {
                return "false";
            }
            return "true";
        }
        return "false";
    }

    public String LMSSetValue(String string, String string2) {
        if (string == null) {
            this.eh.setErrorCode(101);
            this.eh.setDiagnostic("lvalue is null");
            if (this.eh.isError()) {
                return "false";
            }
            return "true";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (StateManager.processEvent(1)) {
            this.cm.put(string, string2);
            this.eh.setErrorCode(this.cm.getErrorCode());
        } else {
            this.eh.setErrorCode(StateManager.getErrorCode());
        }
        if (this.eh.isError()) {
            return "false";
        }
        return "true";
    }

    public String LMSGetValue(String string) {
        if (string == null) {
            this.eh.setErrorCode(101);
            if (this.eh.isError()) {
                return "false";
            }
            return "true";
        }
        String string2 = "";
        if (StateManager.processEvent(2)) {
            string2 = this.cm.get(string);
            this.eh.setErrorCode(this.cm.getErrorCode());
        } else {
            this.eh.setErrorCode(StateManager.getErrorCode());
        }
        return string2;
    }

    public String LMSFinish(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            this.eh.setDiagnostic("LMSFinish with bad argument");
            this.eh.setErrorCode(201);
            if (this.eh.isError()) {
                return "false";
            }
            return "true";
        }
        if (StateManager.processEvent(7)) {
            this.eh.reset();
        } else {
            this.eh.setDiagnostic("ERROR " + this.eh.getErrorCode() + " " + this.eh.getErrorString());
        }
        if (this.eh.isError()) {
            return "false";
        }
        return "true";
    }

    public String LMSCommit(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            this.eh.setDiagnostic("LMSCommit with bad argument");
            this.eh.setErrorCode(201);
            if (this.eh.isError()) {
                return "false";
            }
            return "true";
        }
        StateManager.processEvent(6);
        this.eh.setErrorCode(StateManager.getErrorCode());
        if (this.eh.isError()) {
            return "false";
        }
        return "true";
    }

    public String LMSGetLastError() {
        StateManager.processEvent(3);
        return this.eh.getErrorCode();
    }

    public String LMSGetErrorString(String string) {
        StateManager.processEvent(4);
        return this.eh.getErrorString(string);
    }

    public String LMSGetDiagnostic(String string) {
        if (string == null) {
            return this.eh.getErrorString("0");
        }
        StateManager.processEvent(5);
        return this.eh.getErrorString(string);
    }

    public String sysGet(String string) {
        return this.cm.sysget(string);
    }

    public void sysPut(String string, String string2) {
        this.cm.sysput(string, string2);
    }

    public void sysPut(Hashtable hashtable) {
        this.cm.sysput(hashtable);
    }

    public final void transBegin() {
        this.cm.transBegin();
    }

    public final void transEnd() {
        this.cm.transEnd();
    }

    public final Hashtable getTransNew() {
        return this.cm.getTransNew();
    }

    public final Hashtable getTransMod() {
        return this.cm.getTransMod();
    }
}

