/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.excelant.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.excelant.util.ExcelAntEvaluationResult;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import org.apache.poi.ss.formula.udf.DefaultUDFFinder;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.ErrorConstants;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Typedef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelAntWorkbookUtil
extends Typedef {
    private String excelFileName;
    private Workbook workbook;
    private HashMap<String, FreeRefFunction> xlsMacroList;

    protected ExcelAntWorkbookUtil(String fName) {
        this.excelFileName = fName;
        this.xlsMacroList = new HashMap();
        this.loadWorkbook();
    }

    protected ExcelAntWorkbookUtil(Workbook wb) {
        this.workbook = wb;
        this.xlsMacroList = new HashMap();
    }

    private Workbook loadWorkbook() {
        File workbookFile = new File(this.excelFileName);
        try {
            FileInputStream fis = new FileInputStream(workbookFile);
            this.workbook = WorkbookFactory.create(fis);
        }
        catch (Exception e) {
            throw new BuildException("Cannot load file " + this.excelFileName + ". Make sure the path and file permissions are correct.", (Throwable)e);
        }
        return this.workbook;
    }

    public void addFunction(String name, String clazzName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazzInst = Class.forName(clazzName);
        Object newInst = clazzInst.newInstance();
        if (newInst instanceof FreeRefFunction) {
            this.addFunction(name, (FreeRefFunction)newInst);
        }
    }

    protected void addFunction(String name, FreeRefFunction func) {
        this.xlsMacroList.put(name, func);
    }

    protected UDFFinder getFunctions() {
        String[] names = new String[this.xlsMacroList.size()];
        FreeRefFunction[] functions = new FreeRefFunction[this.xlsMacroList.size()];
        Iterator<String> keysIt = this.xlsMacroList.keySet().iterator();
        int x = 0;
        while (keysIt.hasNext()) {
            String name = keysIt.next();
            FreeRefFunction function = this.xlsMacroList.get(name);
            names[x] = name;
            functions[x] = function;
        }
        DefaultUDFFinder udff1 = new DefaultUDFFinder(names, functions);
        AggregatingUDFFinder udff = new AggregatingUDFFinder(udff1);
        return udff;
    }

    protected FormulaEvaluator getEvaluator(String excelFileName) {
        FormulaEvaluator evaluator;
        if (excelFileName.endsWith(".xlsx")) {
            if (this.xlsMacroList != null && this.xlsMacroList.size() > 0) {
                XSSFFormulaEvaluator xSSFFormulaEvaluator = XSSFFormulaEvaluator.create((XSSFWorkbook)this.workbook, null, this.getFunctions());
            }
            evaluator = new XSSFFormulaEvaluator((XSSFWorkbook)this.workbook);
        } else {
            if (this.xlsMacroList != null && this.xlsMacroList.size() > 0) {
                evaluator = HSSFFormulaEvaluator.create((HSSFWorkbook)this.workbook, null, this.getFunctions());
            }
            evaluator = new HSSFFormulaEvaluator((HSSFWorkbook)this.workbook);
        }
        return evaluator;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public String getFileName() {
        return this.excelFileName;
    }

    public ArrayList<String> getSheets() {
        ArrayList<String> sheets = new ArrayList<String>();
        int sheetCount = this.workbook.getNumberOfSheets();
        for (int x = 0; x < sheetCount; ++x) {
            sheets.add(this.workbook.getSheetName(x));
        }
        return sheets;
    }

    public void setDoubleValue(String cellName, double value) {
        this.log("starting setCellValue()", 4);
        Cell cell = this.getCell(cellName);
        this.log("working on cell: " + cell, 4);
        cell.setCellValue(value);
        this.log("after cell.setCellValue()", 4);
        this.log("set cell " + cellName + " to value " + value, 4);
    }

    public void setStringValue(String cellName, String value) {
        Cell cell = this.getCell(cellName);
        cell.setCellValue(value);
    }

    public void setFormulaValue(String cellName, String formula) {
        Cell cell = this.getCell(cellName);
        cell.setCellFormula(formula);
    }

    public void setDateValue(String cellName, Date date) {
        Cell cell = this.getCell(cellName);
        cell.setCellValue(date);
    }

    public ExcelAntEvaluationResult evaluateCell(String cellName, double expectedValue, double precision) {
        ExcelAntEvaluationResult evalResults = null;
        Cell cell = this.getCell(cellName);
        FormulaEvaluator evaluator = this.getEvaluator(this.excelFileName);
        CellValue resultOfEval = evaluator.evaluate(cell);
        if (resultOfEval.getErrorValue() == 0) {
            double result = resultOfEval.getNumberValue();
            double delta = Math.abs(result - expectedValue);
            evalResults = delta > precision ? new ExcelAntEvaluationResult(false, false, resultOfEval.getNumberValue(), "Results was out of range based on precision  of " + precision + ".  Delta was actually " + delta, delta, cellName) : new ExcelAntEvaluationResult(false, true, resultOfEval.getNumberValue(), "Evaluation passed without error within in range.", delta, cellName);
        } else {
            String errorMeaning = null;
            try {
                errorMeaning = ErrorConstants.getText(resultOfEval.getErrorValue());
            }
            catch (IllegalArgumentException iae) {
                errorMeaning = "unknown error code: " + Byte.toString(resultOfEval.getErrorValue());
            }
            evalResults = new ExcelAntEvaluationResult(false, false, resultOfEval.getNumberValue(), "Evaluation failed due to an evaluation error of " + resultOfEval.getErrorValue() + " which is " + errorMeaning, 0.0, cellName);
        }
        return evalResults;
    }

    public String getCellAsString(String cellName) {
        Cell cell = this.getCell(cellName);
        if (cell != null) {
            return cell.getStringCellValue();
        }
        return "";
    }

    public double getCellAsDouble(String cellName) {
        Cell cell = this.getCell(cellName);
        if (cell != null) {
            return cell.getNumericCellValue();
        }
        return 0.0;
    }

    private Cell getCell(String cellName) {
        Cell cell;
        CellReference cellRef = new CellReference(cellName);
        String sheetName = cellRef.getSheetName();
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new BuildException("Sheet not found: " + sheetName);
        }
        int rowIdx = cellRef.getRow();
        short colIdx = cellRef.getCol();
        Row row = sheet.getRow(rowIdx);
        if (row == null) {
            row = sheet.createRow(rowIdx);
        }
        if ((cell = row.getCell(colIdx)) == null) {
            cell = row.createCell(colIdx);
        }
        return cell;
    }
}

