/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.PositionSpan;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class WeightedSpanTermExtractor {
    private String fieldName;
    private CachingTokenFilter cachedTokenFilter;
    private Map readers = new HashMap(10);
    private String defaultField;
    private boolean highlightCnstScrRngQuery;

    public WeightedSpanTermExtractor() {
    }

    public WeightedSpanTermExtractor(String defaultField) {
        if (defaultField != null) {
            this.defaultField = defaultField.intern();
        }
    }

    private void closeReaders() {
        Collection readerSet = this.readers.values();
        Iterator it = readerSet.iterator();
        while (it.hasNext()) {
            IndexReader reader = (IndexReader)it.next();
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(Query query, Map terms) throws IOException {
        if (query instanceof BooleanQuery) {
            BooleanClause[] queryClauses = ((BooleanQuery)query).getClauses();
            PositionCheckingMap booleanTerms = new PositionCheckingMap();
            for (int i = 0; i < queryClauses.length; ++i) {
                if (queryClauses[i].isProhibited()) continue;
                this.extract(queryClauses[i].getQuery(), booleanTerms);
            }
            terms.putAll(booleanTerms);
        } else if (query instanceof PhraseQuery) {
            Term[] phraseQueryTerms = ((PhraseQuery)query).getTerms();
            SpanQuery[] clauses = new SpanQuery[phraseQueryTerms.length];
            for (int i = 0; i < phraseQueryTerms.length; ++i) {
                clauses[i] = new SpanTermQuery(phraseQueryTerms[i]);
            }
            int slop = ((PhraseQuery)query).getSlop();
            boolean inorder = false;
            if (slop == 0) {
                inorder = true;
            }
            SpanNearQuery sp = new SpanNearQuery(clauses, slop, inorder);
            sp.setBoost(query.getBoost());
            this.extractWeightedSpanTerms(terms, sp);
        } else if (query instanceof TermQuery) {
            this.extractWeightedTerms(terms, query);
        } else if (query instanceof SpanQuery) {
            this.extractWeightedSpanTerms(terms, (SpanQuery)query);
        } else if (query instanceof FilteredQuery) {
            this.extract(((FilteredQuery)query).getQuery(), terms);
        } else if (query instanceof DisjunctionMaxQuery) {
            PositionCheckingMap disjunctTerms = new PositionCheckingMap();
            Iterator iterator = ((DisjunctionMaxQuery)query).iterator();
            while (iterator.hasNext()) {
                this.extract((Query)iterator.next(), disjunctTerms);
            }
            terms.putAll(disjunctTerms);
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            List termArrays = mpq.getTermArrays();
            int[] positions = mpq.getPositions();
            if (positions.length > 0) {
                int maxPosition = positions[positions.length - 1];
                for (int i = 0; i < positions.length - 1; ++i) {
                    if (positions[i] <= maxPosition) continue;
                    maxPosition = positions[i];
                }
                List[] disjunctLists = new List[maxPosition + 1];
                int distinctPositions = 0;
                for (int i = 0; i < termArrays.size(); ++i) {
                    Term[] termArray = (Term[])termArrays.get(i);
                    ArrayList<SpanTermQuery> disjuncts = disjunctLists[positions[i]];
                    if (disjuncts == null) {
                        ArrayList<SpanTermQuery> arrayList = new ArrayList<SpanTermQuery>(termArray.length);
                        disjunctLists[positions[i]] = arrayList;
                        disjuncts = arrayList;
                        ++distinctPositions;
                    }
                    for (int j = 0; j < termArray.length; ++j) {
                        disjuncts.add(new SpanTermQuery(termArray[j]));
                    }
                }
                int positionGaps = 0;
                int position = 0;
                SpanQuery[] clauses = new SpanQuery[distinctPositions];
                for (int i = 0; i < disjunctLists.length; ++i) {
                    List disjuncts = disjunctLists[i];
                    if (disjuncts != null) {
                        clauses[position++] = new SpanOrQuery(disjuncts.toArray(new SpanQuery[disjuncts.size()]));
                        continue;
                    }
                    ++positionGaps;
                }
                int slop = mpq.getSlop();
                boolean inorder = slop == 0;
                SpanNearQuery sp = new SpanNearQuery(clauses, slop + positionGaps, inorder);
                sp.setBoost(query.getBoost());
                this.extractWeightedSpanTerms(terms, sp);
            }
        } else if (this.highlightCnstScrRngQuery && query instanceof ConstantScoreRangeQuery) {
            ConstantScoreRangeQuery q = (ConstantScoreRangeQuery)query;
            Term lower = new Term(this.fieldName, q.getLowerVal());
            Term upper = new Term(this.fieldName, q.getUpperVal());
            FilterIndexReader fir = new FilterIndexReader(this.getReaderForField(this.fieldName));
            try {
                Term term;
                TermEnum te = fir.terms(lower);
                BooleanQuery bq = new BooleanQuery();
                while ((term = te.term()) != null && upper.compareTo(term) >= 0) {
                    bq.add(new BooleanClause(new TermQuery(term), BooleanClause.Occur.SHOULD));
                    if (te.next()) continue;
                }
                this.extract(bq, terms);
            }
            finally {
                fir.close();
            }
        }
    }

    private void extractWeightedSpanTerms(Map terms, SpanQuery spanQuery) throws IOException {
        HashSet<String> fieldNames;
        HashSet nonWeightedTerms = new HashSet();
        spanQuery.extractTerms(nonWeightedTerms);
        if (this.fieldName == null) {
            fieldNames = new HashSet<String>();
            Iterator iter = nonWeightedTerms.iterator();
            while (iter.hasNext()) {
                Term queryTerm = (Term)iter.next();
                fieldNames.add(queryTerm.field());
            }
        } else {
            fieldNames = new HashSet(1);
            fieldNames.add(this.fieldName);
        }
        if (this.defaultField != null) {
            fieldNames.add(this.defaultField);
        }
        Iterator it = fieldNames.iterator();
        ArrayList<PositionSpan> spanPositions = new ArrayList<PositionSpan>();
        while (it.hasNext()) {
            String field = (String)it.next();
            IndexReader reader = this.getReaderForField(field);
            Spans spans = spanQuery.getSpans(reader);
            while (spans.next()) {
                spanPositions.add(new PositionSpan(spans.start(), spans.end() - 1));
            }
            this.cachedTokenFilter.reset();
        }
        if (spanPositions.size() == 0) {
            return;
        }
        Iterator iter = nonWeightedTerms.iterator();
        while (iter.hasNext()) {
            Term queryTerm = (Term)iter.next();
            if (!this.fieldNameComparator(queryTerm.field())) continue;
            WeightedSpanTerm weightedSpanTerm = (WeightedSpanTerm)terms.get(queryTerm.text());
            if (weightedSpanTerm == null) {
                weightedSpanTerm = new WeightedSpanTerm(spanQuery.getBoost(), queryTerm.text());
                weightedSpanTerm.addPositionSpans(spanPositions);
                weightedSpanTerm.positionSensitive = true;
                terms.put(queryTerm.text(), weightedSpanTerm);
                continue;
            }
            if (spanPositions.size() <= 0) continue;
            weightedSpanTerm.addPositionSpans(spanPositions);
        }
    }

    private void extractWeightedTerms(Map terms, Query query) throws IOException {
        HashSet nonWeightedTerms = new HashSet();
        query.extractTerms(nonWeightedTerms);
        Iterator iter = nonWeightedTerms.iterator();
        while (iter.hasNext()) {
            Term queryTerm = (Term)iter.next();
            if (!this.fieldNameComparator(queryTerm.field())) continue;
            WeightedSpanTerm weightedSpanTerm = new WeightedSpanTerm(query.getBoost(), queryTerm.text());
            terms.put(queryTerm.text(), weightedSpanTerm);
        }
    }

    private boolean fieldNameComparator(String fieldNameToCheck) {
        boolean rv = this.fieldName == null || fieldNameToCheck == this.fieldName || fieldNameToCheck == this.defaultField;
        return rv;
    }

    private IndexReader getReaderForField(String field) {
        IndexReader reader = (IndexReader)this.readers.get(field);
        if (reader == null) {
            MemoryIndex indexer = new MemoryIndex();
            indexer.addField(field, this.cachedTokenFilter);
            IndexSearcher searcher = indexer.createSearcher();
            reader = searcher.getIndexReader();
            this.readers.put(field, reader);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getWeightedSpanTerms(Query query, CachingTokenFilter cachingTokenFilter) throws IOException {
        this.fieldName = null;
        this.cachedTokenFilter = cachingTokenFilter;
        PositionCheckingMap terms = new PositionCheckingMap();
        try {
            this.extract(query, terms);
        }
        finally {
            this.closeReaders();
        }
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getWeightedSpanTerms(Query query, CachingTokenFilter cachingTokenFilter, String fieldName) throws IOException {
        if (fieldName != null) {
            this.fieldName = fieldName.intern();
        }
        PositionCheckingMap terms = new PositionCheckingMap();
        this.cachedTokenFilter = cachingTokenFilter;
        try {
            this.extract(query, terms);
        }
        finally {
            this.closeReaders();
        }
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getWeightedSpanTermsWithScores(Query query, TokenStream tokenStream, String fieldName, IndexReader reader) throws IOException {
        this.fieldName = fieldName;
        this.cachedTokenFilter = new CachingTokenFilter(tokenStream);
        PositionCheckingMap terms = new PositionCheckingMap();
        this.extract(query, terms);
        int totalNumDocs = reader.numDocs();
        Set weightedTerms = terms.keySet();
        Iterator it = weightedTerms.iterator();
        try {
            while (it.hasNext()) {
                WeightedSpanTerm weightedSpanTerm = (WeightedSpanTerm)terms.get(it.next());
                int docFreq = reader.docFreq(new Term(fieldName, weightedSpanTerm.term));
                if (totalNumDocs < docFreq) {
                    docFreq = totalNumDocs;
                }
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                weightedSpanTerm.weight *= idf;
            }
        }
        finally {
            this.closeReaders();
        }
        return terms;
    }

    public boolean isHighlightCnstScrRngQuery() {
        return this.highlightCnstScrRngQuery;
    }

    public void setHighlightCnstScrRngQuery(boolean highlightCnstScrRngQuery) {
        this.highlightCnstScrRngQuery = highlightCnstScrRngQuery;
    }

    private class PositionCheckingMap
    extends HashMap {
        private PositionCheckingMap() {
        }

        public void putAll(Map m) {
            Iterator it = m.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object val = m.get(key);
                this.put(key, val);
            }
        }

        public Object put(Object key, Object value) {
            Object prev = super.put(key, value);
            if (prev == null) {
                return prev;
            }
            WeightedSpanTerm prevTerm = (WeightedSpanTerm)prev;
            WeightedSpanTerm newTerm = (WeightedSpanTerm)value;
            if (!prevTerm.positionSensitive) {
                newTerm.positionSensitive = false;
            }
            return prev;
        }
    }
}

