/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.highlight.WeightedSpanTermExtractor;

public class SpanScorer
implements Scorer {
    private float totalScore;
    private Set foundTerms;
    private Map fieldWeightedSpanTerms;
    private float maxTermWeight;
    private int position = -1;
    private String defaultField;
    private static boolean highlightCnstScrRngQuery;

    public SpanScorer(Query query, String field, CachingTokenFilter cachingTokenFilter) throws IOException {
        this.init(query, field, cachingTokenFilter, null);
    }

    public SpanScorer(Query query, String field, CachingTokenFilter cachingTokenFilter, IndexReader reader) throws IOException {
        this.init(query, field, cachingTokenFilter, reader);
    }

    public SpanScorer(Query query, String field, CachingTokenFilter cachingTokenFilter, IndexReader reader, String defaultField) throws IOException {
        this.defaultField = defaultField.intern();
        this.init(query, field, cachingTokenFilter, reader);
    }

    public SpanScorer(Query query, String field, CachingTokenFilter cachingTokenFilter, String defaultField) throws IOException {
        this.defaultField = defaultField.intern();
        this.init(query, field, cachingTokenFilter, null);
    }

    public SpanScorer(WeightedSpanTerm[] weightedTerms) {
        this.fieldWeightedSpanTerms = new HashMap(weightedTerms.length);
        for (int i = 0; i < weightedTerms.length; ++i) {
            WeightedSpanTerm existingTerm = (WeightedSpanTerm)this.fieldWeightedSpanTerms.get(weightedTerms[i].term);
            if (existingTerm != null && !(existingTerm.weight < weightedTerms[i].weight)) continue;
            this.fieldWeightedSpanTerms.put(weightedTerms[i].term, weightedTerms[i]);
            this.maxTermWeight = Math.max(this.maxTermWeight, weightedTerms[i].getWeight());
        }
    }

    public float getFragmentScore() {
        return this.totalScore;
    }

    public float getMaxTermWeight() {
        return this.maxTermWeight;
    }

    public float getTokenScore(Token token) {
        this.position += token.getPositionIncrement();
        String termText = token.term();
        WeightedSpanTerm weightedSpanTerm = (WeightedSpanTerm)this.fieldWeightedSpanTerms.get(termText);
        if (weightedSpanTerm == null) {
            return 0.0f;
        }
        if (weightedSpanTerm.positionSensitive && !weightedSpanTerm.checkPosition(this.position)) {
            return 0.0f;
        }
        float score = weightedSpanTerm.getWeight();
        if (!this.foundTerms.contains(termText)) {
            this.totalScore += score;
            this.foundTerms.add(termText);
        }
        return score;
    }

    public WeightedSpanTerm getWeightedSpanTerm(String token) {
        return (WeightedSpanTerm)this.fieldWeightedSpanTerms.get(token);
    }

    private void init(Query query, String field, CachingTokenFilter cachingTokenFilter, IndexReader reader) throws IOException {
        WeightedSpanTermExtractor qse = this.defaultField == null ? new WeightedSpanTermExtractor() : new WeightedSpanTermExtractor(this.defaultField);
        qse.setHighlightCnstScrRngQuery(highlightCnstScrRngQuery);
        this.fieldWeightedSpanTerms = reader == null ? qse.getWeightedSpanTerms(query, cachingTokenFilter, field) : qse.getWeightedSpanTermsWithScores(query, cachingTokenFilter, field, reader);
    }

    public static boolean isHighlightCnstScrRngQuery() {
        return highlightCnstScrRngQuery;
    }

    public void reset() {
        this.position = -1;
    }

    public static void setHighlightCnstScrRngQuery(boolean highlight) {
        highlightCnstScrRngQuery = highlight;
    }

    public void startFragment(TextFragment newFragment) {
        this.foundTerms = new HashSet();
        this.totalScore = 0.0f;
    }
}

