/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.settings;

import de.ilias.services.settings.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class ServerSettings {
    private static Logger logger = Logger.getLogger(ServerSettings.class);
    private static ServerSettings instance = null;
    public static final long DEFAULT_MAX_FILE_SIZE = 524288000L;
    private InetAddress host;
    private String hostString;
    private int port;
    private String tnsAdmin = "";
    private File indexPath;
    private File logFile;
    private Level logLevel;
    private int numThreads = 1;
    private double RAMSize = 500.0;
    private int indexMaxFileSizeMB = 500;

    private ServerSettings() {
    }

    public static synchronized ServerSettings getInstance() throws ConfigurationException {
        if (instance == null) {
            instance = new ServerSettings();
        }
        return instance;
    }

    public String lookupTnsAdmin() {
        if (this.getTnsAdmin().length() > 0) {
            return this.getTnsAdmin();
        }
        try {
            if (System.getenv("TNS_ADMIN").length() > 0) {
                return System.getenv("TNS_ADMIN");
            }
        }
        catch (SecurityException e) {
            logger.error("Cannot access environment variable TNS_ADMIN due to security manager limitations: " + e);
            throw e;
        }
        return "";
    }

    public String getServerUrl() {
        StringBuilder builder = new StringBuilder();
        builder.append("http://");
        builder.append(this.getHostString());
        builder.append(":" + this.getPort());
        builder.append("/xmlrpc");
        logger.info("Using RPC Url: " + builder);
        return builder.toString();
    }

    public InetAddress getHost() {
        return this.host;
    }

    public String getHostString() {
        return this.hostString;
    }

    public void setHost(String host) throws ConfigurationException {
        try {
            this.host = InetAddress.getByName(host);
            this.hostString = host;
        }
        catch (UnknownHostException e) {
            logger.fatal("Unknown host given: " + host);
            throw new ConfigurationException(e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = Integer.parseInt(port);
    }

    public File getIndexPath() {
        return this.indexPath;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) throws ConfigurationException, IOException {
        this.logFile = new File(logFile);
        if (!this.logFile.isAbsolute()) {
            logger.error("Absolute path to logfile required: " + logFile);
            throw new ConfigurationException("Absolute path to logfile required: " + logFile);
        }
        if (this.logFile.isDirectory()) {
            logger.error("Absolute path to logfile required. Directory name given: " + logFile);
            throw new ConfigurationException("Absolute path to logfile required: " + logFile);
        }
        if (this.logFile.createNewFile()) {
            // empty if block
        }
        if (!this.logFile.canWrite()) {
            throw new ConfigurationException("Cannot write to log file: " + logFile);
        }
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = Level.toLevel(logLevel.trim(), Level.INFO);
    }

    public String getTnsAdmin() {
        return this.tnsAdmin;
    }

    public void setTnsAdmin(String tnsAdmin) {
        this.tnsAdmin = tnsAdmin;
    }

    public void setIndexPath(String indexPath) throws ConfigurationException {
        this.indexPath = new File(indexPath);
        if (!this.indexPath.isAbsolute()) {
            throw new ConfigurationException("Absolute path required: " + indexPath);
        }
        if (!this.indexPath.canWrite()) {
            throw new ConfigurationException("Path not writable: " + indexPath);
        }
        if (!this.indexPath.isDirectory()) {
            throw new ConfigurationException("Directory name required: " + indexPath);
        }
    }

    public void initLogger() throws ConfigurationException {
        Logger logger = Logger.getRootLogger();
        logger.setLevel(Level.INFO);
        try {
            RollingFileAppender file_appender = new RollingFileAppender((Layout)new PatternLayout("%d{ISO8601} %-5p %t (%F:%L) - %m%n"), this.logFile.getAbsolutePath());
            file_appender.setMaxFileSize("100MB");
            logger.removeAllAppenders();
            logger.addAppender(file_appender);
            logger.setLevel(this.getLogLevel());
            logger.info("Started loggin to: " + this.getLogFile().getAbsolutePath());
            logger.info("Using log level " + this.getLogLevel());
        }
        catch (IOException e) {
            logger.fatal("Error appending log file.");
            throw new ConfigurationException(e);
        }
    }

    public void setThreadNumber(String purgeString) {
        this.numThreads = Integer.valueOf(purgeString);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public double getRAMSize() {
        return this.RAMSize;
    }

    public void setRAMSize(String purgedString) {
        this.RAMSize = Double.valueOf(purgedString);
    }

    public int getMaxFileSizeMB() {
        return this.indexMaxFileSizeMB;
    }

    public long getMaxFileSize() {
        return (long)this.indexMaxFileSizeMB * 1024L * 1024L;
    }

    public void setMaxFileSizeMB(String mb) {
        this.indexMaxFileSizeMB = Integer.valueOf(mb);
    }
}

