/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.settings;

import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.ServerSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.ini4j.Profile;

public class IniFileParser {
    Logger logger = Logger.getLogger(IniFileParser.class);

    public void parseServerSettings(String path, boolean parseClientSettings) throws ConfigurationException {
        ServerSettings serverSettings = ServerSettings.getInstance();
        try {
            Ini prefs = new Ini(new FileReader(path));
            for (Profile.Section section : prefs.values()) {
                if (section.getName().equals("Server")) {
                    if (section.containsKey("IpAddress")) {
                        serverSettings.setHost(this.purgeString((String)section.get("IpAddress")));
                    }
                    if (section.containsKey("Port")) {
                        serverSettings.setPort(this.purgeString((String)section.get("Port")));
                    }
                    if (section.containsKey("IndexPath")) {
                        serverSettings.setIndexPath(this.purgeString((String)section.get("IndexPath")));
                    }
                    if (section.containsKey("LogLevel")) {
                        serverSettings.setLogFile(this.purgeString((String)section.get("LogFile")));
                    }
                    if (section.containsKey("LogLevel")) {
                        serverSettings.setLogLevel(this.purgeString((String)section.get("LogLevel")));
                    }
                    serverSettings.initLogger();
                    if (section.containsKey("NumThreads")) {
                        serverSettings.setThreadNumber(this.purgeString((String)section.get("NumThreads")));
                    }
                    if (section.containsKey("RAMBufferSize")) {
                        serverSettings.setRAMSize(this.purgeString((String)section.get("RAMBufferSize")));
                    }
                    if (section.containsKey("IndexMaxFileSizeMB")) {
                        serverSettings.setMaxFileSizeMB(this.purgeString((String)section.get("IndexMaxFileSizeMB")));
                    }
                }
                if (!section.getName().startsWith("Client") || !parseClientSettings) continue;
                if (section.containsKey("ClientId")) {
                    String client = this.purgeString((String)section.get("ClientId"));
                    String nic = section.containsKey("NicId") ? this.purgeString((String)section.get("NicId")) : "0";
                    ClientSettings clientSettings = ClientSettings.getInstance(client, nic);
                    if (!section.containsKey("IliasIniPath")) continue;
                    clientSettings.setIliasIniFile(this.purgeString((String)section.get("IliasIniPath")));
                    this.parseClientData(clientSettings);
                    continue;
                }
                this.logger.error("No ClientId given for section: " + section.getName());
                throw new ConfigurationException("No ClientId given for section: " + section.getName());
            }
        }
        catch (ConfigurationException e) {
            this.logger.error("Cannot parse server settings: " + e.getMessage());
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            this.logger.error("Cannot parse server settings: " + e.getMessage());
            throw new ConfigurationException(e);
        }
    }

    public void parseClientData(ClientSettings clientSettings) throws ConfigurationException {
        try {
            IniPreferences prefs = new IniPreferences(this.convertIniFile(clientSettings.getIliasIniFile()));
            clientSettings.setDataDirectory(this.purgeString(((Preferences)prefs).node("clients").get("datadir", ""), true));
            clientSettings.setAbsolutePath(this.purgeString(((Preferences)prefs).node("server").get("absolute_path", ""), true));
            String dataName = this.purgeString(((Preferences)prefs).node("clients").get("path", ""), true);
            String iniFileName = this.purgeString(((Preferences)prefs).node("clients").get("inifile", ""), true);
            clientSettings.setClientIniFile(clientSettings.getAbsolutePath().getCanonicalPath() + System.getProperty("file.separator") + dataName + System.getProperty("file.separator") + clientSettings.getClient() + System.getProperty("file.separator") + iniFileName);
            clientSettings.setIndexPath(ServerSettings.getInstance().getIndexPath() + System.getProperty("file.separator") + clientSettings.getClientKey());
            prefs = new IniPreferences(this.convertIniFile(clientSettings.getClientIniFile()));
            clientSettings.setDbType(this.purgeString(((Preferences)prefs).node("db").get("type", ""), true));
            clientSettings.setDbHost(this.purgeString(((Preferences)prefs).node("db").get("host", ""), true));
            clientSettings.setDbPort(this.purgeString(((Preferences)prefs).node("db").get("port", ""), true));
            clientSettings.setDbUser(this.purgeString(((Preferences)prefs).node("db").get("user", ""), true));
            clientSettings.setDbPass(this.purgeString(((Preferences)prefs).node("db").get("pass", ""), true));
            clientSettings.setDbName(this.purgeString(((Preferences)prefs).node("db").get("name", ""), true));
            this.logger.debug("Client ID: " + clientSettings.getClient());
            this.logger.debug("DB Type: " + clientSettings.getDbType());
            this.logger.debug("DB Host: " + clientSettings.getDbHost());
            this.logger.debug("DB Port: " + clientSettings.getDbPort());
            this.logger.debug("DB Name: " + clientSettings.getDbName());
            this.logger.debug("DB User: " + clientSettings.getDbUser());
            this.logger.debug("DB Pass: " + clientSettings.getDbPass());
        }
        catch (IOException e) {
            this.logger.error("Caught IOException when trying to parse client data: " + e.getMessage());
            throw new ConfigurationException(e);
        }
        catch (ConfigurationException e) {
            this.logger.error("Caught ConfigurationException when trying to parse client data.");
            throw e;
        }
    }

    public String purgeString(String dirty, boolean replaceQuotes) {
        if (replaceQuotes) {
            return dirty.replace('\"', ' ').trim();
        }
        return dirty.trim();
    }

    public String purgeString(String dirty) {
        return this.purgeString(dirty, false);
    }

    private StringReader convertIniFile(File iniFile) throws ConfigurationException {
        try {
            int c;
            InputStreamReader reader = new InputStreamReader(new FileInputStream(iniFile));
            StringBuilder builder = new StringBuilder();
            while ((c = reader.read()) != -1) {
                builder.append((char)c);
            }
            String output = builder.toString();
            output = output.replaceFirst("<\\?php /\\*", "");
            output = output.replaceFirst("\\*/ \\?>", "");
            return new StringReader(output);
        }
        catch (FileNotFoundException e) {
            this.logger.fatal("Cannot find ini file: " + e.getMessage());
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            this.logger.error("Caught IOException when trying to convert ini file: " + e.getMessage());
            throw new ConfigurationException(e);
        }
    }
}

