/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.settings;

import de.ilias.services.settings.ConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientSettings {
    protected static Logger logger = Logger.getLogger(ClientSettings.class);
    private static HashMap<String, ClientSettings> instances = new HashMap();
    private String client;
    private String nic;
    private File iliasIniFile;
    private File dataDirectory;
    private File clientIniFile;
    private File absolutePath;
    private File indexPath;
    private String dbType;
    private String dbHost;
    private String dbPort;
    private String dbName;
    private String dbUser;
    private String dbPass;

    public ClientSettings(String client, String nic) {
        this.client = client;
        this.nic = nic;
    }

    public static synchronized ClientSettings getInstance(String client, String nic) throws ConfigurationException {
        return ClientSettings.getInstance(client + '_' + nic);
    }

    public static synchronized ClientSettings getInstance(String clientKey) throws ConfigurationException {
        logger.debug("Using client key " + clientKey);
        if (instances.containsKey(clientKey)) {
            return instances.get(clientKey);
        }
        int posUnderscore = clientKey.lastIndexOf("_");
        if (posUnderscore == -1) {
            logger.error("Cannot parse client key: " + clientKey);
            throw new ConfigurationException("Cannot parse client key: " + clientKey);
        }
        String nic = clientKey.substring(posUnderscore + 1);
        String client = clientKey.substring(0, posUnderscore);
        logger.debug("Orig: " + clientKey + " Client: " + client + " NIC: " + nic);
        instances.put(clientKey, new ClientSettings(client, nic));
        return instances.get(clientKey);
    }

    public static boolean exists(String clientKey) {
        return instances.containsKey(clientKey);
    }

    public static ArrayList<String> getClients() {
        ArrayList<String> clients = new ArrayList<String>();
        for (Map.Entry<String, ClientSettings> entry : instances.entrySet()) {
            clients.add(entry.getKey());
        }
        return clients;
    }

    public String getClient() {
        return this.client;
    }

    public String getClientKey() {
        return this.client + '_' + this.getNic();
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getNic() {
        return this.nic;
    }

    public void setNic(String nic) {
        this.nic = nic;
    }

    public File getIliasIniFile() {
        return this.iliasIniFile;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) throws ConfigurationException {
        logger.debug("ILIAS data directory: " + dataDirectory);
        this.dataDirectory = new File(dataDirectory);
        if (!this.dataDirectory.canRead()) {
            logger.error("Cannot read ILIAS data directory: " + this.dataDirectory.getAbsolutePath());
            throw new ConfigurationException("Error reading ILIAS data directory.");
        }
    }

    public File getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) throws ConfigurationException {
        logger.debug("ILIAS absolute path: " + absolutePath);
        this.absolutePath = new File(absolutePath);
        if (!this.absolutePath.canRead()) {
            logger.error("Cannot read ILIAS absolute path: " + this.absolutePath.getAbsolutePath());
            throw new ConfigurationException("Error reading ILIAS absolute path.");
        }
    }

    public File getClientIniFile() {
        return this.clientIniFile;
    }

    public void setClientIniFile(String clientIniPath) throws ConfigurationException {
        this.clientIniFile = new File(clientIniPath);
        logger.debug("ILIAS client ini path: " + this.clientIniFile.getAbsolutePath());
        if (!this.clientIniFile.canRead()) {
            logger.error("Error reading client ini file: " + this.clientIniFile.getAbsolutePath());
            throw new ConfigurationException("Cannot read ILIAS client ini file.");
        }
    }

    public void setIliasIniFile(String iliasIniFile) throws ConfigurationException {
        this.iliasIniFile = new File(iliasIniFile);
        if (!this.iliasIniFile.isAbsolute()) {
            logger.error("Absolute path required: " + iliasIniFile);
            throw new ConfigurationException("Absolute path required: " + iliasIniFile);
        }
        if (!this.iliasIniFile.canRead()) {
            logger.error("Path not readable: " + iliasIniFile);
            throw new ConfigurationException("Path not readable: " + iliasIniFile);
        }
        if (this.iliasIniFile.isDirectory()) {
            logger.error("Directory name given: " + iliasIniFile);
            throw new ConfigurationException("Directory name given: " + iliasIniFile);
        }
    }

    public File getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = new File(indexPath);
        if (!this.indexPath.isDirectory()) {
            this.indexPath.mkdir();
        }
    }

    public String getDbUrl() {
        if (this.getDbType().equalsIgnoreCase("mysql") || this.getDbType().equalsIgnoreCase("innodb")) {
            if (this.getDbPort().length() > 0) {
                return "jdbc:mysql://" + this.getDbHost() + ":" + this.getDbPort() + "/" + this.getDbName();
            }
            return "jdbc:mysql://" + this.getDbHost() + "/" + this.getDbName();
        }
        StringBuffer url = new StringBuffer();
        url.append("jdbc:oracle:thin:" + this.getDbUser() + "/" + this.getDbPass() + "@//" + this.getDbHost());
        if (this.getDbPort().length() > 0) {
            url.append(":" + this.getDbPort());
        }
        url.append("/" + this.getDbName());
        return url.toString();
    }

    public String getDbType() {
        if (this.dbType.equalsIgnoreCase("innodb")) {
            return "mysql";
        }
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPass() {
        return this.dbPass;
    }

    public void setDbPass(String dbPass) {
        this.dbPass = dbPass;
    }

    public void setDbPort(String purgeString) {
        this.dbPort = purgeString;
    }

    public String getDbPort() {
        return this.dbPort;
    }
}

