/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.rpc;

import de.ilias.services.lucene.index.RPCIndexHandler;
import de.ilias.services.lucene.search.RPCSearchHandler;
import de.ilias.services.rpc.RPCAdministration;
import de.ilias.services.rpc.RPCDebug;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.transformation.RPCTransformationHandler;
import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;

public class RPCServer {
    private static RPCServer instance = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private WebServer server;
    private InetAddress host = null;
    private int port = 0;
    private boolean alive = false;

    private RPCServer(InetAddress host, int port) throws XmlRpcException {
        this.logger.info("New RPCServer construct.");
        this.setHost(host);
        this.setPort(port);
        this.initServer();
    }

    private RPCServer() {
    }

    public static RPCServer getInstance(InetAddress host, int port) throws XmlRpcException {
        if (instance == null) {
            instance = new RPCServer(host, port);
            return instance;
        }
        return instance;
    }

    public static RPCServer getInstance() {
        return instance;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void setHost(InetAddress host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    private void initServer() throws XmlRpcException {
        this.logger.info("Init Webserver...");
        this.server = new WebServer(this.getPort(), this.getHost());
        XmlRpcStreamServer rpcServer = this.server.getXmlRpcServer();
        rpcServer.setHandlerMapping(this.addHandlers());
        XmlRpcServerConfigImpl config = (XmlRpcServerConfigImpl)rpcServer.getConfig();
        config.setKeepAliveEnabled(true);
        config.setEncoding("UTF8");
    }

    public void start() throws ConfigurationException {
        try {
            this.logger.info("Starting ILIAS RPC-Server...");
            this.server.start();
            this.logger.debug("Using host :" + this.getHost().toString());
            this.logger.debug("Using port :" + this.getPort());
            this.logger.info("Waiting for connections...");
            this.alive = true;
        }
        catch (RuntimeException e) {
            this.logger.error("Cannot bind to host: " + this.getHost() + ", port: " + this.port + " " + e);
            throw new ConfigurationException(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error("Cannot bind to host: " + this.getHost() + ", port: " + this.port + " " + e);
            throw new ConfigurationException(e.getMessage());
        }
        catch (Throwable e) {
            this.logger.error(e);
            throw new ConfigurationException(e.getMessage());
        }
    }

    public void shutdown() {
        this.logger.debug("Stopping Webserver...");
        this.server.shutdown();
        this.alive = false;
    }

    private PropertyHandlerMapping addHandlers() throws XmlRpcException {
        PropertyHandlerMapping mapping = new PropertyHandlerMapping();
        mapping.addHandler("RPCDebug", RPCDebug.class);
        mapping.addHandler("RPCAdministration", RPCAdministration.class);
        mapping.addHandler("RPCIndexHandler", RPCIndexHandler.class);
        mapping.addHandler("RPCSearchHandler", RPCSearchHandler.class);
        mapping.addHandler("RPCTransformationHandler", RPCTransformationHandler.class);
        this.logger.info("Added RPC-Handlers");
        String[] methods = mapping.getListMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.logger.info(methods[i]);
        }
        return mapping;
    }
}

