/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.rpc;

import de.ilias.ilServerStatus;
import de.ilias.services.lucene.index.IndexHolder;
import de.ilias.services.lucene.settings.LuceneSettings;
import de.ilias.services.rpc.RPCServer;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RPCAdministration {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean stop() throws ConfigurationException {
        this.logger.info("Received stop request");
        IndexHolder.closeAllWriters();
        RPCServer server = RPCServer.getInstance();
        server.setAlive(false);
        ilServerStatus.setActive(false);
        return true;
    }

    public boolean refreshSettings(String clientKey) {
        LuceneSettings settings = null;
        LocalSettings.setClientKey(clientKey);
        try {
            this.logger.info("Reading lucene client settings from database.");
            this.logger.info("Client key: " + clientKey);
            settings = LuceneSettings.getInstance(clientKey);
            settings.refresh();
            return true;
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
            return false;
        }
    }

    public String status() {
        return ilServerStatus.getStatus();
    }

    public boolean start() {
        ilServerStatus.setActive(true);
        return true;
    }
}

