/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.object.ObjectDefinition;
import de.ilias.services.object.ObjectDefinitionException;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ObjectDefinitions {
    protected static Logger logger = Logger.getLogger(ObjectDefinitions.class);
    private static HashMap<File, ObjectDefinitions> instances = new HashMap();
    private File absolutePath;
    private Vector<ObjectDefinition> definitions = new Vector();

    public ObjectDefinitions(File absolutePath) {
        this.setAbsolutePath(absolutePath);
    }

    public static synchronized ObjectDefinitions getInstance(File absolutePath) {
        if (instances.containsKey(absolutePath)) {
            return instances.get(absolutePath);
        }
        instances.put(absolutePath, new ObjectDefinitions(absolutePath));
        return instances.get(absolutePath);
    }

    public void reset() {
        this.definitions = new Vector();
    }

    public void setAbsolutePath(File absolutePath) {
        this.absolutePath = absolutePath;
    }

    public File getAbsolutePath() {
        return this.absolutePath;
    }

    public Vector<ObjectDefinition> getDefinitions() {
        return this.definitions;
    }

    public void addDefinition(ObjectDefinition def) {
        this.definitions.add(def);
    }

    public ObjectDefinition getDefinitionByType(String objType) throws ObjectDefinitionException {
        for (int i = 0; i < this.definitions.size(); ++i) {
            if (!this.definitions.get(i).getType().equals(objType)) continue;
            return this.definitions.get(i);
        }
        throw new ObjectDefinitionException("Invalid type given. Cannot find obj type " + objType);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (ObjectDefinition defs : this.getDefinitions()) {
            out.append("Object definitions for: " + this.getAbsolutePath().getAbsolutePath());
            out.append("\n");
            out.append(defs);
        }
        return out.toString();
    }
}

