/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.lucene.index.FieldInfo;
import de.ilias.services.lucene.index.file.path.PathCreatorFactory;
import de.ilias.services.object.DataSource;
import de.ilias.services.object.DirectoryDataSource;
import de.ilias.services.object.DocumentDefinition;
import de.ilias.services.object.FieldDefinition;
import de.ilias.services.object.FileDataSource;
import de.ilias.services.object.JDBCDataSource;
import de.ilias.services.object.ObjectDefinition;
import de.ilias.services.object.ObjectDefinitionException;
import de.ilias.services.object.ObjectDefinitions;
import de.ilias.services.object.ParameterDefinition;
import de.ilias.services.object.TransformerDefinition;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ObjectDefinitionParser {
    protected Logger logger = Logger.getLogger(ObjectDefinitionParser.class);
    private Vector<File> objectPropertyFiles = new Vector();
    private ClientSettings settings = ClientSettings.getInstance(LocalSettings.getClientKey());
    private ObjectDefinitions definitions = ObjectDefinitions.getInstance(this.settings.getAbsolutePath());

    public ObjectDefinitionParser() throws ConfigurationException {
        this.definitions.reset();
        FieldInfo.getInstance(LocalSettings.getClientKey());
    }

    public ObjectDefinitionParser(Vector<File> objectPropertyFiles) throws ConfigurationException {
        this();
        this.objectPropertyFiles = objectPropertyFiles;
    }

    public boolean parse() throws ObjectDefinitionException {
        this.logger.debug("Start parsing object definitions");
        for (int i = 0; i < this.objectPropertyFiles.size(); ++i) {
            this.logger.debug("File nr. " + i);
            this.parseFile(this.objectPropertyFiles.get(i));
        }
        return true;
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void parseFile(File file) throws ObjectDefinitionException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setXIncludeAware(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(file);
            Document jdocument = this.convertToJDOM(document);
            this.definitions.addDefinition(this.parseObjectDefinition(jdocument));
            this.logger.debug("Start logging");
        }
        catch (IOException e) {
            this.logger.error("Cannot handle file: " + file.getAbsolutePath());
            throw new ObjectDefinitionException(e);
        }
        catch (ParserConfigurationException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error(writer.toString());
        }
        catch (SAXException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error(writer.toString());
        }
        catch (ClassCastException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error(writer.toString());
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.logger.error(writer.toString());
        }
    }

    private Document convertToJDOM(org.w3c.dom.Document document) {
        DOMBuilder builder = new DOMBuilder();
        return builder.build(document);
    }

    private ObjectDefinition parseObjectDefinition(Document jdocument) throws ObjectDefinitionException {
        Element root = jdocument.getRootElement();
        if (!root.getName().equals("ObjectDefinition")) {
            throw new ObjectDefinitionException("Cannot find root element 'ObjectDefinition'");
        }
        ObjectDefinition definition = root.getAttributeValue("indexType") != null ? new ObjectDefinition(root.getAttributeValue("type"), root.getAttributeValue("indexType")) : new ObjectDefinition(root.getAttributeValue("type"));
        for (Object element : root.getChildren()) {
            definition.addDocumentDefinition(this.parseDocument((Element)element));
        }
        return definition;
    }

    private DocumentDefinition parseDocument(Element element) throws ObjectDefinitionException {
        if (!element.getName().equals("Document")) {
            throw new ObjectDefinitionException("Cannot find element 'Document'");
        }
        DocumentDefinition definition = new DocumentDefinition(element.getAttributeValue("type"));
        for (Object dataSources : element.getChildren("DataSources")) {
            this.logger.info("Adding DataSources...");
            for (Object source : ((Element)dataSources).getChildren("DataSource")) {
                definition.addDataSource(this.parseDataSource((Element)source));
            }
        }
        for (Object source : element.getChildren("DataSource")) {
            definition.addDataSource(this.parseDataSource((Element)source));
        }
        return definition;
    }

    private DataSource parseDataSource(Element source) throws ObjectDefinitionException {
        Element pathCreator;
        DataSource ds;
        if (!source.getName().equals("DataSource")) {
            throw new ObjectDefinitionException("Cannot find element 'DataSource'");
        }
        if (source.getAttributeValue("type").equalsIgnoreCase("JDBC")) {
            ds = new JDBCDataSource(1);
            ds.setAction(source.getAttributeValue("action"));
            ((JDBCDataSource)ds).setQuery(source.getChildText("Query").trim());
            for (Object param : source.getChildren("Param")) {
                ParameterDefinition parameter = new ParameterDefinition(((Element)param).getAttributeValue("format"), ((Element)param).getAttributeValue("type"), ((Element)param).getAttributeValue("value"));
                ((JDBCDataSource)ds).addParameter(parameter);
            }
        } else if (source.getAttributeValue("type").equalsIgnoreCase("File")) {
            ds = new FileDataSource(2);
            ds.setAction(source.getAttributeValue("action"));
            pathCreator = source.getChild("PathCreator");
            if (pathCreator != null) {
                ((FileDataSource)ds).setPathCreator(PathCreatorFactory.factory(pathCreator.getAttributeValue("name")));
            }
        } else if (source.getAttributeValue("type").equalsIgnoreCase("Directory")) {
            ds = new DirectoryDataSource(3);
            ds.setAction(source.getAttributeValue("action"));
            pathCreator = source.getChild("PathCreator");
            if (pathCreator != null) {
                ((DirectoryDataSource)ds).setPathCreator(PathCreatorFactory.factory(pathCreator.getAttributeValue("name")));
            }
        } else {
            throw new ObjectDefinitionException("Invalid type for element 'DataSource' type=" + source.getAttributeValue("type"));
        }
        for (Object nestedDS : source.getChildren("DataSource")) {
            ds.addDataSource(this.parseDataSource((Element)nestedDS));
        }
        for (Object dataSources : source.getChildren("DataSources")) {
            this.logger.info("Adding nested dataSources...");
            for (Object xiDS : ((Element)dataSources).getChildren("DataSource")) {
                ds.addDataSource(this.parseDataSource((Element)xiDS));
            }
        }
        for (Object field : source.getChildren("Field")) {
            FieldDefinition fieldDef = new FieldDefinition(((Element)field).getAttributeValue("store"), ((Element)field).getAttributeValue("index"), ((Element)field).getAttributeValue("name"), ((Element)field).getAttributeValue("column"), ((Element)field).getAttributeValue("type"), ((Element)field).getAttributeValue("global"), ((Element)field).getAttributeValue("dynamicName"));
            for (Object transformer : ((Element)field).getChildren("Transformer")) {
                TransformerDefinition transDef = new TransformerDefinition(((Element)transformer).getAttributeValue("name"));
                fieldDef.addTransformer(transDef);
            }
            ds.addField(fieldDef);
        }
        this.logger.debug(ds);
        return ds;
    }
}

