/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.DocumentHandler;
import de.ilias.services.lucene.index.DocumentHandlerException;
import de.ilias.services.lucene.index.DocumentHolder;
import de.ilias.services.lucene.index.IndexHolder;
import de.ilias.services.object.DocumentDefinition;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ObjectDefinition
implements DocumentHandler {
    public static final String TYPE_FULL = "full";
    public static final String TYPE_INCREMENTAL = "incremental";
    protected Logger logger = Logger.getLogger(ObjectDefinition.class);
    private String type;
    private String indexType = "full";
    private Vector<DocumentDefinition> documents = new Vector();

    public ObjectDefinition(String type, String indexType) {
        this(type);
        this.setIndexType(indexType);
    }

    public ObjectDefinition(String type) {
        this();
        this.setType(type);
    }

    public ObjectDefinition() {
    }

    public void setType(String type) {
        this.logger.debug("Found new definition for type: " + type);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public Vector<DocumentDefinition> getDocumentDefinitions() {
        return this.documents;
    }

    public void addDocumentDefinition(DocumentDefinition doc) {
        this.documents.add(doc);
    }

    public void removeDocumentDefinition(DocumentDefinition doc) {
        int index;
        while ((index = this.documents.indexOf(doc)) != -1) {
            this.documents.remove(index);
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Object Definition for type = " + this.getType());
        out.append("\n");
        for (DocumentDefinition doc : this.getDocumentDefinitions()) {
            out.append(doc);
            out.append("\n");
        }
        return out.toString();
    }

    @Override
    public void writeDocument(CommandQueueElement el) throws DocumentHandlerException, IOException {
        DocumentHolder docs = DocumentHolder.factory();
        docs.newGlobalDocument();
        for (DocumentDefinition def : this.getDocumentDefinitions()) {
            this.logger.debug("1. New document definition");
            def.writeDocument(el);
        }
        IndexHolder writer = IndexHolder.getInstance();
        writer.getWriter().addDocument(docs.getGlobalDocument());
    }

    @Override
    public void writeDocument(CommandQueueElement el, ResultSet res) throws DocumentHandlerException {
    }
}

