/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.DocumentHandlerException;
import de.ilias.services.lucene.index.file.ExtensionFileHandler;
import de.ilias.services.lucene.index.file.FileHandlerException;
import de.ilias.services.lucene.index.file.path.PathCreator;
import de.ilias.services.lucene.index.file.path.PathCreatorException;
import de.ilias.services.object.DataSource;
import de.ilias.services.object.FieldDefinition;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;

public class FileDataSource
extends DataSource {
    private PathCreator pathCreator = null;

    public FileDataSource(int type) {
        super(type);
    }

    @Override
    public void writeDocument(CommandQueueElement el, ResultSet res) throws DocumentHandlerException {
        File file = null;
        ExtensionFileHandler handler = new ExtensionFileHandler();
        try {
            if (this.getPathCreator() == null) {
                logger.info("No path creator defined");
                return;
            }
            file = this.getPathCreator().buildFile(el, res);
            for (FieldDefinition field : this.getFields()) {
                field.writeDocument(handler.getContent(file));
            }
            logger.debug("File path is: " + file.getAbsolutePath());
            return;
        }
        catch (PathCreatorException e) {
            if (file != null) {
                logger.info("Current Files is: " + file.getAbsolutePath());
            }
            throw new DocumentHandlerException(e);
        }
        catch (FileHandlerException e) {
            if (file != null) {
                logger.info("Current Files is: " + file.getAbsolutePath());
            }
            throw new DocumentHandlerException(e);
        }
    }

    public void setPathCreator(PathCreator pathCreator) {
        this.pathCreator = pathCreator;
    }

    public PathCreator getPathCreator() {
        return this.pathCreator;
    }

    @Override
    public void writeDocument(CommandQueueElement el) throws DocumentHandlerException, IOException {
        this.writeDocument(el, null);
    }
}

