/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.DocumentHolder;
import de.ilias.services.lucene.index.transform.ContentTransformer;
import de.ilias.services.lucene.index.transform.TransformerFactory;
import de.ilias.services.object.TransformerDefinition;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;

public class FieldDefinition {
    protected static Logger logger = Logger.getLogger(FieldDefinition.class);
    private Field.Index index;
    private Field.Store store;
    private String column;
    private String type = "text";
    private String name;
    private boolean global = true;
    private boolean isDynamic = false;
    Vector<TransformerDefinition> transformers = new Vector();

    public FieldDefinition(String store, String index, String name, String column, String type, String isGlobal, String dynamicName) {
        if (store.equalsIgnoreCase("YES")) {
            this.store = Field.Store.YES;
        } else if (store.equalsIgnoreCase("NO")) {
            this.store = Field.Store.NO;
        }
        if (index.equalsIgnoreCase("NO")) {
            this.index = Field.Index.NO;
        } else if (index.equalsIgnoreCase("ANALYZED")) {
            this.index = Field.Index.ANALYZED;
        } else if (index.equalsIgnoreCase("NOT_ANALYZED")) {
            this.index = Field.Index.NOT_ANALYZED;
        }
        this.global = isGlobal == null || isGlobal.equalsIgnoreCase("YES");
        if (dynamicName != null) {
            this.name = dynamicName;
            this.isDynamic = true;
        } else {
            this.name = name;
        }
        this.column = column;
        if (type != null && type.length() != 0) {
            this.setType(type);
        }
    }

    public Field.Index getIndex() {
        return this.index;
    }

    public void setIndex(Field.Index index) {
        this.index = index;
    }

    public Field.Store getStore() {
        return this.store;
    }

    public void setStore(Field.Store store) {
        this.store = store;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String parseName(ResultSet res) throws SQLException {
        if (!this.isDynamic) {
            return this.getName();
        }
        if (res != null) {
            String value;
            if (this.getType().equalsIgnoreCase("clob")) {
                value = DBFactory.getCLOB(res, this.getName());
            } else if (this.getType().equalsIgnoreCase("text")) {
                value = DBFactory.getString(res, this.getName());
            } else if (this.getType().equalsIgnoreCase("integer")) {
                value = DBFactory.getInt(res, this.getName());
            } else {
                logger.warn("Unknown type given for Field name: " + this.getName());
                return "";
            }
            if (value != null) {
                logger.debug("Dynamic name value: " + value);
                logger.debug("Dynamic name:" + this.getName());
                return value;
            }
        }
        throw new SQLException("Invalid result set for dynamic field name: " + this.getName());
    }

    public Vector<TransformerDefinition> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(Vector<TransformerDefinition> transformers) {
        this.transformers = transformers;
    }

    public void addTransformer(TransformerDefinition trans) {
        this.transformers.add(trans);
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Field: " + this.getStore() + " " + this.getIndex() + " " + this.getColumn() + " " + this.getName());
        out.append("\n");
        for (TransformerDefinition tr : this.getTransformers()) {
            out.append(((Object)tr).toString());
            out.append("\n");
        }
        return out.toString();
    }

    public void writeDocument(ResultSet res) throws SQLException {
        try {
            String value;
            if (this.getType().equalsIgnoreCase("clob")) {
                value = DBFactory.getCLOB(res, this.getColumn());
            } else if (this.getType().equalsIgnoreCase("text")) {
                value = DBFactory.getString(res, this.getColumn());
            } else if (this.getType().equalsIgnoreCase("integer")) {
                value = DBFactory.getInt(res, this.getColumn());
            } else {
                logger.warn("Unknown type given for Field name: " + this.getName());
                return;
            }
            if (value != null && value.length() > 0) {
                String purged = this.callTransformers(value);
                String fieldName = this.parseName(res);
                logger.debug("Found value: " + purged + " for name: " + fieldName);
                DocumentHolder.factory().add(fieldName, purged, this.isGlobal(), this.store, this.index);
            }
            return;
        }
        catch (NullPointerException e) {
            logger.error("Caught NullPointerException: " + e.getMessage());
            return;
        }
    }

    public void writeDocument(String content) {
        if (content != null && content.length() != 0) {
            String purged = this.callTransformers(content);
            DocumentHolder.factory().add(this.getName(), purged, this.isGlobal(), this.store, this.index);
            return;
        }
    }

    private String callTransformers(String value) {
        ContentTransformer trans = TransformerFactory.factory("WhitespaceSanitizer");
        value = trans.transform(value);
        for (int i = 0; i < this.getTransformers().size(); ++i) {
            logger.debug(this.getTransformers().get(i).getName());
            trans = TransformerFactory.factory(this.getTransformers().get(i).getName());
            if (trans == null) continue;
            value = trans.transform(value);
        }
        trans = TransformerFactory.factory("TagSanitizer");
        return trans.transform(value);
    }
}

