/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.object;

import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.DocumentHandlerException;
import de.ilias.services.lucene.index.file.ExtensionFileHandler;
import de.ilias.services.lucene.index.file.FileHandlerException;
import de.ilias.services.lucene.index.file.path.PathCreatorException;
import de.ilias.services.object.FieldDefinition;
import de.ilias.services.object.FileDataSource;
import java.io.File;
import java.io.FileFilter;
import java.sql.ResultSet;
import java.util.Vector;

public class DirectoryDataSource
extends FileDataSource {
    public DirectoryDataSource(int type) {
        super(type);
    }

    @Override
    public void writeDocument(CommandQueueElement el, ResultSet res) throws DocumentHandlerException {
        ExtensionFileHandler handler = new ExtensionFileHandler();
        StringBuilder content = new StringBuilder();
        logger.info("Start scanning directory...");
        try {
            if (this.getPathCreator() == null) {
                logger.info("No path creator defined");
                return;
            }
            File start = this.getPathCreator().buildFile(el, res);
            FileReader reader = new FileReader();
            reader.traverse(start);
            Vector<File> files = reader.getFiles();
            logger.info("Found " + files.size() + " new files.");
            for (int i = 0; i < files.size(); ++i) {
                try {
                    content.append(" " + handler.getContent(files.get(i)));
                    continue;
                }
                catch (FileHandlerException e) {
                    logger.warn("Cannot parse file " + files.get(i).getAbsolutePath());
                }
            }
            for (FieldDefinition field : this.getFields()) {
                field.writeDocument(content.toString());
            }
            logger.debug("Content is : " + content.toString());
        }
        catch (PathCreatorException e) {
            throw new DocumentHandlerException(e);
        }
    }

    class FileReader {
        Vector<File> files = new Vector();

        FileReader() {
        }

        public Vector<File> getFiles() {
            return this.files;
        }

        public void traverse(File dir) {
            File[] entries = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    if (path.isDirectory()) {
                        return !path.getName().equals(".svn");
                    }
                    FileReader.this.files.add(path);
                    return false;
                }
            });
            for (int i = 0; i < entries.length; ++i) {
                this.traverse(entries[i]);
            }
        }
    }
}

