/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.search.highlight;

import de.ilias.services.lucene.index.FieldInfo;
import de.ilias.services.lucene.search.SearchHolder;
import de.ilias.services.lucene.search.highlight.HighlightField;
import de.ilias.services.lucene.search.highlight.HighlightHits;
import de.ilias.services.lucene.search.highlight.HighlightItem;
import de.ilias.services.lucene.search.highlight.HighlightObject;
import de.ilias.services.lucene.settings.LuceneSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;

public class HitHighlighter {
    private static int FRAGMENT_TITLE_SIZE = 10000;
    private static String HIGHLIGHT_SEPARATOR = "...";
    private static String HIGHLIGHT_BEGIN_TAG = "<span class=\"ilSearchHighlight\">";
    private static String HIGHLIGHT_END_TAG = "</span>";
    protected static Logger logger = Logger.getLogger(HitHighlighter.class);
    private IndexSearcher searcher;
    private Query query;
    private ScoreDoc[] hits;
    private Highlighter highlighter;
    private Highlighter titleHighlighter;
    private FieldInfo fieldInfo;
    private HighlightHits result;
    private LuceneSettings luceneSettings;

    public HitHighlighter(Query query, ScoreDoc[] hits) throws ConfigurationException, IOException, SQLException {
        this.query = query;
        this.hits = hits;
        this.init();
    }

    public void highlight() throws CorruptIndexException, IOException {
        this.result = new HighlightHits();
        String[] fields = this.fieldInfo.getFieldsAsStringArray();
        for (int i = 0; i < this.hits.length; ++i) {
            TokenStream token;
            String fragment;
            int subItem;
            int objId;
            if (i == 0) {
                this.result.setMaxScore(this.hits[i].score);
            }
            StringBuffer allContent = new StringBuffer();
            Document hitDoc = this.searcher.doc(this.hits[i].doc);
            try {
                objId = Integer.parseInt(hitDoc.get("objId"));
            }
            catch (NumberFormatException e) {
                logger.warn("Found invalid document with title " + hitDoc.get("title"));
                continue;
            }
            try {
                subItem = Integer.parseInt(hitDoc.get("subItem"));
            }
            catch (NumberFormatException e) {
                subItem = 0;
            }
            HighlightObject resObject = this.result.initObject(objId);
            HighlightItem resItem = resObject.addItem(subItem);
            resItem.setAbsoluteScore(this.hits[i].score);
            if (hitDoc.get("title") != null && (fragment = this.titleHighlighter.getBestFragments(token = new StandardAnalyzer().tokenStream("title", new StringReader(hitDoc.get("title"))), hitDoc.get("title"), this.luceneSettings.getNumFragments(), HIGHLIGHT_SEPARATOR)).length() != 0) {
                resItem.addField(new HighlightField("title", fragment));
            }
            if (hitDoc.get("description") != null && (fragment = this.titleHighlighter.getBestFragments(token = new StandardAnalyzer().tokenStream("description", new StringReader(hitDoc.get("description"))), hitDoc.get("description"), this.luceneSettings.getNumFragments(), HIGHLIGHT_SEPARATOR)).length() != 0) {
                resItem.addField(new HighlightField("description", fragment));
            }
            for (int j = 0; j < fields.length; ++j) {
                if (fields[j].equals("metaData") || fields[j].equals("title") || fields[j].equals("description")) continue;
                Field[] separatedFields = hitDoc.getFields(fields[j]);
                for (int k = 0; k < separatedFields.length; ++k) {
                    allContent.append(separatedFields[k].stringValue());
                    allContent.append(" ");
                }
            }
            token = new StandardAnalyzer().tokenStream("content", new StringReader(allContent.toString()));
            fragment = this.highlighter.getBestFragments(token, allContent.toString(), this.luceneSettings.getNumFragments(), HIGHLIGHT_SEPARATOR);
            if (fragment.length() == 0) continue;
            resItem.addField(new HighlightField("content", fragment));
        }
    }

    private void init() throws ConfigurationException, IOException, SQLException {
        this.luceneSettings = LuceneSettings.getInstance();
        QueryScorer queryScorer = new QueryScorer(this.query);
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(HIGHLIGHT_BEGIN_TAG, HIGHLIGHT_END_TAG);
        this.highlighter = new Highlighter(formatter, queryScorer);
        SimpleFragmenter fragmenter = new SimpleFragmenter(this.luceneSettings.getFragmentSize());
        this.highlighter.setTextFragmenter(fragmenter);
        this.highlighter.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
        this.titleHighlighter = new Highlighter(formatter, queryScorer);
        SimpleFragmenter titleFragmenter = new SimpleFragmenter(FRAGMENT_TITLE_SIZE);
        this.titleHighlighter.setTextFragmenter(titleFragmenter);
        this.fieldInfo = FieldInfo.getInstance(LocalSettings.getClientKey());
        this.searcher = SearchHolder.getInstance().getSearcher();
    }

    public String toXML() {
        return this.result.toXML();
    }
}

