/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.search.highlight;

import de.ilias.services.lucene.search.ResultExport;
import de.ilias.services.lucene.search.highlight.HighlightItem;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class HighlightObject
implements ResultExport,
Comparator {
    protected static Logger logger = Logger.getLogger(HighlightObject.class);
    private TreeMap<Integer, HighlightItem> items = new TreeMap();
    private TreeMap<Integer, HighlightItem> sortedItems = new TreeMap();
    private int objId;

    public HighlightObject() {
    }

    public HighlightObject(int objId) {
        this.setObjId(objId);
    }

    public HighlightItem addItem(int subId) {
        if (this.items.containsKey(subId)) {
            return this.items.get(subId);
        }
        this.items.put(subId, new HighlightItem(subId));
        return this.items.get(subId);
    }

    public TreeMap<Integer, HighlightItem> getItems() {
        return this.items;
    }

    public void setObjId(int objId) {
        this.objId = objId;
    }

    public int getObjId() {
        return this.objId;
    }

    @Override
    public Element addXML() {
        Element obj = new Element("Object");
        obj.setAttribute("id", String.valueOf(this.getObjId()));
        this.sortedItems = new TreeMap(this);
        this.sortedItems.putAll(this.items);
        for (HighlightItem item : this.sortedItems.values()) {
            obj.addContent(((ResultExport)item).addXML());
        }
        return obj;
    }

    public int compare(Object o1, Object o2) {
        int index1 = (Integer)o1;
        int index2 = (Integer)o2;
        if (this.items.get(index1).getAbsoluteScore() < this.items.get(index2).getAbsoluteScore()) {
            return 1;
        }
        if (this.items.get(index1).getAbsoluteScore() > this.items.get(index2).getAbsoluteScore()) {
            return -1;
        }
        return 0;
    }
}

