/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.search;

import java.util.Vector;
import org.apache.log4j.Logger;

public class QueryRewriter {
    public static final int MODE_SEARCH = 1;
    public static final int MODE_HIGHLIGHT = 2;
    public static final int MODE_MAIL_HIGHLIGHT = 3;
    public static final int MODE_USER_HIGHLIGHT = 4;
    protected static Logger logger = Logger.getLogger(QueryRewriter.class);
    private String query;
    private StringBuffer rewritten;
    private int mode;
    private Vector<Integer> objIds = new Vector();

    public QueryRewriter(int mode, String query) {
        this.query = query;
        this.mode = mode;
        this.rewritten = new StringBuffer();
    }

    public String rewrite() {
        switch (this.mode) {
            case 1: {
                return this.rewriteSearch();
            }
            case 2: {
                return this.rewriteHighlight();
            }
            case 4: {
                return this.rewriteUserHighlight();
            }
        }
        return this.getQuery();
    }

    public String rewrite(int userId, int folderId) {
        if (this.mode == 3) {
            return this.rewriteMailHighlight(userId, folderId);
        }
        return this.getQuery();
    }

    public String rewrite(Vector<Integer> objIds) {
        this.setObjIds(objIds);
        return this.rewrite();
    }

    private String rewriteHighlight() {
        this.rewritten.append("( ");
        this.rewritten.append(this.getQuery());
        this.rewritten.append(" ) AND ((");
        for (int i = 0; i < this.objIds.size(); ++i) {
            this.rewritten.append("objId:");
            this.rewritten.append(this.objIds.get(i));
            this.rewritten.append(' ');
        }
        this.rewritten.append(" ) AND docType:separated)");
        logger.debug("Searching for: " + this.rewritten.toString());
        return this.rewritten.toString();
    }

    private String rewriteMailHighlight(int userId, int folderId) {
        this.rewritten.append("( ");
        this.rewritten.append(this.getQuery());
        this.rewritten.append(") AND ((");
        this.rewritten.append("objId:");
        this.rewritten.append(userId);
        if (folderId > 0) {
            this.rewritten.append(" AND ");
            this.rewritten.append("mfolder_id:");
            this.rewritten.append(folderId);
        }
        this.rewritten.append(") AND docType:separated) ");
        logger.debug("Searching for: " + this.rewritten.toString());
        return this.rewritten.toString();
    }

    private String rewriteSearch() {
        this.rewritten.append("(");
        this.rewritten.append(this.getQuery());
        this.rewritten.append(")");
        this.rewritten.append(" AND +docType:combined");
        logger.debug("Searching for: " + this.rewritten.toString());
        return this.rewritten.toString();
    }

    private String rewriteUserHighlight() {
        this.rewritten.append("(");
        this.rewritten.append(this.getQuery());
        this.rewritten.append(")");
        this.rewritten.append(" AND type:usr");
        logger.info("Searching for:" + this.rewritten.toString());
        return this.rewritten.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public Vector<Integer> getObjIds() {
        return this.objIds;
    }

    public void setObjIds(Vector<Integer> objIds) {
        this.objIds = objIds;
    }
}

