/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.transform;

import de.ilias.services.lucene.index.transform.ContentObjectTransformer;
import de.ilias.services.lucene.index.transform.ContentTransformer;
import de.ilias.services.lucene.index.transform.FilnameExtractor;
import de.ilias.services.lucene.index.transform.LinefeedSanitizer;
import de.ilias.services.lucene.index.transform.MimeTypeExtractor;
import de.ilias.services.lucene.index.transform.QuotingSanitizer;
import de.ilias.services.lucene.index.transform.TagSanitizer;
import de.ilias.services.lucene.index.transform.WhitespaceSanitizer;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import org.apache.log4j.Logger;

public class TransformerFactory {
    protected static Logger logger = Logger.getLogger(Transformer.class);
    private static HashMap<String, ContentTransformer> map = new HashMap();

    public static ContentTransformer factory(String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        if (name.equalsIgnoreCase("QuotingSanitizer")) {
            map.put(name, new QuotingSanitizer());
            return map.get(name);
        }
        if (name.equalsIgnoreCase("ContentObjectTransformer")) {
            map.put(name, new ContentObjectTransformer());
            return map.get(name);
        }
        if (name.equalsIgnoreCase("LinefeedSanitizer")) {
            map.put(name, new LinefeedSanitizer());
            return map.get(name);
        }
        if (name.equalsIgnoreCase("WhitespaceSanitizer")) {
            map.put(name, new WhitespaceSanitizer());
            return map.get(name);
        }
        if (name.equalsIgnoreCase("FilenameExtractor")) {
            map.put(name, new FilnameExtractor());
            return map.get(name);
        }
        if (name.equalsIgnoreCase("TagSanitizer")) {
            map.put(name, new TagSanitizer());
            return map.get(name);
        }
        if (name.equalsIgnoreCase("MimeTypeExtractor")) {
            map.put(name, new MimeTypeExtractor());
            return map.get(name);
        }
        logger.error("Cannot find transformer with name: " + name);
        return null;
    }
}

