/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file.path;

import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.file.path.PathCreator;
import de.ilias.services.lucene.index.file.path.PathCreatorException;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.File;
import java.sql.ResultSet;

public class HTLMObjectPathCreator
implements PathCreator {
    @Override
    public File buildFile(CommandQueueElement el, ResultSet res) throws PathCreatorException {
        int objId = el.getObjId();
        StringBuilder fullPath = new StringBuilder();
        try {
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getAbsolutePath());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append("data");
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getClient());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append("lm_data");
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append("lm_");
            fullPath.append(String.valueOf(objId));
            File file = new File(fullPath.toString());
            if (file.exists() && file.canRead()) {
                return file;
            }
            throw new PathCreatorException("Cannot access directory: " + fullPath.toString());
        }
        catch (ConfigurationException e) {
            throw new PathCreatorException(e);
        }
    }

    @Override
    public File buildFile(CommandQueueElement el) throws PathCreatorException {
        return this.buildFile(el, null);
    }
}

