/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file.path;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.file.path.PathCreator;
import de.ilias.services.lucene.index.file.path.PathCreatorException;
import de.ilias.services.lucene.index.file.path.PathUtils;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FileObjectPathCreator
implements PathCreator {
    protected String basePath = "ilFiles";

    public void setBasePath(String bp) {
        this.basePath = bp;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public File buildFile(CommandQueueElement el, ResultSet res) throws PathCreatorException {
        int objId = el.getObjId();
        StringBuilder fullPath = new StringBuilder();
        StringBuilder versionPath = new StringBuilder();
        try {
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getDataDirectory().getAbsolutePath());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getClient());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(this.getBasePath());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(PathUtils.buildSplittedPathFromId(objId, "file"));
            versionPath.append((CharSequence)fullPath);
            versionPath.append(PathUtils.buildVersionDirectory(res.getInt("version")));
            versionPath.append(System.getProperty("file.separator"));
            versionPath.append(DBFactory.getString(res, "file_name"));
            File file = new File(versionPath.toString());
            if (file.exists() && file.canRead()) {
                return file;
            }
            fullPath.append(DBFactory.getString(res, "file_name"));
            file = new File(fullPath.toString());
            if (file.exists() && file.canRead()) {
                return file;
            }
            if (!file.exists()) {
                throw new PathCreatorException("Cannot find file: " + fullPath.toString());
            }
            if (!file.canRead()) {
                throw new PathCreatorException("Cannot read file: " + fullPath.toString());
            }
            return null;
        }
        catch (ConfigurationException e) {
            throw new PathCreatorException(e);
        }
        catch (SQLException e) {
            throw new PathCreatorException(e);
        }
        catch (NullPointerException e) {
            throw new PathCreatorException(e);
        }
    }

    @Override
    public File buildFile(CommandQueueElement el) throws PathCreatorException {
        return this.buildFile(el, null);
    }
}

