/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file.path;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.index.file.path.PathCreator;
import de.ilias.services.lucene.index.file.path.PathCreatorException;
import de.ilias.services.lucene.index.file.path.PathUtils;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ExerciseAssignmentPathCreator
implements PathCreator {
    protected Logger logger = Logger.getLogger(ExerciseAssignmentPathCreator.class);

    @Override
    public File buildFile(CommandQueueElement el, ResultSet res) throws PathCreatorException {
        int objId = el.getObjId();
        StringBuilder fullPath = new StringBuilder();
        try {
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getDataDirectory().getAbsolutePath());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(ClientSettings.getInstance(LocalSettings.getClientKey()).getClient());
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append("ilExercise");
            fullPath.append(System.getProperty("file.separator"));
            fullPath.append(PathUtils.buildSplittedPathFromId(objId, "exc"));
            fullPath.append("ass_" + String.valueOf(DBFactory.getInt(res, "id")));
            this.logger.info("Try to read from path: " + fullPath.toString());
            File file = new File(fullPath.toString());
            if (file.exists() && file.canRead()) {
                return file;
            }
            throw new PathCreatorException("Cannot access directory: " + fullPath.toString());
        }
        catch (ConfigurationException e) {
            throw new PathCreatorException(e);
        }
        catch (SQLException e) {
            throw new PathCreatorException(e);
        }
        catch (NullPointerException e) {
            throw new PathCreatorException(e);
        }
    }

    @Override
    public File buildFile(CommandQueueElement el) throws PathCreatorException {
        return this.buildFile(el, null);
    }
}

