/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index.file;

import de.ilias.services.lucene.index.file.FileHandler;
import de.ilias.services.lucene.index.file.FileHandlerException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;

public class PDFBoxPDFHandler
implements FileHandler {
    protected Logger logger = Logger.getLogger(PDFBoxPDFHandler.class);

    @Override
    public String getContent(InputStream is) throws FileHandlerException {
        PDDocument pddo = null;
        PDFTextStripper stripper = null;
        String str = new String("");
        try {
            pddo = PDDocument.load(is);
            if (pddo.isEncrypted()) {
                this.logger.warn("PDF Document is encrypted. Trying empty password...");
                String string = "";
                return string;
            }
            stripper = new PDFTextStripper();
            str = stripper.getText(pddo);
        }
        catch (NumberFormatException e) {
            this.logger.warn("Invalid PDF version number given. Aborting");
        }
        catch (IOException e) {
            this.logger.warn(e.getMessage());
            throw new FileHandlerException(e);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new FileHandlerException(e);
        }
        finally {
            try {
                if (pddo != null) {
                    pddo.close();
                }
            }
            catch (IOException e) {}
        }
        return str;
    }

    @Override
    public InputStream transformStream(InputStream is) {
        return null;
    }
}

