/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import de.ilias.ilServerStatus;
import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.CommandController;
import de.ilias.services.lucene.index.CommandControllerThread;
import de.ilias.services.lucene.index.IndexHolder;
import de.ilias.services.object.ObjectDefinitionParser;
import de.ilias.services.object.ObjectDefinitionReader;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.LocalSettings;
import de.ilias.services.settings.ServerSettings;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RPCIndexHandler {
    protected static Logger logger = Logger.getLogger(RPCIndexHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexObjects(String clientKey, Vector<Integer> objIds) {
        LocalSettings.setClientKey(clientKey);
        DBFactory.init();
        try {
            int i;
            long s_start = new Date().getTime();
            logger.info("Checking if indexer is running for client: " + clientKey);
            if (ilServerStatus.isIndexerActive(clientKey)) {
                logger.error("An Indexer is already running for this client. Aborting!");
                boolean bl = false;
                return bl;
            }
            ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
            ServerSettings server = ServerSettings.getInstance();
            ObjectDefinitionReader properties = ObjectDefinitionReader.getInstance(client.getAbsolutePath());
            ObjectDefinitionParser parser = new ObjectDefinitionParser(properties.getObjectPropertyFiles());
            parser.parse();
            CommandController controller = new CommandController();
            controller.initObjects(objIds);
            Vector<CommandControllerThread> threads = new Vector<CommandControllerThread>();
            for (i = 0; i < server.getNumThreads(); ++i) {
                CommandControllerThread t = new CommandControllerThread(clientKey, controller);
                t.start();
                threads.add(t);
            }
            for (i = 0; i < server.getNumThreads(); ++i) {
                ((CommandControllerThread)threads.get(i)).join();
            }
            controller.writeToIndex();
            controller.closeIndex();
            long s_end = new Date().getTime();
            logger.info("Index time: " + (s_end - s_start) / 1000L + " seconds");
            logger.debug(client.getIndexPath());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unknown error", e);
        }
        finally {
            DBFactory.closeAll();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean index(String clientKey, boolean incremental) {
        Boolean doPurge = true;
        LocalSettings.setClientKey(clientKey);
        DBFactory.init();
        try {
            int i;
            long s_start = new Date().getTime();
            logger.info("Checking if indexer is running for client: " + clientKey);
            if (ilServerStatus.isIndexerActive(clientKey)) {
                logger.error("An Indexer is already running for this client. Aborting!");
                System.err.println("An Indexer is already running for this client. Aborting!");
                doPurge = false;
                boolean bl = false;
                return bl;
            }
            ilServerStatus.addIndexer(clientKey);
            ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
            ServerSettings server = ServerSettings.getInstance();
            if (!incremental) {
                IndexHolder.deleteIndex();
            }
            ObjectDefinitionReader properties = ObjectDefinitionReader.getInstance(client.getAbsolutePath());
            ObjectDefinitionParser parser = new ObjectDefinitionParser(properties.getObjectPropertyFiles());
            parser.parse();
            CommandController controller = new CommandController();
            if (incremental) {
                controller.initRefresh();
            } else {
                controller.initCreate();
            }
            Vector<CommandControllerThread> threads = new Vector<CommandControllerThread>();
            for (i = 0; i < server.getNumThreads(); ++i) {
                CommandControllerThread t = new CommandControllerThread(clientKey, controller);
                t.start();
                threads.add(t);
            }
            for (i = 0; i < server.getNumThreads(); ++i) {
                ((CommandControllerThread)threads.get(i)).join();
            }
            controller.writeToIndex();
            controller.closeIndex();
            long s_end = new Date().getTime();
            logger.info("Index time: " + (s_end - s_start) / 1000L + " seconds");
            logger.debug(client.getIndexPath());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unknown error", e);
        }
        finally {
            if (doPurge.booleanValue()) {
                ilServerStatus.removeIndexer(clientKey);
                DBFactory.closeAll();
            }
        }
        return false;
    }
}

