/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.ConfigurationException;
import de.ilias.services.settings.LocalSettings;
import de.ilias.services.settings.ServerSettings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexHolder {
    protected static Logger logger = Logger.getLogger(IndexHolder.class);
    private static HashMap<String, IndexHolder> instances = new HashMap();
    private ClientSettings settings;
    private IndexWriter writer;

    private IndexHolder(String clientKey) throws IOException {
        try {
            this.settings = ClientSettings.getInstance(clientKey);
        }
        catch (ConfigurationException e) {
            throw new IOException("Caught configuration exception: " + e.getMessage());
        }
    }

    public static synchronized IndexHolder getInstance(String clientKey) throws IOException {
        String hash = clientKey;
        if (instances.containsKey(hash)) {
            return instances.get(hash);
        }
        instances.put(hash, new IndexHolder(clientKey));
        return instances.get(hash);
    }

    public static synchronized IndexHolder getInstance() throws IOException {
        return IndexHolder.getInstance(LocalSettings.getClientKey());
    }

    public static void deleteIndex() throws ConfigurationException {
        File indexPath = ClientSettings.getInstance(LocalSettings.getClientKey()).getIndexPath();
        IndexHolder.deleteTree(indexPath);
        logger.info("Deleted index directory: " + indexPath.getAbsoluteFile());
    }

    private static boolean deleteTree(File path) {
        if (!path.exists() || !path.isDirectory()) {
            return false;
        }
        for (File del : path.listFiles()) {
            if (del.isDirectory()) {
                IndexHolder.deleteTree(del);
                continue;
            }
            del.delete();
        }
        path.delete();
        return true;
    }

    public static synchronized void closeAllWriters() {
        logger.info("Closing document writers...");
        for (String key : instances.keySet()) {
            try {
                logger.info("Closing writer: " + key);
                IndexHolder holder = instances.get(key);
                FSDirectory.getDirectory(ClientSettings.getInstance(key).getIndexPath()).close();
                holder.close();
            }
            catch (Exception ex) {
                logger.error("Cannot close fs directory");
            }
        }
        logger.info("Index writers closed.");
    }

    public void init() throws IOException {
        logger.debug("Adding new separated index for " + LocalSettings.getClientKey());
        if (IndexWriter.isLocked(FSDirectory.getDirectory(this.settings.getIndexPath()))) {
            logger.warn("Index writer is locked. Forcing unlock...");
            IndexWriter.unlock(FSDirectory.getDirectory(this.settings.getIndexPath()));
        }
        this.writer = new IndexWriter((Directory)FSDirectory.getDirectory(this.settings.getIndexPath()), (Analyzer)new StandardAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
        try {
            this.writer.setRAMBufferSizeMB(ServerSettings.getInstance().getRAMSize());
        }
        catch (ConfigurationException e) {
            logger.error("Cannot set RAMBufferSize");
        }
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public void setWriter(IndexWriter writer) {
        this.writer = writer;
    }

    public void close() {
        try {
            this.getWriter().close();
            IndexWriter.unlock(FSDirectory.getDirectory(this.settings.getIndexPath()));
            FSDirectory.getDirectory(this.settings.getIndexPath()).close();
        }
        catch (CorruptIndexException e) {
            logger.fatal("Index corrupted." + e);
        }
        catch (IOException e) {
            logger.fatal("Error closing writer." + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

