/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class DocumentHolder {
    protected static Logger logger = Logger.getLogger(DocumentHolder.class);
    private static ThreadLocal<DocumentHolder> thDocumentHolder = new ThreadLocal<DocumentHolder>(){

        @Override
        protected DocumentHolder initialValue() {
            return new DocumentHolder();
        }
    };
    private Document globalDoc = null;
    private Document doc = null;

    private DocumentHolder() {
        this.newGlobalDocument();
        this.newDocument();
    }

    public static DocumentHolder factory() {
        return thDocumentHolder.get();
    }

    public Document newGlobalDocument() {
        this.globalDoc = new Document();
        this.globalDoc.add(new Field("docType", "combined", Field.Store.YES, Field.Index.NOT_ANALYZED));
        return this.globalDoc;
    }

    public Document newDocument() {
        this.doc = new Document();
        this.doc.add(new Field("docType", "separated", Field.Store.YES, Field.Index.NOT_ANALYZED));
        return this.doc;
    }

    public Document getGlobalDocument() {
        return this.globalDoc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void add(String name, String value, boolean isGlobal, Field.Store store, Field.Index index) {
        this.getDocument().add(new Field(name, value, store, index));
        if (isGlobal) {
            this.getGlobalDocument().add(new Field(name, value, store, index));
        }
    }
}

