/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.lucene.index;

import de.ilias.services.db.DBFactory;
import de.ilias.services.lucene.index.CommandQueueElement;
import de.ilias.services.lucene.settings.LuceneSettings;
import de.ilias.services.object.ObjectDefinition;
import de.ilias.services.object.ObjectDefinitions;
import de.ilias.services.settings.ClientSettings;
import de.ilias.services.settings.LocalSettings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CommandQueue {
    protected Logger logger = Logger.getLogger(CommandQueue.class);
    private Connection db = null;
    private Vector<CommandQueueElement> elements = new Vector();
    private int currentIndex = 0;

    public CommandQueue() throws SQLException {
        this.db = DBFactory.factory();
    }

    public void setFinished(CommandQueueElement el) throws SQLException, IllegalArgumentException {
        if (!this.getElements().removeElement(el)) {
            throw new IllegalArgumentException("Cannot find element!");
        }
        PreparedStatement sta = DBFactory.getPreparedStatement("UPDATE search_command_queue SET finished = 1, last_update = ? WHERE  obj_id = ? AND obj_type = ? AND sub_id = ? AND sub_type = ? ");
        sta.setInt(1, el.getObjId());
        sta.setTimestamp(2, new Timestamp(new Date().getTime()));
        DBFactory.setString(sta, 3, el.getObjType());
        sta.setInt(4, el.getSubId());
        DBFactory.setString(sta, 5, el.getSubType());
        sta.executeUpdate();
    }

    public void setFinished(Vector<Integer> objIds) throws SQLException {
        if (objIds.size() == 0) {
            return;
        }
        PreparedStatement psta = DBFactory.getPreparedStatement("UPDATE search_command_queue SET finished = 1 WHERE obj_id = ?");
        for (int i = 0; i < objIds.size(); ++i) {
            psta.setInt(1, objIds.get(i));
            psta.addBatch();
        }
        psta.executeBatch();
    }

    public synchronized void loadFromDb() throws SQLException {
        this.logger.info("Start reading command queue");
        this.substituteResetCommands();
        PreparedStatement pst = DBFactory.getPreparedStatement("SELECT * FROM search_command_queue WHERE finished = 0 OR last_update >= ? ORDER BY last_update ");
        pst.setTimestamp(1, new Timestamp(LuceneSettings.getInstance().getLastIndexTime().getTime()));
        ResultSet res = pst.executeQuery();
        int counter = 0;
        while (res.next()) {
            CommandQueueElement element = new CommandQueueElement();
            this.logger.debug("Found type: " + res.getString("obj_type") + " with id " + res.getInt("obj_id"));
            element.setObjId(res.getInt("obj_id"));
            element.setObjType(DBFactory.getString(res, "obj_type"));
            element.setSubId(res.getInt("sub_id"));
            element.setSubType(DBFactory.getString(res, "sub_type"));
            element.setCommand(DBFactory.getString(res, "command"));
            element.setFinished(false);
            this.getElements().add(element);
            ++counter;
        }
        try {
            res.close();
        }
        catch (SQLException e) {
            this.logger.warn(e);
        }
        this.logger.info("Found " + counter + " new update events!");
    }

    public synchronized void loadFromObjectList(Vector<Integer> objIds) throws SQLException {
        PreparedStatement pst = DBFactory.getPreparedStatement("SELECT obj_id,type FROM object_data WHERE obj_id = ? ");
        int counter = 0;
        for (int objId : objIds) {
            pst.setInt(1, objId);
            ResultSet res = pst.executeQuery();
            while (res.next()) {
                CommandQueueElement element = new CommandQueueElement();
                element.setObjId(res.getInt("obj_id"));
                element.setObjType(DBFactory.getString(res, "type"));
                element.setSubId(0);
                element.setSubType("");
                element.setCommand("reset");
                element.setFinished(false);
                this.getElements().add(element);
                ++counter;
            }
            try {
                res.close();
            }
            catch (SQLException e) {
                this.logger.warn(e);
            }
        }
        this.logger.info("Found " + counter + " new update events!");
    }

    private synchronized void substituteResetCommands() throws SQLException {
        String query = "SELECT * FROM search_command_queue WHERE command = ? AND obj_id = 0";
        try {
            this.logger.info("Substituting reset commands");
            PreparedStatement sta = DBFactory.getPreparedStatement(query);
            DBFactory.setString(sta, 1, "reset_all");
            this.logger.debug("Substitution query: " + sta.toString());
            ResultSet res = sta.executeQuery();
            while (res.next()) {
                this.logger.info("Start substituting obj_type " + res.getString("obj_type"));
                this.deleteCommandsByType(DBFactory.getString(res, "obj_type"));
                this.addCommandsByType(DBFactory.getString(res, "obj_type"));
                this.deleteResetCommandByType(DBFactory.getString(res, "obj_type"));
            }
            res.close();
        }
        catch (SQLException e) {
            this.logger.error("Invalid SQL statement: " + query);
            this.logger.error("Cannot substitute reset commands", e);
            throw e;
        }
        catch (Throwable e) {
            this.logger.fatal("Cannot substitute reset commands", e);
        }
    }

    private synchronized void deleteResetCommandByType(String objType) throws SQLException {
        try {
            this.logger.info("Deleting reset command");
            PreparedStatement sta = DBFactory.getPreparedStatement("DELETE FROM search_command_queue WHERE obj_type = ? AND obj_id = 0 ");
            DBFactory.setString(sta, 1, objType);
            sta.executeUpdate();
            return;
        }
        catch (SQLException e) {
            this.logger.error("Cannot delete reset commands!", e);
            throw e;
        }
    }

    public synchronized void deleteCommandsByType(String objType) throws SQLException {
        try {
            this.logger.info("Deleting old commands from command queue");
            PreparedStatement sta = DBFactory.getPreparedStatement("DELETE FROM search_command_queue WHERE obj_type = ? AND obj_id > 0");
            DBFactory.setString(sta, 1, objType);
            sta.executeUpdate();
            return;
        }
        catch (SQLException e) {
            this.logger.fatal("Cannot delete reset commands! ", e);
            throw e;
        }
    }

    private synchronized void addCommandsByType(String objType) throws SQLException {
        try {
            ResultSet res = null;
            PreparedStatement sta = null;
            sta = !objType.equalsIgnoreCase("usr") ? DBFactory.getPreparedStatement("SELECT DISTINCT(oda.obj_id) FROM object_data oda JOIN object_reference ore ON oda.obj_id = ore.obj_id WHERE (deleted IS NULL) AND type = ? GROUP BY oda.obj_id") : DBFactory.getPreparedStatement("SELECT obj_id FROM object_data WHERE type = ? ");
            DBFactory.setString(sta, 1, objType);
            res = sta.executeQuery();
            this.logger.info("Adding new commands for object type: " + objType);
            PreparedStatement objReset = DBFactory.getPreparedStatement("INSERT INTO search_command_queue (obj_id, obj_type, sub_id, sub_type, command, last_update, finished) VALUES (?, ?, ?, ?, ?, ?, ?)");
            while (res.next()) {
                this.logger.debug("Added new reset command");
                objReset.setInt(1, res.getInt("obj_id"));
                objReset.setString(2, objType);
                objReset.setInt(3, 0);
                objReset.setString(4, "");
                objReset.setString(5, "reset");
                objReset.setTimestamp(6, new Timestamp(new Date().getTime()));
                objReset.setInt(7, 0);
                objReset.executeUpdate();
            }
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (SQLException e) {
                this.logger.warn("Cannot close result set: " + e);
            }
        }
        catch (SQLException e) {
            this.logger.fatal("Cannot build index ", e);
            throw e;
        }
    }

    public synchronized CommandQueueElement nextElement() {
        try {
            return this.elements.get(this.currentIndex++);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public synchronized Vector<CommandQueueElement> getElements() {
        return this.elements;
    }

    public synchronized void debug(String type) throws SQLException {
        PreparedStatement resetType = DBFactory.getPreparedStatement("INSERT INTO search_command_queue SET obj_id = ?,obj_type = ?, sub_id = ?, sub_type = ?, command = ?, last_update = ?, finished = ? ");
        resetType.setInt(1, 0);
        resetType.setString(2, type);
        resetType.setInt(3, 0);
        resetType.setString(4, "");
        resetType.setString(5, "reset_all");
        resetType.setTimestamp(6, new Timestamp(new Date().getTime()));
        resetType.setInt(7, 0);
        resetType.executeUpdate();
    }

    public synchronized void addAll() throws SQLException {
        try {
            Statement delete = this.db.createStatement();
            delete.executeUpdate("DELETE FROM search_command_queue");
            try {
                if (delete != null) {
                    delete.close();
                }
            }
            catch (SQLException e) {
                this.logger.warn(e);
            }
            ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
            PreparedStatement pst = DBFactory.getPreparedStatement("INSERT INTO search_command_queue (obj_id,obj_type,sub_id,sub_type,command,last_update,finished ) VALUES ( ?, ?, ?, ?, ?, ?, ?) ");
            for (ObjectDefinition def : ObjectDefinitions.getInstance(client.getAbsolutePath()).getDefinitions()) {
                this.logger.info("Adding reset command for " + def.getType());
                pst.setInt(1, 0);
                pst.setString(2, def.getType());
                pst.setInt(3, 0);
                pst.setString(4, "");
                pst.setString(5, "reset_all");
                pst.setTimestamp(6, new Timestamp(new Date().getTime()));
                pst.setInt(7, 0);
                pst.executeUpdate();
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot add to command queue", e);
        }
    }

    public synchronized void deleteAll() throws SQLException {
        this.logger.info("Deleting search_command_queue");
        Statement delete = this.db.createStatement();
        delete.execute("DELETE FROM search_command_queue");
        try {
            delete.close();
        }
        catch (SQLException e) {
            this.logger.warn(e);
        }
        this.logger.info("Search command queue deleted");
    }

    public synchronized void deleteNonIncremental() throws SQLException {
        try {
            ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
            PreparedStatement pst = DBFactory.getPreparedStatement("DELETE FROM search_command_queue WHERE obj_type = ?");
            for (ObjectDefinition def : ObjectDefinitions.getInstance(client.getAbsolutePath()).getDefinitions()) {
                if (def.getIndexType() != "full") continue;
                DBFactory.setString(pst, 1, def.getType());
                pst.executeUpdate();
            }
        }
        catch (Exception e) {
            this.logger.error("Error deleting from command queue", e);
        }
    }

    public synchronized void addNonIncremental() throws SQLException {
        try {
            ClientSettings client = ClientSettings.getInstance(LocalSettings.getClientKey());
            PreparedStatement pst = DBFactory.getPreparedStatement("INSERT INTO search_command_queue (obj_id, obj_type,sub_id,sub_type,command,last_update,finished) VALUES (?,?,?,?,?,?,?)");
            for (ObjectDefinition def : ObjectDefinitions.getInstance(client.getAbsolutePath()).getDefinitions()) {
                if (def.getIndexType() != "full") continue;
                this.logger.info("Adding reset command for " + def.getType());
                pst.setInt(1, 0);
                pst.setString(2, def.getType());
                pst.setInt(3, 0);
                pst.setString(4, "");
                pst.setString(5, "reset_all");
                pst.setTimestamp(6, new Timestamp(new Date().getTime()));
                pst.setInt(7, 0);
                pst.executeUpdate();
            }
        }
        catch (Exception e) {
            this.logger.error("Error updating command queue", e);
        }
    }
}

