/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.utils;

import de.ilias.services.filemanager.skin.SkinFactory;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.image.Image;
import javafx.scene.text.Text;
import javafx.scene.text.TextBuilder;

public class FileManagerUtils {
    protected static final Logger logger = Logger.getLogger(FileManagerUtils.class.getName());
    public static final int ROOT_FOLDER_ID = 1;

    public static Image getImageByType(String type) {
        return new Image(SkinFactory.class.getResourceAsStream("ilias/images/icon_" + type + ".gif"));
    }

    public static Image getTinyImageByType(String type) {
        return new Image(SkinFactory.class.getResourceAsStream("ilias/images/icon_" + type + "_s.gif"));
    }

    public static Image getImageByName(String name) {
        return new Image(SkinFactory.class.getResourceAsStream("ilias/images/" + name));
    }

    public static void copyDirectory(File source, File target) throws FileNotFoundException, IOException {
        if (source.getAbsolutePath().length() >= 1000) {
            return;
        }
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdir();
            }
            String[] children = source.list();
            for (int i = 0; i < children.length; ++i) {
                FileManagerUtils.copyDirectory(new File(source, children[i]), new File(target, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(target);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static File createTempDirectory(String prefix) {
        File newTmpDir;
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        int maxAttempts = 10;
        int attempts = 0;
        do {
            if (++attempts < maxAttempts) continue;
            return tmp;
        } while ((newTmpDir = new File(tmp, prefix + UUID.randomUUID().toString().substring(0, 6))).exists());
        if (newTmpDir.mkdir()) {
            logger.info(newTmpDir.getAbsolutePath());
            return newTmpDir;
        }
        logger.info(tmp.getAbsolutePath());
        return tmp;
    }

    public static File createTempFile() throws IOException {
        File tmp = File.createTempFile("ilFm", null);
        tmp.deleteOnExit();
        return tmp;
    }

    public static String createTypeToILIASType(int type) {
        switch (type) {
            case 7: {
                return "cat";
            }
            case 8: {
                return "crs";
            }
            case 10: {
                return "grp";
            }
            case 9: {
                return "fold";
            }
        }
        return "";
    }

    public static Text highlightText(String text, String defaultId) {
        TextBuilder tbuilder = TextBuilder.create();
        Pattern pat = Pattern.compile("(.*)<span class=\"ilSearchHighlight\">(.*)</span>(.*)");
        Matcher mat = pat.matcher(text);
        while (mat.find()) {
            tbuilder.text(mat.group(1)).id(defaultId);
            tbuilder.text(mat.group(2)).id(defaultId + "Highlight");
        }
        return tbuilder.build();
    }

    public static int textToInt(String text) {
        try {
            if (text.length() > 0) {
                return Integer.valueOf(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public static String increaseVersionName(String name, int version) {
        int dot = name.lastIndexOf(".");
        if (dot < 0) {
            return name + " (" + String.valueOf(version) + ")";
        }
        return name.substring(0, dot) + " (" + String.valueOf(version) + ")" + name.substring(dot);
    }

    public static String fileToString(File input) {
        Object res = null;
        DataInputStream in = null;
        try {
            byte[] buffer = new byte[(int)input.length()];
            in = new DataInputStream(new FileInputStream(input));
            in.readFully(buffer);
            return new String(buffer);
        }
        catch (FileNotFoundException e) {
            logger.warning("Cannot find file " + input.getAbsolutePath());
        }
        catch (IOException e) {
            logger.warning("Cannot write from file " + input.getAbsolutePath());
        }
        return new String();
    }

    public static boolean checkAllowedFileSize(File file, int fs) {
        return file.length() < (long)(0x100000 * fs);
    }
}

