/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.ui;

import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.events.BreadcrumbMouseEventHandler;
import de.ilias.services.filemanager.soap.api.SoapClientObjectReferencePath;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.util.List;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class BreadcrumbBuilder {
    private boolean useImages = false;
    private static final Logger logger = Logger.getLogger(BreadcrumbBuilder.class.getName());

    public HBox buildHBox(List<SoapClientObjectReferencePath> pathElements) {
        HBox box = new HBox();
        box.getChildren().add((Object)new Label("  "));
        BreadcrumbMouseEventHandler handler = new BreadcrumbMouseEventHandler();
        int counter = 0;
        for (SoapClientObjectReferencePath ele : pathElements) {
            if (counter > 0) {
                box.getChildren().add((Object)new Label("\u00bb"));
            }
            Hyperlink link = new Hyperlink(ele.getTitle());
            if (this.useImages) {
                link.setGraphic((Node)new ImageView(FileManagerUtils.getTinyImageByType(ele.getType())));
            }
            RemoteListItem remote = new RemoteListItem();
            remote.setRefId(ele.getRefId());
            link.setUserData((Object)remote);
            link.setOnMouseReleased((EventHandler)handler);
            box.getChildren().add((Object)link);
            ++counter;
        }
        return box;
    }
}

