/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.soap.api;

import de.ilias.services.filemanager.content.ListItem;
import de.ilias.services.filemanager.content.RemoteListItem;
import de.ilias.services.filemanager.soap.api.SoapClientObject;
import de.ilias.services.filemanager.soap.api.SoapClientObjectReference;
import de.ilias.services.filemanager.soap.api.SoapClientObjectReferencePath;
import de.ilias.services.filemanager.utils.FileManagerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="Objects")
public class SoapClientObjects {
    @XmlTransient
    private static Logger logger = Logger.getLogger(SoapClientObjects.class.getName());
    private List<SoapClientObject> objects;

    @XmlElement(name="Object")
    public List<SoapClientObject> getObjects() {
        if (this.objects == null) {
            this.objects = new ArrayList<SoapClientObject>();
            return this.objects;
        }
        return this.objects;
    }

    public List<SoapClientObjectReferencePath> getFirstPath(boolean includeLeaf) {
        List<SoapClientObjectReferencePath> pathList;
        block3: {
            SoapClientObjectReference ref;
            SoapClientObject obj;
            Iterator<SoapClientObjectReference> i$;
            pathList = new ArrayList<SoapClientObjectReferencePath>();
            Iterator<SoapClientObject> i$2 = this.getObjects().iterator();
            if (i$2.hasNext() && (i$ = (obj = i$2.next()).getReferences().iterator()).hasNext()) {
                ref = i$.next();
                pathList = ref.getPathElements();
            }
            if (!includeLeaf || !(i$2 = this.getObjects().iterator()).hasNext() || !(i$ = (obj = i$2.next()).getReferences().iterator()).hasNext()) break block3;
            ref = i$.next();
            SoapClientObjectReferencePath leaf = new SoapClientObjectReferencePath();
            if (pathList.size() < 1) {
                leaf.setTitle("Repository");
            } else {
                leaf.setTitle(obj.getTitle());
            }
            leaf.setRefId(ref.getRefId());
            leaf.setType(obj.getType());
            pathList.add(leaf);
        }
        return pathList;
    }

    public ListItem getParentListItem() {
        int minElements = 1;
        for (SoapClientObject obj : this.getObjects()) {
            for (SoapClientObjectReference ref : obj.getReferences()) {
                ArrayList pathElements = (ArrayList)ref.getPathElements();
                if (pathElements.size() < minElements) continue;
                SoapClientObjectReferencePath parent = (SoapClientObjectReferencePath)pathElements.get(pathElements.size() - 1);
                RemoteListItem parentItem = new RemoteListItem();
                parentItem.setRefId(parent.getRefId());
                parentItem.setType(parent.getType());
                parentItem.setTitle(parent.getTitle());
                return parentItem;
            }
        }
        return null;
    }

    public List<File> checkNamingConflicts(List<File> files) {
        ArrayList<File> conflicted = new ArrayList<File>();
        for (File file : files) {
            for (SoapClientObject obj : this.getObjects()) {
                if (!file.getName().equalsIgnoreCase(obj.getTitle()) || !obj.getType().equals("file") && !obj.getType().equals("fold") && !obj.getType().equals("cat") || !obj.isWritable()) continue;
                logger.info("File names are equal!");
                conflicted.add(file);
            }
        }
        return conflicted;
    }

    public HashMap<File, SoapClientObject> checkNamingConflict(List<File> files) {
        HashMap<File, SoapClientObject> conflict = new HashMap<File, SoapClientObject>();
        for (File file : files) {
            for (SoapClientObject obj : this.getObjects()) {
                if (!file.getName().equalsIgnoreCase(obj.getTitle()) || !obj.getType().equals("file") && !obj.getType().equals("fold") && !obj.getType().equals("cat") || !obj.isWritable()) continue;
                logger.info("File names are equal!");
                conflict.put(file, obj);
            }
        }
        return conflict;
    }

    public String createUniqueName(File file) {
        for (int i = 2; i < 50; ++i) {
            String newName = FileManagerUtils.increaseVersionName(file.getName(), i);
            boolean exists = false;
            for (SoapClientObject obj : this.getObjects()) {
                if (!obj.getTitle().equalsIgnoreCase(newName)) continue;
                exists = true;
            }
            if (exists) continue;
            logger.info("Using new name " + newName);
            return newName;
        }
        return file.getName();
    }
}

