/*
 * Decompiled with CFR 0.152.
 */
package de.ilias.services.filemanager.soap.api;

import de.ilias.services.filemanager.soap.api.SoapClientObjectProperty;
import de.ilias.services.filemanager.soap.api.SoapClientObjectReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SoapClientObject {
    @XmlTransient
    public static final String PROP_FILESIZE = "fileSize";
    @XmlTransient
    public static final String PROP_FILE_EXTENSION = "fileExtension";
    @XmlTransient
    public static final String PROP_FILE_VERSION = "fileVersion";
    @XmlTransient
    public static final String PROP_INFO = "info";
    @XmlTransient
    public static final String PROP_FILE_ACCESS = "fileAccess";
    @XmlTransient
    private static Logger logger = Logger.getLogger(SoapClientObject.class.getName());
    @XmlAttribute(name="obj_id")
    private int obj_id;
    @XmlAttribute(name="type")
    private String type;
    @XmlElement(name="Title")
    private String title;
    @XmlElement(name="Description")
    private String description;
    @XmlElement(name="LastUpdate")
    private String lastUpdate;
    @XmlElementWrapper(name="Properties")
    @XmlElement(name="Property")
    private List<SoapClientObjectProperty> properties = null;
    @XmlElement(name="References")
    private List<SoapClientObjectReference> references = null;

    public int getObjId() {
        return this.obj_id;
    }

    public void setObjId(int id) {
        this.obj_id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLastUpdateString() {
        return this.lastUpdate;
    }

    public boolean isContainer() {
        return this.getType().compareTo("file") != 0;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public Date getLastUpdate() {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = format.parse(this.getLastUpdateString());
            return date;
        }
        catch (ParseException ex) {
            logger.warning("Cannot parse date " + this.getLastUpdateString());
            return new Date();
        }
    }

    public List<SoapClientObjectProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<SoapClientObjectProperty>();
            return this.properties;
        }
        return this.properties;
    }

    public List<SoapClientObjectProperty> getPropertiesByName(String name) {
        ArrayList<SoapClientObjectProperty> props = new ArrayList<SoapClientObjectProperty>();
        for (SoapClientObjectProperty prop : this.getProperties()) {
            if (!name.equalsIgnoreCase(prop.getName())) continue;
            props.add(prop);
        }
        return props;
    }

    public String getPropertyByName(String name) {
        for (SoapClientObjectProperty prop : this.getProperties()) {
            if (!prop.getName().equalsIgnoreCase(name)) continue;
            return prop.getValue();
        }
        return "";
    }

    public List<SoapClientObjectReference> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<SoapClientObjectReference>();
            return this.references;
        }
        return this.references;
    }

    public int getRefId() {
        Iterator<SoapClientObjectReference> ite = this.getReferences().iterator();
        if (ite.hasNext()) {
            SoapClientObjectReference ref = ite.next();
            return ref.getRefId();
        }
        return 0;
    }

    public int getParentId() {
        for (SoapClientObjectReference ref : this.getReferences()) {
            if (ref.getParentId() <= 0) continue;
            return ref.getParentId();
        }
        return 0;
    }
}

